/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class DynamicTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon("fugue/hard-hat");
    private JLabel view;
    private BGTextField classChooser;
    private BGConfigEditorPane configEditor;
    private String className;
    private String config;

    @Override
    protected JPanel getEditorPanel() {
        JPanel editor = new JPanel(new GridBagLayout());
        this.classChooser = new BGTextField();
        this.configEditor = new BGConfigEditorPane();
        editor.add((Component)new JLabel("\u041a\u043b\u0430\u0441\u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        editor.add((Component)this.classChooser, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        editor.add((Component)new JLabel("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 3, 0), 0, 0));
        editor.add((Component)new JScrollPane(this.configEditor), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        editor.setPreferredSize(new Dimension(500, 200));
        return editor;
    }

    @Override
    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder("\u041a\u043b\u0430\u0441\u0441: ");
        sb.append(this.className);
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.className = Utils.maskNull(data.get("className"));
        data.remove("className");
        this.config = new Preferences(data).toString();
    }

    @Override
    protected void loadData() {
        this.extractData();
        this.classChooser.setText(this.className);
        this.configEditor.setText(this.config);
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("className", Utils.maskBlank(this.classChooser.getText(), ""));
        Preferences params = new Preferences(this.configEditor.getText(), "\n");
        for (Map.Entry<String, String> e : ((ParameterMap)params).entrySet()) {
            data.put(e.getKey(), e.getValue());
        }
        this.setDataInHash(data);
    }
}

