/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.math.BigDecimal;
import java.util.Set;

public class ContractLimitParameters {
    private Set<Integer> contractLabelIds;
    private int maxNotPayoffed;
    private int maxPartialPayoffed;
    private int maxExpiredForBlock;
    private int minDays;
    private int maxDays;
    private int delayDays;
    private int defaultMode = 0;
    private BigDecimal minSumm;
    private BigDecimal maxSumm;
    private BigDecimal minLimit;

    public ContractLimitParameters() {
    }

    public ContractLimitParameters(Set<Integer> contractLabelIds, int maxNotPayoffed, int maxPartialPayoffed, int maxExpiredForBlock, int minDays, int maxDays, int delayDays, int defaultMode, BigDecimal minSumm, BigDecimal maxSumm, BigDecimal minLimit) {
        this.contractLabelIds = contractLabelIds;
        this.maxDays = maxDays;
        this.maxExpiredForBlock = maxExpiredForBlock;
        this.maxNotPayoffed = maxNotPayoffed;
        this.maxPartialPayoffed = maxPartialPayoffed;
        this.maxSumm = maxSumm;
        this.minDays = minDays;
        this.minSumm = minSumm;
        this.minLimit = minLimit;
        this.delayDays = delayDays;
        this.defaultMode = defaultMode;
    }

    public Set<Integer> getContractLabelIds() {
        return this.contractLabelIds;
    }

    public int getDefaultMode() {
        return this.defaultMode;
    }

    @XmlAttribute
    public int getDelayDays() {
        return this.delayDays;
    }

    @XmlAttribute
    public long getGroups() {
        long groups = 0L;
        for (int id : this.contractLabelIds) {
            if (id >= 66) continue;
            groups |= (long)(1 << id - 2);
        }
        return groups;
    }

    @XmlAttribute
    public int getMaxDays() {
        return this.maxDays;
    }

    @XmlAttribute
    public int getMaxExpiredForBlock() {
        return this.maxExpiredForBlock;
    }

    @XmlAttribute
    public int getMaxNotPayoffed() {
        return this.maxNotPayoffed;
    }

    @XmlAttribute
    public int getMaxPartialPayoffed() {
        return this.maxPartialPayoffed;
    }

    @XmlAttribute
    public BigDecimal getMaxSumm() {
        return this.maxSumm;
    }

    @XmlAttribute
    public int getMinDays() {
        return this.minDays;
    }

    @XmlAttribute
    public BigDecimal getMinLimit() {
        return this.minLimit;
    }

    @XmlAttribute
    public BigDecimal getMinSumm() {
        return this.minSumm;
    }

    public ContractLimitParameters setCcontractLabelIds(Set<Integer> contractLabelIds) {
        this.contractLabelIds = contractLabelIds;
        return this;
    }

    public ContractLimitParameters setDefaultMode(int defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    public ContractLimitParameters setDelayDays(int delayDays) {
        this.delayDays = delayDays;
        return this;
    }

    public ContractLimitParameters setGroups(long groups) {
        return this;
    }

    public ContractLimitParameters setMaxDays(int maxDays) {
        this.maxDays = maxDays;
        return this;
    }

    public ContractLimitParameters setMaxExpiredForBlock(int maxExpiredForBlock) {
        this.maxExpiredForBlock = maxExpiredForBlock;
        return this;
    }

    public ContractLimitParameters setMaxNotPayoffed(int maxNotPayoffed) {
        this.maxNotPayoffed = maxNotPayoffed;
        return this;
    }

    public ContractLimitParameters setMaxPartialPayoffed(int maxPartialPayoffed) {
        this.maxPartialPayoffed = maxPartialPayoffed;
        return this;
    }

    public ContractLimitParameters setMaxSumm(BigDecimal maxSumm) {
        this.maxSumm = maxSumm;
        return this;
    }

    public ContractLimitParameters setMinDays(int minDays) {
        this.minDays = minDays;
        return this;
    }

    public ContractLimitParameters setMinLimit(BigDecimal minLimit) {
        this.minLimit = minLimit;
        return this;
    }

    public ContractLimitParameters setMinSumm(BigDecimal minSumm) {
        this.minSumm = minSumm;
        return this;
    }
}

