/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.plugincfg.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.plugincfg.common.PluginItem;

public class PlugincfgDao {
    private Connection con;

    public PlugincfgDao(Connection con) {
        this.con = con;
    }

    public List<PluginItem> getPlugins() throws BGException {
        try {
            ArrayList<PluginItem> list = new ArrayList<PluginItem>();
            String query = "SELECT t1.id, t1.title, t1.name, t1.enabled FROM installed_modules as t1 WHERE type='plugin'";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            return list;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    protected PluginItem getFromRS(ResultSet rs) throws SQLException, BGException {
        PluginItem pi = new PluginItem();
        pi.setId(rs.getInt("id"));
        pi.setName(rs.getString("name"));
        pi.setTitle(rs.getString("title"));
        pi.setEnabled(rs.getBoolean("enabled"));
        return pi;
    }

    public PluginItem getPlugin(int id) throws BGException {
        try {
            PluginItem pi = new PluginItem();
            String query = "SELECT t1.id, t1.title, t1.name, t1.enabled FROM installed_modules as t1 WHERE t1.id = ? AND t1.type='plugin'";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                pi = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
            query = "SELECT config FROM plugin_config WHERE pid=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                pi.setConfig(rs.getString(1));
            }
            rs.close();
            ps.close();
            return pi;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void updateEnable(int id, boolean enable) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE installed_modules SET enabled=? WHERE id=?");){
            ps.setBoolean(1, enable);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void updatePluginConfig(int id, String config) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO plugin_config VALUES( ?, ? ) ON DUPLICATE KEY UPDATE config=?");){
            ps.setInt(1, id);
            ps.setString(2, config);
            ps.setString(3, config);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }
}

