/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.runner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.client.runner.BGClientRunnerDbInfo;
import ru.bitel.bgbilling.client.runner.BGClientRunnerDbInfoManager;
import ru.bitel.bgbilling.client.runner.BGClientRunnerUtil;
import ru.bitel.bgbilling.client.runner.json.JSONArray;
import ru.bitel.bgbilling.client.runner.json.JSONObject;

public class BGClientRunner
extends JFrame {
    private static final String OS_NAME_LINUX = "linux";
    private static final String OS_NAME_BSD = "bsd";
    private static final String OS_NAME_MAC_OS = "mac os";
    private static final String OS_NAME_WINDOWS = "windows";
    private static final String ACTION_COMMAND_EDIT = "edit";
    private static final String ACTION_COMMAND_DELETE = "delete";
    private static final String ACTION_COMMAND_ADD_TO_FAVORITE = "addToFavorite";
    private static final String ACTION_COMMAND_DELETE_FROM_FAVORITE = "deleteFromFavorite";
    private static final String icon = "/img/bg.png";
    private String currentVMArgs = "";
    private boolean editMode = false;
    private boolean runMode = false;
    private JButton runButton = null;
    private JPopupMenu popupMenu = null;
    private BGClientRunnerDbInfo dbInfo = null;
    private JLabel infoLabel = new JLabel("");
    private FavoriteModeButton allModeButton = null;
    private FavoriteModeButton favoriteModeButton = null;
    private Dimension dimension = new Dimension(50, 26);
    private JList<BGClientRunnerDbInfo> list = new JList();
    private RunnerTextField serverTitle = new RunnerTextField();
    private RunnerTextField serverURL = new RunnerTextField();
    private RunnerTextField serverJavaHome = new RunnerTextField();
    private RunnerTextField serverLogin = new RunnerTextField(14);
    private RunnerTextField serverProxyHost = new RunnerTextField(23);
    private RunnerTextField serverProxyPort = new RunnerTextField(5);
    private RunnerTextField serverDebugMax = new RunnerTextField(5);
    private RunnerPasswordField serverPassword = new RunnerPasswordField(14);
    private JLabel serverPasswordEye = new JLabel("\ud83d\udc41");
    private JCheckBox serverDebug = new JCheckBox("\u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043b\u0430\u0434\u043a\u0438");
    private JCheckBox serverSaveAccount = new JCheckBox("\u0437\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u043b\u043e\u0433\u0438\u043d \u0438 \u043f\u0430\u0440\u043e\u043b\u044c");
    private JCheckBox serverFavorite = new JCheckBox("\u0438\u0437\u0431\u0440\u0430\u043d\u043d\u044b\u0439");
    private ButtonGroup favoriteButtonGroup = new ButtonGroup();
    private ServersListSelectionListener listSelectionListener = new ServersListSelectionListener();
    private RunButtonAction runButtonAction = new RunButtonAction("\u0412\u043e\u0439\u0442\u0438");
    private SaveButtonAction saveButtonAction = new SaveButtonAction("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    private CancelButtonAction cancelButtonAction = new CancelButtonAction("\u041e\u0442\u043c\u0435\u043d\u0430");
    private VMArgumentsButtonAction argumentsButtonAction = new VMArgumentsButtonAction();
    private BGClientRunnerDbInfoManager dbInfoManager = BGClientRunnerDbInfoManager.getManager();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private JMenuItem addFavMenuItem = null;
    private JMenuItem deleteFavMenuItem = null;
    private SettingsButtonAction settingsButtonAction = new SettingsButtonAction();
    private static final String[] PREFERRED_VMARGS = new String[]{"-Dfile.encoding=UTF-8"};

    public BGClientRunner(String[] args) {
        this(args, null);
    }

    public BGClientRunner(String[] args, BGClientRunnerDbInfo dbInfo) {
        URL url;
        JOptionPane.setRootFrame(this);
        BGClientRunnerDbInfo autostartDbInfo = null;
        for (String arg : args) {
            if (!arg.startsWith("autostart=")) continue;
            String serverKey = arg.substring(10);
            if (serverKey.equals("default")) {
                serverKey = this.dbInfoManager.getDefaultServerKey();
            }
            autostartDbInfo = this.dbInfoManager.getBGClientRunnerDbInfo(serverKey);
        }
        this.dbInfo = autostartDbInfo != null ? autostartDbInfo : (dbInfo != null ? dbInfo : this.dbInfoManager.getBGClientRunnerDbInfo(this.dbInfoManager.getDefaultServerKey()));
        this.setTitle("BGBilling Runner: \u0412\u044b\u0431\u043e\u0440 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
        this.setDefaultCloseOperation(0);
        this.add(this.getMainPanel());
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setCurrentMode();
        this.setServersList();
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", this.cancelButtonAction);
        if (autostartDbInfo != null) {
            this.runButtonAction.actionPerformed(new ActionEvent(this, 1001, ""));
        }
        if ((url = BGClientRunner.class.getResource(icon)) != null) {
            this.setIconImage(this.getToolkit().createImage(url));
        }
    }

    private JPanel getMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getServersPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 15, 5, 5), 0, 0));
        panel.add((Component)this.getServerPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 15), 0, 0));
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 15, 15, 15), 0, 0));
        return panel;
    }

    private JPanel getServersPanel() {
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!BGClientRunner.this.list.isSelectionEmpty() && SwingUtilities.isRightMouseButton(mouseEvent) && BGClientRunner.this.list.locationToIndex(mouseEvent.getPoint()) == BGClientRunner.this.list.getSelectedIndex() && BGClientRunner.this.list.getSelectedIndex() > 0) {
                    JPopupMenu popupMenu = BGClientRunner.this.getPopupMenu();
                    BGClientRunnerDbInfo dbInfo = BGClientRunner.this.list.getSelectedValue();
                    BGClientRunner.this.addFavMenuItem.setEnabled(!dbInfo.isFavorite());
                    BGClientRunner.this.deleteFavMenuItem.setEnabled(dbInfo.isFavorite());
                    popupMenu.show(BGClientRunner.this.list, mouseEvent.getX(), mouseEvent.getY());
                } else if (!BGClientRunner.this.list.isSelectionEmpty() && mouseEvent.getClickCount() == 2) {
                    BGClientRunner.this.runButton.doClick();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.list);
        Dimension dimension = new Dimension(230, 300);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 3, 5));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(" \u0421\u043f\u0438\u0441\u043e\u043a \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u0432 "));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getServersFavoritePanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        return panel;
    }

    private JPanel getServersFavoritePanel() {
        ActionListener favoriteActionListener = e -> {
            this.dbInfoManager.setServersListMode(this.favoriteButtonGroup.getSelection().getActionCommand());
            this.saveServersConfig();
            this.setServersList();
        };
        this.allModeButton = new FavoriteModeButton("\u0432\u0441\u0435", "all", true, this.favoriteButtonGroup, favoriteActionListener);
        this.favoriteModeButton = new FavoriteModeButton("\u0438\u0437\u0431\u0440\u0430\u043d\u043d\u044b\u0435", "favorite", false, this.favoriteButtonGroup, favoriteActionListener);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.allModeButton);
        panel.add(this.favoriteModeButton);
        return panel;
    }

    private JPanel getServerPanel() {
        JPanel extendServerParamPanel = this.getExtendServerParamPanel();
        JPanel panel = new JPanel(new GridBagLayout());
        int gridy = 0;
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.serverTitle, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0435\u0440\u0432\u0435\u0440:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.serverURL, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getLoginPasswordPanel(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.serverSaveAccount, new GridBagConstraints(0, gridy++, 3, 1, 1.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.serverSaveAccount.setToolTipText("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u0434\u043b\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0432\u0445\u043e\u0434\u0430 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (\u043f\u0430\u0440\u043e\u043b\u044c \u043c\u043e\u0436\u0435\u0442 \u043d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c\u0441\u044f, \u0435\u0441\u043b\u0438 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435)");
        panel.add((Component)new AddServerParamLabel(extendServerParamPanel), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)extendServerParamPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getLoginPasswordPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 3), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 0), 0, 0));
        panel.add((Component)this.serverLogin, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)this.serverPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.serverPasswordEye, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 3, 0, 0), 0, 0));
        this.serverPasswordEye.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                BGClientRunner.this.serverPassword.setMasked(true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BGClientRunner.this.serverPassword.setMasked(false);
            }
        });
        return panel;
    }

    private JPanel getExtendServerParamPanel() {
        this.serverFavorite.addActionListener(e -> {
            BGClientRunnerDbInfo dbInfo = this.list.getSelectedValue();
            if (dbInfo == null || dbInfo.getDbServerKey() == null) {
                return;
            }
            dbInfo.setFavorite(this.serverFavorite.isSelected());
            this.saveServersConfig();
        });
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setVisible(false);
        panel.add((Component)new JLabel("Java Home:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.serverJavaHome, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u043f\u0440\u043e\u043a\u0441\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.getProxyPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.serverFavorite, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getDebugPanel(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getDebugPanel() {
        this.serverDebugMax.setText("1500");
        this.serverDebugMax.setToolTipText("\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 1500");
        this.serverDebugMax.setHorizontalAlignment(0);
        this.serverDebug.setToolTipText("\u0432\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0434\u043e\u043f.\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u0442\u043b\u0430\u0434\u043a\u0438 \u043e\u0431\u043c\u0435\u043d\u0430 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.serverDebug, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.serverDebugMax, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JButton(this.argumentsButtonAction), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getProxyPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.serverProxyHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(" : "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.serverProxyPort, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel() {
        this.runButton = new JButton(this.runButtonAction);
        JButton settingsButton = new JButton(this.settingsButtonAction);
        Insets m = settingsButton.getMargin();
        settingsButton.setMargin(new Insets(m.top, 2, m.bottom, 2));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)settingsButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)this.infoLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.runButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 5), 0, 0));
        panel.add((Component)new JButton(this.cancelButtonAction), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private void setServersList() {
        ArrayList<BGClientRunnerDbInfo> dBInfoList = new ArrayList<BGClientRunnerDbInfo>();
        ArrayList<BGClientRunnerDbInfo> allList = new ArrayList<BGClientRunnerDbInfo>(this.dbInfoManager.getInfoLists());
        if ("favorite".equals(this.dbInfoManager.getServersListMode())) {
            dBInfoList.addAll(allList.stream().filter(w -> w.isFavorite()).collect(Collectors.toList()));
        } else {
            dBInfoList.addAll(allList);
        }
        BGClientRunnerDbInfo newDbInfo = new BGClientRunnerDbInfo();
        newDbInfo.setDbServerTitle("< \u041d\u043e\u0432\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440 >");
        DefaultListModel<BGClientRunnerDbInfo> defaultListModel = new DefaultListModel<BGClientRunnerDbInfo>();
        defaultListModel.addElement(newDbInfo);
        for (BGClientRunnerDbInfo dbInfo : dBInfoList) {
            defaultListModel.addElement(dbInfo);
        }
        this.list.removeListSelectionListener(this.listSelectionListener);
        this.list.setModel(defaultListModel);
        this.setServerData();
        this.list.addListSelectionListener(this.listSelectionListener);
        this.list.setSelectedValue(this.dbInfo, true);
    }

    private void setServerData() {
        BGClientRunnerDbInfo dbInfo = this.list.getSelectedValue();
        if (dbInfo != null) {
            this.serverTitle.setText(dbInfo.getDbServerTitle());
            this.serverURL.setText(dbInfo.getDbServerURL());
            this.serverLogin.setText(dbInfo.getDbServerLogin());
            this.serverPassword.setText(dbInfo.getDbServerPassword());
            this.serverJavaHome.setText(dbInfo.getDbServerJavaHome());
            this.serverProxyHost.setText(dbInfo.getDbServerProxyHost());
            this.serverProxyPort.setText(dbInfo.getDbServerProxyPort());
            this.serverSaveAccount.setSelected(dbInfo.isSaveAccount());
            this.serverFavorite.setSelected(dbInfo.isFavorite());
            this.currentVMArgs = dbInfo.getDbServerVMArgs();
            this.setEditMode(dbInfo.getDbServerKey() == null);
        } else {
            this.serverTitle.setText("");
            this.serverURL.setText("");
            this.serverLogin.setText("");
            this.serverPassword.setText("");
            this.serverJavaHome.setText("");
            this.serverProxyHost.setText("");
            this.serverProxyPort.setText("");
            this.serverSaveAccount.setSelected(false);
            this.serverFavorite.setSelected(false);
            this.currentVMArgs = "";
            this.setEditMode(false);
        }
        this.runButtonAction.setEnabled(dbInfo != null);
        this.serverPasswordEye.setVisible(this.serverPassword.getPassword().length == 0);
    }

    private void setCurrentMode() {
        String currentMode = this.dbInfoManager.getServersListMode();
        Enumeration<AbstractButton> enumeration = this.favoriteButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!currentMode.equals(abstractButton.getActionCommand())) continue;
            abstractButton.setSelected(true);
            break;
        }
    }

    private void saveServersConfig() {
        BGClientRunnerUtil.saveServersConfig(this.dbInfoManager.getInfoLists(), this.dbInfoManager.getDefaultServerKey(), this.dbInfoManager.getServersListMode(), this.dbInfoManager.isAnySSL());
    }

    private void setEditMode(boolean editMode) {
        this.editMode = editMode;
        this.serverTitle.setEnabled(editMode);
        this.serverURL.setEnabled(editMode);
        this.serverJavaHome.setEnabled(editMode);
        this.serverProxyHost.setEnabled(editMode);
        this.serverProxyPort.setEnabled(editMode);
        this.serverFavorite.setEnabled(editMode);
        this.list.setEnabled(!editMode);
        this.allModeButton.setEnabled(!editMode);
        this.favoriteModeButton.setEnabled(!editMode);
        this.runButton.setAction(editMode ? this.saveButtonAction : this.runButtonAction);
    }

    private void setRunMode(boolean runMode) {
        this.runMode = runMode;
        this.list.setEnabled(!runMode);
        this.allModeButton.setEnabled(!runMode);
        this.favoriteModeButton.setEnabled(!runMode);
        this.serverLogin.setEditable(!runMode);
        this.serverPassword.setEditable(!runMode);
        this.runButton.setEnabled(!runMode);
    }

    public BGClientRunnerDbInfo getDbInfo() {
        return this.dbInfo;
    }

    public void setDbInfo(BGClientRunnerDbInfo dbInfo) {
        if (dbInfo == null) {
            dbInfo = this.dbInfoManager.getBGClientRunnerDbInfo(this.dbInfoManager.getDefaultServerKey());
        }
        this.dbInfo = dbInfo;
        if (dbInfo == null) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedValue(dbInfo, true);
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            ActionListener actionListener = e -> {
                String actionCommand = e.getActionCommand();
                if (ACTION_COMMAND_EDIT.equals(actionCommand)) {
                    this.setEditMode(true);
                } else if (ACTION_COMMAND_DELETE.equals(actionCommand)) {
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440?", "\u0417\u0430\u043f\u0440\u043e\u0441", 0, 3) == 0) {
                        this.dbInfoManager.removeServer(this.list.getSelectedValue());
                        this.dbInfo = null;
                        this.setServersList();
                    }
                } else if (ACTION_COMMAND_ADD_TO_FAVORITE.equals(actionCommand) || ACTION_COMMAND_DELETE_FROM_FAVORITE.equals(actionCommand)) {
                    this.list.getSelectedValue().setFavorite(ACTION_COMMAND_ADD_TO_FAVORITE.equals(actionCommand));
                    this.saveServersConfig();
                    this.setServersList();
                }
            };
            this.popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
            menuItem.addActionListener(actionListener);
            menuItem.setActionCommand(ACTION_COMMAND_EDIT);
            this.popupMenu.add(menuItem);
            menuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
            menuItem.addActionListener(actionListener);
            menuItem.setActionCommand(ACTION_COMMAND_DELETE);
            this.popupMenu.add(menuItem);
            this.addFavMenuItem = new JMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u0438\u0437\u0431\u0440\u0430\u043d\u043d\u043e\u0435");
            this.addFavMenuItem.addActionListener(actionListener);
            this.addFavMenuItem.setActionCommand(ACTION_COMMAND_ADD_TO_FAVORITE);
            this.popupMenu.add(this.addFavMenuItem);
            this.deleteFavMenuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0438\u0437\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e");
            this.deleteFavMenuItem.addActionListener(actionListener);
            this.deleteFavMenuItem.setActionCommand(ACTION_COMMAND_DELETE_FROM_FAVORITE);
            this.popupMenu.add(this.deleteFavMenuItem);
        }
        return this.popupMenu;
    }

    private void doLoad() {
        this.infoLabel.setText("");
        if (this.dbInfo != null) {
            if (!this.serverLogin.getText().matches("^\\S+$")) {
                BGClientRunnerUtil.showError("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u043f\u043e\u043b\u0435 \"\u041b\u043e\u0433\u0438\u043d\"");
                return;
            }
            if (String.valueOf(this.serverPassword.getPassword()).trim().length() == 0) {
                BGClientRunnerUtil.showError("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u043f\u043e\u043b\u0435 \"\u041f\u0430\u0440\u043e\u043b\u044c\"");
                return;
            }
            this.infoLabel.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
            this.dbInfo.setDbServerLogin(this.serverSaveAccount.isSelected() ? this.serverLogin.getText() : null);
            this.dbInfo.setDbServerPassword(this.serverSaveAccount.isSelected() ? this.serverPassword.getPassword() : null);
            this.dbInfo.setSaveAccount(this.serverSaveAccount.isSelected());
            this.dbInfoManager.setDefaultServerKey(this.dbInfo.getDbServerKey());
            this.saveServersConfig();
            this.setRunMode(true);
            this.infoLabel.setText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u043f\u0438\u0441\u043a\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a");
            try {
                new Loader(this).start();
            }
            catch (Exception e) {
                BGClientRunnerUtil.showError("\u041e\u0448\u0438\u0431\u043a\u0430 - " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            BGClientRunnerUtil.showError("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440!");
        }
    }

    private void updateLibCache(Map<String, String> currentClientLibMap) {
        HashMap<CallSite, Date> cacheClientLibMap = new HashMap<CallSite, Date>();
        File libsFolder = BGClientRunnerUtil.getUserFolderForFile("libs");
        if (libsFolder.exists() && libsFolder.isDirectory()) {
            for (File dir : libsFolder.listFiles()) {
                if (dir == null || !dir.isDirectory()) continue;
                String name = dir.getName();
                for (File file : dir.listFiles()) {
                    if (file == null || !file.isFile()) continue;
                    String hash = file.getName();
                    hash = hash.substring(0, hash.length() - 4);
                    cacheClientLibMap.put((CallSite)((Object)(name + " " + hash)), new Date());
                }
            }
        }
        try {
            JSONObject cacheJsonObject;
            File cacheFile = BGClientRunnerUtil.getLocalFile("cache.json");
            String cacheConfig = BGClientRunnerUtil.readFile(cacheFile);
            if (cacheConfig.length() > 0 && (cacheJsonObject = new JSONObject(cacheConfig)).has("libs")) {
                JSONArray libsJSONArray = cacheJsonObject.getJSONArray("libs");
                for (int index = 0; index < libsJSONArray.length(); ++index) {
                    JSONObject libJSONObject = libsJSONArray.getJSONObject(index);
                    String key = libJSONObject.getString("name") + " " + libJSONObject.getString("hash");
                    if (!cacheClientLibMap.containsKey(key)) continue;
                    cacheClientLibMap.put((CallSite)((Object)key), this.dateFormat.parse(libJSONObject.getString("time")));
                }
            }
            for (Map.Entry<String, String> mapEntry : currentClientLibMap.entrySet()) {
                cacheClientLibMap.put((CallSite)((Object)(mapEntry.getKey() + " " + mapEntry.getValue())), new Date());
            }
            long period = Long.parseLong(System.getProperty("bg.client.runner.cache.period", "15"));
            Date now = new Date();
            HashMap<String, Date> cacheForSaveClientLibMap = new HashMap<String, Date>();
            for (Map.Entry mapEntry : cacheClientLibMap.entrySet()) {
                Date libDate = (Date)mapEntry.getValue();
                if (now.getTime() - libDate.getTime() > period * 24L * 3600L * 1000L) {
                    String[] nameHash = ((String)mapEntry.getKey()).split(" ");
                    File userLibFolder = BGClientRunnerUtil.getUserFolderForFile(File.separator + "libs" + File.separator + nameHash[0]);
                    File libNameFile = new File(userLibFolder, nameHash[1] + ".jar");
                    if (libNameFile.exists() && libNameFile.isFile()) {
                        libNameFile.delete();
                    }
                    if (!userLibFolder.isDirectory() || userLibFolder.list().length != 0) continue;
                    userLibFolder.delete();
                    continue;
                }
                cacheForSaveClientLibMap.put((String)mapEntry.getKey(), (Date)mapEntry.getValue());
            }
            if (cacheFile != null && cacheFile.canWrite()) {
                JSONObject cacheJsonObject2 = new JSONObject();
                JSONArray libsJSONArray = new JSONArray();
                for (Map.Entry mapEntry : cacheForSaveClientLibMap.entrySet()) {
                    String[] nameHash = ((String)mapEntry.getKey()).split(" ");
                    JSONObject libJSONObject = new JSONObject();
                    libJSONObject.put("name", nameHash[0]);
                    libJSONObject.put("hash", nameHash[1]);
                    libJSONObject.put("time", this.dateFormat.format((Date)mapEntry.getValue()));
                    libsJSONArray.put(libJSONObject);
                }
                cacheJsonObject2.put("libs", libsJSONArray);
                BGClientRunnerUtil.saveFile(cacheFile, cacheJsonObject2.toString(2));
            }
        }
        catch (Exception e) {
            BGClientRunnerUtil.showError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u044d\u0448\u0430 - " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        boolean runFromIDE = Boolean.getBoolean("runFromIDE");
        if (!runFromIDE) {
            int maxIndex = 1;
            long time = System.currentTimeMillis() - 432000000L;
            File logDir = BGClientRunnerUtil.getUserFolderForFile("log");
            if (!logDir.exists() && !logDir.mkdirs()) {
                System.err.println("error make log directory " + logDir.getAbsolutePath() + " ?");
            }
            if (!logDir.isDirectory() || !logDir.canWrite()) {
                System.err.println("error access to log directory " + logDir.getAbsolutePath() + ", will be written to syserr/sysout");
            } else {
                for (File file : logDir.listFiles()) {
                    String fileName = file.getName();
                    if (!fileName.endsWith(".log") || !fileName.startsWith("runner_") && !fileName.startsWith("debug_")) continue;
                    if (file.lastModified() < time) {
                        file.delete();
                        continue;
                    }
                    try {
                        maxIndex = Math.max(maxIndex, Integer.valueOf(fileName.substring(0, fileName.length() - 4).substring(7)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                while (true) {
                    File logFileName;
                    if (!(logFileName = new File(logDir, String.format("runner_%03d.log", maxIndex))).exists()) {
                        PrintStream printStream = new PrintStream(logFileName);
                        System.setOut(printStream);
                        System.setErr(printStream);
                        break;
                    }
                    ++maxIndex;
                }
            }
        }
        new BGClientRunner(args).setVisible(true);
    }

    class FavoriteModeButton
    extends JRadioButton {
        FavoriteModeButton(String text, String actionCommand, boolean selected, ButtonGroup buttonGroup, ActionListener actionListener) {
            super(text);
            this.setActionCommand(actionCommand);
            this.setSelected(selected);
            buttonGroup.add(this);
            this.addActionListener(actionListener);
        }
    }

    class RunnerTextField
    extends JTextField {
        RunnerTextField() {
            this(30);
        }

        RunnerTextField(int column) {
            super(column);
            this.setMinimumSize(BGClientRunner.this.dimension);
            this.setPreferredSize(BGClientRunner.this.dimension);
        }
    }

    class RunnerPasswordField
    extends JPasswordField {
        RunnerPasswordField() {
            this(30);
        }

        void setMasked(boolean ismasked) {
            this.setEchoChar(ismasked ? (char)'*' : '\u0000');
        }

        RunnerPasswordField(int column) {
            super(column);
            this.setMinimumSize(BGClientRunner.this.dimension);
            this.setPreferredSize(BGClientRunner.this.dimension);
        }
    }

    class ServersListSelectionListener
    implements ListSelectionListener {
        ServersListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                BGClientRunner.this.setServerData();
                BGClientRunner.this.dbInfo = BGClientRunner.this.list.getSelectedValue();
            }
        }
    }

    class RunButtonAction
    extends AbstractAction {
        RunButtonAction(String text) {
            super(text, null);
            this.putValue("ActionCommandKey", "run");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BGClientRunner.this.doLoad();
        }
    }

    class SaveButtonAction
    extends AbstractAction {
        SaveButtonAction(String text) {
            super(text, null);
            this.putValue("ActionCommandKey", "save");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BGClientRunner.this.dbInfo != null) {
                if (BGClientRunner.this.dbInfo.getDbServerKey() == null) {
                    BGClientRunner.this.dbInfo = new BGClientRunnerDbInfo();
                    BGClientRunner.this.dbInfo.setDbServerKey(BGClientRunnerUtil.randomAlphanumeric(10));
                    BGClientRunner.this.dbInfoManager.addServer(BGClientRunner.this.dbInfo);
                }
                BGClientRunner.this.dbInfo.setDbServerTitle(BGClientRunner.this.serverTitle.getText());
                BGClientRunner.this.dbInfo.setDbServerURL(BGClientRunner.this.serverURL.getText());
                BGClientRunner.this.dbInfo.setDbServerLogin(BGClientRunner.this.serverLogin.getText());
                BGClientRunner.this.dbInfo.setDbServerPassword(BGClientRunner.this.serverPassword.getPassword());
                BGClientRunner.this.dbInfo.setDbServerJavaHome(BGClientRunner.this.serverJavaHome.getText());
                BGClientRunner.this.dbInfo.setDbServerProxyHost(BGClientRunner.this.serverProxyHost.getText());
                BGClientRunner.this.dbInfo.setDbServerProxyPort(BGClientRunner.this.serverProxyPort.getText());
                BGClientRunner.this.dbInfo.setSaveAccount(BGClientRunner.this.serverSaveAccount.isSelected());
                BGClientRunner.this.dbInfo.setFavorite(BGClientRunner.this.serverFavorite.isSelected());
                BGClientRunner.this.dbInfo.setDbServerVMArgs(BGClientRunner.this.currentVMArgs);
                BGClientRunner.this.saveServersConfig();
                BGClientRunner.this.setEditMode(false);
                BGClientRunner.this.setServersList();
            }
        }
    }

    class CancelButtonAction
    extends AbstractAction {
        CancelButtonAction(String text) {
            super(text, null);
            this.putValue("ActionCommandKey", "cancel");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BGClientRunner.this.editMode) {
                BGClientRunner.this.setEditMode(false);
                BGClientRunner.this.list.revalidate();
                BGClientRunner.this.list.repaint();
                if (BGClientRunner.this.dbInfo == null || BGClientRunner.this.dbInfo.getDbServerKey() == null) {
                    BGClientRunner.this.dbInfo = null;
                    BGClientRunner.this.setServersList();
                }
            } else if (BGClientRunner.this.runMode) {
                BGClientRunner.this.setRunMode(false);
                BGClientRunner.this.infoLabel.setText("");
            } else {
                BGClientRunner.this.setVisible(false);
                BGClientRunner.this.dbInfo = null;
                BGClientRunner.this.dispose();
            }
        }
    }

    class VMArgumentsButtonAction
    extends AbstractAction {
        public VMArgumentsButtonAction() {
            super("VM arguments", null);
            this.putValue("ActionCommandKey", "vm");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VMArgumentsDialog dialog = new VMArgumentsDialog();
            dialog.setVisible(true);
            dialog.dispose();
        }
    }

    class SettingsButtonAction
    extends AbstractAction {
        public SettingsButtonAction() {
            super("\u26ed", null);
            this.putValue("ActionCommandKey", "settings");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new AboutAction());
            menu.add(new ClearCacheAction());
            JComponent button = (JComponent)e.getSource();
            menu.show(button, 0, button.getBounds().height);
        }
    }

    class AddServerParamLabel
    extends JLabel {
        private final String showText = "\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u043e\u043f\u043e\u043b. \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u25bc";
        private final String hideText = "\u0441\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u043f\u043e\u043b. \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u25b2";
        private final Font exitFont = new Font("SansSerif", 0, 12);
        private final Font enterFont = new Font("SansSerif", 0, 12);
        private boolean isShow = false;

        AddServerParamLabel(final JPanel extendServerParamPanel) {
            this.setText(this.getLabelText(false));
            this.setHorizontalAlignment(4);
            this.setFont(this.exitFont);
            this.setForeground(Color.DARK_GRAY);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    AddServerParamLabel.this.setFont(AddServerParamLabel.this.exitFont);
                    AddServerParamLabel.this.setForeground(Color.DARK_GRAY);
                    AddServerParamLabel.this.setCursor(Cursor.getPredefinedCursor(0));
                    AddServerParamLabel.this.setText(AddServerParamLabel.this.getLabelText(false));
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    AddServerParamLabel.this.setFont(AddServerParamLabel.this.enterFont);
                    AddServerParamLabel.this.setForeground(Color.BLACK);
                    AddServerParamLabel.this.setCursor(Cursor.getPredefinedCursor(12));
                    AddServerParamLabel.this.setText(AddServerParamLabel.this.getLabelText(true));
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AddServerParamLabel.this.isShow = !AddServerParamLabel.this.isShow;
                    AddServerParamLabel.this.setText(AddServerParamLabel.this.getLabelText(true));
                    extendServerParamPanel.setVisible(AddServerParamLabel.this.isShow);
                }
            });
        }

        private String getLabelText(boolean mouseOver) {
            StringBuffer text = new StringBuffer("<html><nobr>").append(mouseOver ? "<u>" : "").append(this.isShow ? "\u0441\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u043f\u043e\u043b. \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u25b2" : "\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u043e\u043f\u043e\u043b. \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u25bc").append(mouseOver ? "</u>" : "").append("</nobr></html>");
            return text.toString();
        }
    }

    class Loader
    extends Thread {
        private String clientVersion = "";
        private BGClientRunner clientRunner;
        private StringBuilder classPath = new StringBuilder();
        private Map<String, String> clientLibMap = new HashMap<String, String>();
        private BigDecimal billingMajorVersion = BigDecimal.ZERO;

        public Loader(BGClientRunner clientRunner) {
            this.clientRunner = clientRunner;
        }

        private void setInfoLabelText(String text) {
            this.setInfoLabelText(text, false);
        }

        private void setInfoLabelText(String text, boolean html) {
            this.clientRunner.infoLabel.setText((String)(html ? "<html>" + text.replace("\n", "<br>") + "</html>" : text));
            System.out.println(text.replace("\n", " "));
        }

        @Override
        public void run() {
            try {
                String newPassword = null;
                boolean needUpdateRunner = false;
                ArrayList<String> libNamesToDownload = new ArrayList<String>();
                this.setInfoLabelText("");
                boolean disableSavePassword = false;
                block13: while (true) {
                    String response = null;
                    try {
                        response = this.doCheckAuth(BGClientRunner.this.serverLogin.getText(), String.valueOf(BGClientRunner.this.serverPassword.getPassword()), newPassword, 2).toString();
                        if (response.isEmpty() || response.startsWith("auth=Error")) {
                            response = this.doCheckAuth(BGClientRunner.this.serverLogin.getText(), String.valueOf(BGClientRunner.this.serverPassword.getPassword()), newPassword, 1).toString();
                        }
                    }
                    catch (ConnectException ex1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438\u0447\u0438\u043d\u044b: \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d,\n\u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0430\u0434\u0440\u0435\u0441\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 " + (BGClientRunner.this.dbInfoManager.isAnySSL() ? "" : "\n(\u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u043b\u0430\u0433 anySSL=true)"), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                        throw new Exception("not");
                    }
                    catch (MalformedURLException ex1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + ex1.getLocalizedMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                        throw new Exception("not");
                    }
                    this.setInfoLabelText("\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u0438 \u0440\u0430\u0437\u0431\u043e\u0440 \u0441\u043f\u0438\u0441\u043a\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a");
                    for (String line : response.split("\n")) {
                        System.out.println(line);
                        if (line.startsWith("auth=")) {
                            if (!line.substring(5).equalsIgnoreCase("Ok")) {
                                BGClientRunnerUtil.showError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \"\u041b\u043e\u0433\u0438\u043d\" \u0438\\\u0438\u043b\u0438 \"\u041f\u0430\u0440\u043e\u043b\u044c\"");
                                BGClientRunner.this.setRunMode(false);
                                BGClientRunner.this.infoLabel.setText("");
                                return;
                            }
                            if (newPassword == null) continue;
                            BGClientRunner.this.serverPassword.setText(newPassword);
                            if (!BGClientRunner.this.serverSaveAccount.isSelected() || disableSavePassword) continue;
                            BGClientRunner.this.infoLabel.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
                            BGClientRunner.this.dbInfo.setDbServerPassword(BGClientRunner.this.serverSaveAccount.isSelected() ? newPassword : null);
                            BGClientRunner.this.saveServersConfig();
                            continue;
                        }
                        if (line.startsWith("need.change.password=true")) {
                            this.setInfoLabelText("\u0421\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f");
                            NewPasswordDialog dialog = new NewPasswordDialog(BGClientRunner.this.serverPassword.getPassword());
                            dialog.setVisible(true);
                            newPassword = dialog.getPassword();
                            dialog.dispose();
                            continue block13;
                        }
                        if (line.startsWith("disable.save.password=true")) {
                            disableSavePassword = true;
                            continue;
                        }
                        if (line.startsWith("version=")) {
                            this.setInfoLabelText("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 \u043a\u043b\u0438\u0435\u043d\u0442\u0430");
                            this.clientVersion = line.substring(8);
                            continue;
                        }
                        if (line.startsWith("billing.version=")) {
                            this.setInfoLabelText("\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0438 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                            try {
                                String billing_version = line.substring(16);
                                System.out.println("billing.version = " + billing_version);
                                if ("beta".equals(billing_version)) {
                                    billing_version = "99.9999";
                                }
                                this.billingMajorVersion = new BigDecimal(billing_version);
                            }
                            catch (Exception e) {
                                this.billingMajorVersion = BigDecimal.ZERO;
                            }
                            continue;
                        }
                        if (line.startsWith("lib=")) {
                            String[] libInfo = line.substring(4).split("\t");
                            this.clientLibMap.put(libInfo[0], libInfo[1]);
                            File userLibFolder = BGClientRunnerUtil.getUserFolderForFile("libs" + File.separator + libInfo[0]);
                            File libNameFile = new File(userLibFolder, libInfo[1] + ".jar");
                            if (!libNameFile.exists()) {
                                this.setInfoLabelText("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 (" + libInfo[0] + ") \u0432 \u0441\u043f\u0438\u0441\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043e\u043a");
                                libNamesToDownload.add(libInfo[0]);
                            }
                            if (this.classPath.length() > 0) {
                                this.classPath.append(File.pathSeparatorChar);
                            }
                            this.setInfoLabelText("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 (" + libInfo[0] + ") \u0432 classpath");
                            this.classPath.append(libNameFile.getPath());
                            continue;
                        }
                        if (!line.startsWith("runner.version=")) continue;
                        long localVersion = 0L;
                        long remoteVersion = Long.parseLong(line.substring(15));
                        try {
                            URI runnerDir = ClassLoader.getSystemResource("lib").toURI();
                            File libsDir = new File(runnerDir);
                            if (libsDir.exists() && libsDir.isDirectory()) {
                                for (File file : libsDir.listFiles()) {
                                    if (!file.isFile() || !file.getName().startsWith("runner_")) continue;
                                    localVersion = Long.parseLong(file.getName().substring(7, 17));
                                }
                            }
                        }
                        catch (Exception runnerDir) {
                            // empty catch block
                        }
                        needUpdateRunner = remoteVersion > localVersion;
                        System.out.println("needUpdateRunner = " + needUpdateRunner + " [remoteVersion = " + remoteVersion + "; localVersion = " + localVersion + "]");
                    }
                    break;
                }
                if (disableSavePassword) {
                    BGClientRunner.this.dbInfo.setDbServerPassword((String)null);
                    BGClientRunner.this.saveServersConfig();
                }
                if (!libNamesToDownload.isEmpty()) {
                    this.doUpdateLib(libNamesToDownload);
                }
                if (needUpdateRunner) {
                    this.doUpdateRunnerLib();
                }
                if (this.classPath.length() == 0) {
                    BGClientRunnerUtil.showError("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430.\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440.");
                    throw new Exception("not");
                }
                this.setInfoLabelText("\u0427\u0438\u0441\u0442\u043a\u0430 \u043a\u044d\u0448\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a");
                BGClientRunner.this.updateLibCache(this.clientLibMap);
                this.setInfoLabelText("\u0417\u0430\u043f\u0443\u0441\u043a \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0431\u0438\u043b\u043b\u0438\u0433\u0430");
                String osName = System.getProperty("os.name").toLowerCase();
                String fileSeparator = System.getProperty("file.separator");
                Object java = BGClientRunner.this.dbInfo.getDbServerJavaHome();
                if (java == null || ((String)java).trim().isEmpty()) {
                    java = System.getProperty("java.home");
                }
                boolean macOsNative = Boolean.getBoolean("macosNative");
                if (osName.equals(BGClientRunner.OS_NAME_LINUX) || osName.endsWith(BGClientRunner.OS_NAME_BSD) || osName.startsWith(BGClientRunner.OS_NAME_MAC_OS) && !macOsNative) {
                    java = Paths.get((String)java, "bin", "java").toString();
                } else if (macOsNative) {
                    java = "java";
                    String dbInfoJava = BGClientRunner.this.dbInfo.getDbServerJavaHome();
                    if (dbInfoJava != null && !dbInfoJava.trim().isEmpty()) {
                        java = Paths.get(dbInfoJava, "bin", "java").toString();
                    }
                } else if (osName.startsWith(BGClientRunner.OS_NAME_WINDOWS)) {
                    java = (String)java + fileSeparator + "bin" + fileSeparator + "java.exe";
                } else {
                    BGClientRunnerUtil.showError("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \"" + osName + "\" \u043f\u043e\u043a\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
                    throw new Exception("not");
                }
                ArrayList<String> command = new ArrayList<String>();
                command.add((String)java);
                if (BGClientRunner.this.serverDebug.isSelected()) {
                    command.add("-Dbgbilling.transfer.debug=true");
                    try {
                        command.add("-Ddebug.message.max.length=" + Integer.valueOf(BGClientRunner.this.serverDebugMax.getText()));
                    }
                    catch (Exception e) {
                        command.add("-Ddebug.message.max.length=1500");
                    }
                }
                if (BGClientRunner.this.currentVMArgs != null && !BGClientRunner.this.currentVMArgs.isEmpty()) {
                    for (String arg : BGClientRunner.this.currentVMArgs.split("(\n| )")) {
                        System.out.println("VMArg: " + arg);
                        command.add(arg);
                    }
                }
                File userRunFolder = null;
                if (osName.equals(BGClientRunner.OS_NAME_LINUX) || osName.endsWith(BGClientRunner.OS_NAME_BSD)) {
                    userRunFolder = this.doRunFolder(BGClientRunner.this.dbInfo.getDbServerKey());
                }
                if (userRunFolder != null) {
                    command.add("-cp");
                    command.add(userRunFolder.getPath() + File.separatorChar + "*");
                } else {
                    command.add("-classpath");
                    command.add(this.classPath.toString());
                }
                if (macOsNative) {
                    command.add("-Xdock:icon=../Resources/BGRunner.icns");
                }
                if (this.billingMajorVersion.doubleValue() > 9.2303) {
                    block17: for (String preferredVmarg : PREFERRED_VMARGS) {
                        String[] kv = preferredVmarg.split("=");
                        for (String currArg : command) {
                            if (!currArg.startsWith(kv[0])) continue;
                            continue block17;
                        }
                        System.out.println("preferred VMArg: " + preferredVmarg);
                        command.add(preferredVmarg);
                    }
                }
                command.add("ru.bitel.bgbilling.client.BGClientR");
                command.add("clientVersion=" + this.clientVersion);
                command.add("dbInfo=" + BGClientRunner.this.dbInfo.getDbServerKey());
                if (!BGClientRunner.this.dbInfo.isSaveAccount() || disableSavePassword) {
                    command.add("dbAuth=" + BGClientRunnerCipher.cipher(BGClientRunner.this.serverLogin.getText() + "\t" + String.valueOf(BGClientRunner.this.serverPassword.getPassword()), false));
                }
                for (String arg : command) {
                    System.out.print(arg);
                    System.out.print(" ");
                }
                try {
                    ProcessBuilder processBuilder = new ProcessBuilder(command);
                    File logDir = BGClientRunnerUtil.getUserFolderForFile("log");
                    final File file = new File(logDir, "debug_" + BGClientRunner.this.dbInfo.getDbServerKey() + "_" + System.currentTimeMillis() / 1000L + ".log");
                    processBuilder.redirectErrorStream(true);
                    processBuilder.redirectOutput(file);
                    final Process process = processBuilder.start();
                    new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                                if (!process.isAlive()) {
                                    String result = BGClientRunnerUtil.readFile(file);
                                    if ((result = BGClientRunnerUtil.checkUnsupportedClassVersionError(result)).isEmpty()) {
                                        result = "\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0432 log-\u0444\u0430\u0439\u043b\u0430\u0445 (\u0434\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u043f\u0430\u043f\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f, \u043a\u0430\u0442\u0430\u043b\u043e\u0433 .bgbilling).";
                                    }
                                    JTextArea message = new JTextArea(10, 70);
                                    message.setMargin(new Insets(3, 3, 3, 3));
                                    message.setWrapStyleWord(true);
                                    message.setLineWrap(true);
                                    message.setText(result);
                                    JScrollPane scrollPane = new JScrollPane(message);
                                    JOptionPane.showMessageDialog(BGClientRunner.this, scrollPane, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 JVM", 0);
                                } else {
                                    BGClientRunner.this.setVisible(false);
                                    BGClientRunner.this.dispose();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.run();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(BGClientRunner.this, e.getLocalizedMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430", 0);
                }
            }
            catch (Exception ex) {
                this.setInfoLabelText("");
                if (!"not".equals(ex.getMessage())) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.toString(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    ex.printStackTrace();
                }
                BGClientRunner.this.setRunMode(false);
            }
        }

        private StringBuilder doCheckAuth(String userName, String userPassword, String newUserPassword, int version) throws Exception, ConnectException {
            StringBuilder result = new StringBuilder();
            StringBuilder outputText = new StringBuilder();
            if (newUserPassword != null) {
                outputText.append("newUserPassword=").append(URLEncoder.encode(newUserPassword, "UTF-8"));
            }
            URLConnection urlConnection = null;
            if (version == 2) {
                String[][] headers = new String[][]{{"Authorization", "Basic " + Base64.getEncoder().encodeToString((userName + ":" + userPassword).getBytes("UTF-8"))}};
                urlConnection = BGClientRunnerUtil.getHttpURLConnection(this.getServerUrl(), headers, "POST", outputText.length() > 0 ? outputText.toString() : null, BGClientRunner.this.dbInfoManager.isAnySSL());
            } else if (version == 1) {
                outputText.append(outputText.length() > 0 ? "&" : "").append("userName=").append(URLEncoder.encode(userName, "UTF-8")).append("&userPassword=").append(URLEncoder.encode(userPassword, "UTF-8"));
                urlConnection = BGClientRunnerUtil.getHttpURLConnection(this.getServerUrl(), null, "POST", outputText.toString(), BGClientRunner.this.dbInfoManager.isAnySSL());
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                if (bufferedReader.ready()) {
                    String line = null;
                    while ((line = bufferedReader.readLine()) != null) {
                        result.append(line).append("\n");
                    }
                }
            }
            catch (FileNotFoundException e) {
                BGClientRunnerUtil.showError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 - " + e.getLocalizedMessage());
            }
            ((HttpURLConnection)urlConnection).disconnect();
            return result;
        }

        private void doUpdateLib(List<String> libNames) throws Exception {
            int len;
            StringBuilder outputText = new StringBuilder();
            for (String libName : libNames) {
                outputText.append(outputText.length() > 0 ? "&" : "").append("libName=").append(URLEncoder.encode(libName, "UTF-8"));
            }
            this.setInfoLabelText("\u0417\u0430\u043f\u0443\u0441\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a");
            HttpURLConnection urlConnection = BGClientRunnerUtil.getHttpURLConnection(this.getServerUrl(), null, "POST", outputText.toString(), BGClientRunner.this.dbInfoManager.isAnySSL());
            InputStream inputStream = urlConnection.getInputStream();
            while ((len = inputStream.read()) != -1) {
                String libName = new String(BGClientRunnerUtil.getBytes(inputStream, len), "UTF-8");
                this.setInfoLabelText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 " + libName);
                len = inputStream.read();
                String hash = new String(BGClientRunnerUtil.getBytes(inputStream, len), "UTF-8");
                File userLibFolder = BGClientRunnerUtil.getUserFolderForFile("libs" + File.separator + libName);
                File libNameFile = new File(userLibFolder, hash + ".jar");
                if (libNameFile.exists() && libNameFile.isFile()) {
                    libNameFile.delete();
                }
                this.loadLib(inputStream, libNameFile, libName);
                try {
                    if (hash.equals(BGClientRunnerUtil.sha256Hex(libNameFile))) continue;
                    this.setInfoLabelText("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0445\u0435\u0448 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 " + libName, false);
                    BGClientRunnerUtil.showError("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0445\u0435\u0448 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 " + libName);
                }
                catch (Exception e) {
                    this.setInfoLabelText("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0445\u0435\u0448\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 " + libName, false);
                    e.printStackTrace();
                    BGClientRunnerUtil.showError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0445\u0435\u0448\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 " + libName);
                }
            }
            urlConnection.disconnect();
        }

        private void doUpdateRunnerLib() throws Exception {
            HttpURLConnection urlConnection = BGClientRunnerUtil.getHttpURLConnection(this.getServerUrl(), null, "POST", "updateRunner=true", BGClientRunner.this.dbInfoManager.isAnySSL());
            String dirLibUpdate = "lib.update";
            File updateLibDir = new File("lib.update");
            if (!updateLibDir.exists()) {
                try {
                    updateLibDir.mkdir();
                }
                catch (Exception e) {
                    updateLibDir = null;
                    String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043f\u0430\u043f\u043a\u0438 lib.update. \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 BGClientRunner \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.";
                    this.setInfoLabelText(message);
                    BGClientRunnerUtil.showError(message);
                }
            }
            if (updateLibDir != null) {
                InputStream inputStream = urlConnection.getInputStream();
                long remoteVersion = BGClientRunnerUtil.bytesToLong(BGClientRunnerUtil.getBytes(inputStream, 8));
                File runnerLib = new File(updateLibDir, "runner_" + remoteVersion + ".jar");
                this.loadLib(inputStream, runnerLib, "runner_" + remoteVersion);
            }
            urlConnection.disconnect();
        }

        private File doRunFolder(String key) {
            File userRunFolder = null;
            if (key != null && !key.isEmpty()) {
                userRunFolder = BGClientRunnerUtil.getUserFolderForFile("runs");
                if (userRunFolder.exists() && userRunFolder.isDirectory()) {
                    for (File file : userRunFolder.listFiles()) {
                        Path runDir = Paths.get(file.toURI());
                        try {
                            BasicFileAttributes attributes = Files.readAttributes(runDir, BasicFileAttributes.class, new LinkOption[0]);
                            if (attributes.lastModifiedTime().toMillis() >= System.currentTimeMillis() - Long.parseLong(System.getProperty("bg.client.runner.cache.period", "15")) * 24L * 3600L * 1000L) continue;
                            for (File libFile : file.listFiles()) {
                                libFile.delete();
                            }
                            file.delete();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (!(userRunFolder = new File(userRunFolder, key)).exists()) {
                    userRunFolder.mkdirs();
                } else if (userRunFolder.isDirectory()) {
                    for (File file : userRunFolder.listFiles()) {
                        file.delete();
                    }
                }
                for (String libName : this.clientLibMap.keySet()) {
                    File newFile = new File(userRunFolder, libName + ".jar");
                    Path path = Paths.get(newFile.toURI());
                    File libJar = BGClientRunnerUtil.getUserFolderForFile("libs" + File.separator + libName + File.separator + this.clientLibMap.get(libName) + ".jar");
                    Path target = Paths.get(libJar.toURI());
                    try {
                        Files.createSymbolicLink(path, target, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return userRunFolder;
        }

        private void loadLib(InputStream inputStream, File libNameFile, String libName) throws Exception {
            long lengthTotal;
            DecimalFormat decimalFormat = new DecimalFormat("###,###,##0");
            long length = lengthTotal = BGClientRunnerUtil.bytesToLong(BGClientRunnerUtil.getBytes(inputStream, 8));
            String total = decimalFormat.format(lengthTotal);
            File newLibNameFile = new File(libNameFile.getPath());
            try {
                newLibNameFile.createNewFile();
                try (FileOutputStream fileOutputStream = new FileOutputStream(newLibNameFile);){
                    while (length > 0L) {
                        byte[] bytes = new byte[(int)(length > 8192L ? 8192L : length)];
                        int b = inputStream.read(bytes);
                        fileOutputStream.write(bytes, 0, b);
                        this.setInfoLabelText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \n" + libName + " [ " + decimalFormat.format(lengthTotal - (length -= (long)b)) + " / " + total + " ]", true);
                    }
                }
            }
            catch (Exception e) {
                this.setInfoLabelText("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435/\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \n" + libName + " [ " + decimalFormat.format(lengthTotal - length) + " / " + total + " ]", true);
                e.printStackTrace(System.out);
            }
            this.setInfoLabelText("");
        }

        private String getServerUrl() {
            String clientUpdate = BGClientRunner.this.dbInfo.getDbServerURL();
            if (clientUpdate.endsWith("/executer")) {
                clientUpdate = clientUpdate.substring(0, clientUpdate.length() - 9);
            }
            if (clientUpdate.endsWith("/")) {
                clientUpdate = clientUpdate.substring(0, clientUpdate.length() - 1);
            }
            return clientUpdate + "/clientUpdate";
        }
    }

    class RButton
    extends JButton {
        public RButton(String text, String actionCommand, ActionListener actionListener) {
            super(text);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
        }
    }

    class VMArgumentsDialog
    extends JDialog {
        private JTextArea vmargs;
        private ActionListener actionListener;

        public VMArgumentsDialog() {
            super(JOptionPane.getRootFrame());
            this.vmargs = new JTextArea();
            this.actionListener = null;
            this.setTitle("VM arguments");
            this.setModal(true);
            this.setResizable(true);
            this.vmargs.setMargin(new Insets(3, 3, 3, 3));
            this.actionListener = actionEvent -> {
                String actionCommand = actionEvent.getActionCommand();
                if ("save".equals(actionCommand)) {
                    BGClientRunner.this.currentVMArgs = this.vmargs.getText();
                }
                this.close();
            };
            this.vmargs.setText(BGClientRunner.this.currentVMArgs);
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            container.add((Component)new JScrollPane(this.vmargs), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
            container.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.setSize(new Dimension(400, 250));
            this.setLocationRelativeTo(JOptionPane.getRootFrame());
        }

        private JPanel getButtonPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new RButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "save", this.actionListener), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)new RButton("\u041e\u0442\u043c\u0435\u043d\u0430", "cancel", this.actionListener), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private void close() {
            this.setVisible(false);
        }
    }

    class NewPasswordDialog
    extends JDialog {
        private char[] oldPassword;
        private JPasswordField pass1;
        private JPasswordField pass2;

        public NewPasswordDialog(char[] oldPassword) {
            super(JOptionPane.getRootFrame());
            this.oldPassword = null;
            this.pass1 = new JPasswordField(15);
            this.pass2 = new JPasswordField(15);
            this.oldPassword = oldPassword;
            this.setDefaultCloseOperation(0);
            this.setTitle("\u0421\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f");
            this.setModal(true);
            this.setResizable(true);
            Font font = new Font("Dialog", 1, 18);
            this.pass1.setFont(font);
            this.pass2.setFont(font);
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            container.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 10), 0, 0));
            container.add((Component)this.pass1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 10), 0, 0));
            container.add((Component)new JLabel("\u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 10), 0, 0));
            container.add((Component)this.pass2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 10), 0, 0));
            container.add((Component)new JLabel("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f: \u043e\u0442 5 \u0434\u043e 20 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432"), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.pack();
            this.setLocationRelativeTo(JOptionPane.getRootFrame());
            this.pass1.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (Arrays.equals(NewPasswordDialog.this.pass1.getPassword(), NewPasswordDialog.this.oldPassword)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewPasswordDialog.this.pass1.setText("");
                            }
                        });
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.pass2.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    NewPasswordDialog.this.check();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    NewPasswordDialog.this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    NewPasswordDialog.this.check();
                }
            });
        }

        private void check() {
            if (this.pass1.getPassword().length > 4 && this.pass1.getPassword().length == this.pass2.getPassword().length) {
                if (Arrays.equals(this.pass1.getPassword(), this.pass2.getPassword())) {
                    this.close();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewPasswordDialog.this.pass2.setText("");
                        }
                    });
                }
            }
        }

        private void close() {
            this.setVisible(false);
        }

        public String getPassword() {
            return String.valueOf(this.pass1.getPassword());
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", null);
            this.putValue("ActionCommandKey", "about");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Package myPackage = this.getClass().getPackage();
            String aboutText = myPackage.getImplementationTitle() != null ? myPackage.getImplementationTitle() + " " + myPackage.getImplementationVersion() : "(\u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043e \u0438\u0437 ide)";
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), aboutText, "\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", -1);
        }
    }

    class ClearCacheAction
    extends AbstractAction {
        public ClearCacheAction() {
            super("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043a\u0435\u0448\u0438", null);
            this.putValue("ActionCommandKey", "clearcache");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043a\u0435\u0448\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u0432?\n\u042d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u043c\u043e\u0447\u044c \u043f\u0440\u0438 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u043c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438.", "\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043a\u0435\u0448\u0435\u0439", 0, 2) == 0) {
                File libsFolder = BGClientRunnerUtil.getUserFolderForFile("libs");
                File runsFolder = BGClientRunnerUtil.getUserFolderForFile("runs");
                File cacheFile = BGClientRunnerUtil.getLocalFile("cache.json");
                try {
                    if (BGClientRunnerUtil.deleteDir(libsFolder) && BGClientRunnerUtil.deleteDir(runsFolder) && cacheFile.delete()) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e", "\u0423\u0441\u043f\u0435\u0445", 1);
                    } else {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0432\u0441\u0451 \u0443\u0434\u0430\u043b\u0438\u043b\u043e\u0441\u044c, \u044d\u0442\u043e \u043f\u0440\u0438\u0437\u043d\u0430\u043a \u0441\u0435\u0440\u044c\u0451\u0437\u043d\u043e\u0439 \u043e\u0448\u0438\u0431\u043a\u0438\n\u0418\u0437\u0443\u0447\u0438\u0442\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a (" + BGClientRunnerUtil.getLocalSettingsDir().getAbsolutePath() + ")", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    }
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + ex.toString() + "\n\u0418\u0437\u0443\u0447\u0438\u0442\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a (" + BGClientRunnerUtil.getLocalSettingsDir().getAbsolutePath() + ")", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                }
            }
        }
    }
}

