/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import bitel.billing.module.common.BGUndoManager;
import bitel.billing.module.common.LineNumberedBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.Utilities;
import ru.bitel.bgbilling.client.BGClientInit;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public abstract class BGDocumentEditor
extends JPanel {
    private JLabel lineCountLabel = new JLabel();
    private JLabel caretLineLabel = new JLabel();
    private JLabel caretColumnLabel = new JLabel();
    private BGUndoManager undoManager = new BGUndoManager();
    protected StyledDocument document = this.createDocument();
    protected JTextPane textPane = this.createTextPane(this.document);

    protected abstract StyledDocument createDocument();

    public BGDocumentEditor() {
        super(new GridBagLayout());
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.add(this.textPane);
        JScrollPane scrollPane = new JScrollPane(textPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.add(Box.createHorizontalStrut(2), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        statusPanel.add((Component)new JLabel("\u0421\u0442\u0440\u043e\u043a: "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        statusPanel.add((Component)this.lineCountLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        statusPanel.add((Component)new JLabel("| \u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430: "), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        statusPanel.add((Component)this.caretLineLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        statusPanel.add((Component)new JLabel("| \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u043e\u043b\u0431\u0435\u0446: "), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        statusPanel.add((Component)this.caretColumnLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)statusPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
        final JTextField findText = new JTextField();
        final BGButton find = new BGButton("\u041d\u0430\u0439\u0442\u0438", "find", e -> this.find(findText.getText(), 0));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    find.doClick();
                }
            }
        });
        ActionListener findListener = e -> this.find(findText.getText(), this.textPane.getSelectionEnd());
        BGButton findNext = new BGButton("\u041d\u0430\u0439\u0442\u0438 \u0434\u0430\u043b\u0435\u0435", "findNext", findListener);
        findText.addActionListener(findListener);
        JPanel findPanel = new JPanel(new GridBagLayout());
        findPanel.add((Component)findText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        findPanel.add((Component)find, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        findPanel.add((Component)findNext, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)findPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.updateLineCount();
        this.updateCurrentLine();
        this.document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                BGDocumentEditor.this.updateLineCount();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BGDocumentEditor.this.updateLineCount();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BGDocumentEditor.this.updateLineCount();
            }
        });
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                BGDocumentEditor.this.updateCurrentLine();
            }
        });
        this.textPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if ((!BGClientInit.isMacOs() && e.isControlDown() || BGClientInit.isMacOs() && e.isMetaDown()) && (keyCode == 38 || keyCode == 40)) {
                    e.consume();
                    BGDocumentEditor.this.moveText(keyCode == 38);
                    return;
                }
                if (BGClientInit.isMacOs() && !e.isMetaDown() || !BGClientInit.isMacOs() && !e.isControlDown()) {
                    return;
                }
                if (keyCode == 76) {
                    int line = Utils.parseInt(JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443", "\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043a \u0441\u0442\u0440\u043e\u043a\u0435", 3), 0);
                    if (line > 0) {
                        BGDocumentEditor.this.setPosition(line, 0);
                    }
                } else if (BGClientInit.isMacOs() && keyCode == 47 || !BGClientInit.isMacOs() && keyCode == 67 && e.isShiftDown()) {
                    BGDocumentEditor.this.toggleComment();
                } else if (keyCode == 70) {
                    findText.requestFocus();
                }
            }
        });
        this.textPane.setBorder(new LineNumberedBorder(LineNumberedBorder.LEFT_SIDE, LineNumberedBorder.RIGHT_JUSTIFY));
        this.undoManager.setActionUndoAndRedo(this.textPane);
    }

    protected JTextPane createTextPane(StyledDocument document2) {
        return new JTextPane(this.document);
    }

    protected void moveText(boolean up) {
        try {
            int start = Utilities.getRowStart(this.textPane, this.textPane.getSelectionStart());
            int end = Utilities.getRowEnd(this.textPane, this.textPane.getSelectionEnd());
            String text = this.document.getText(start, end - start);
            if (up) {
                int oStart = Utilities.getRowStart(this.textPane, start - 1);
                int oEnd = Utilities.getRowEnd(this.textPane, start - 1);
                String otherText = this.document.getText(oStart, oEnd - oStart);
                this.document.remove(start, end - start);
                this.document.remove(oStart, oEnd - oStart);
                text = this.changeIndent(text, otherText, true);
                this.document.insertString(Utilities.getRowStart(this.textPane, oStart + 1), otherText, null);
                this.document.insertString(Utilities.getRowStart(this.textPane, oStart), text, null);
                this.textPane.setCaretPosition(oStart);
                this.textPane.setSelectionStart(oStart);
                this.textPane.setSelectionEnd(oStart + text.length());
            } else {
                int oStart = Utilities.getRowStart(this.textPane, end + 1);
                int oEnd = Utilities.getRowEnd(this.textPane, end + 1);
                String otherText = this.document.getText(oStart, oEnd - oStart);
                this.document.remove(oStart, oEnd - oStart);
                this.document.remove(start, end - start);
                text = this.changeIndent(text, otherText, false);
                this.document.insertString(Utilities.getRowStart(this.textPane, start + 1), text, null);
                this.document.insertString(Utilities.getRowStart(this.textPane, start), otherText, null);
                this.textPane.setCaretPosition(start + otherText.length() + 1);
                this.textPane.setSelectionStart(start + otherText.length() + 1);
                this.textPane.setSelectionEnd(start + otherText.length() + text.length() + 1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String changeIndent(String text, String otherText, boolean up) {
        Object res = "";
        if (up && otherText.contains("{") || !up && otherText.contains("}")) {
            String[] mas;
            text = text.replaceAll("\n", "\n\u2318");
            for (String line : mas = text.split("\u2318")) {
                res = (String)res + line.replaceFirst("\t", "");
            }
            text = res;
        } else if (up && otherText.contains("}") || !up && otherText.contains("{")) {
            String[] mas;
            text = text.replaceAll("\n", "\n\u2318");
            for (String line : mas = text.split("\u2318")) {
                res = (String)res + "\t" + line;
            }
            text = res;
        }
        return text;
    }

    protected void toggleComment() {
        try {
            boolean moreLines;
            boolean bl = moreLines = Utilities.getRowStart(this.textPane, this.textPane.getSelectionStart()) != Utilities.getRowStart(this.textPane, this.textPane.getSelectionEnd());
            if (moreLines) {
                String firstLine = this.getTextLineByOffset(this.textPane.getSelectionStart());
                String selectText = this.textPane.getText(Utilities.getRowStart(this.textPane, this.textPane.getSelectionStart()), Utilities.getRowEnd(this.textPane, this.textPane.getSelectionEnd()) - Utilities.getRowStart(this.textPane, this.textPane.getSelectionStart()));
                boolean comment = false;
                if (firstLine.length() < 2 || !firstLine.substring(0, 2).equals("//") || (selectText.contains("\n//") || firstLine.substring(0, 2).equals("//")) && (selectText.contains("\n ") || selectText.contains("\n\t"))) {
                    comment = true;
                }
                int ind = Utilities.getRowStart(this.textPane, this.textPane.getSelectionEnd());
                do {
                    if (comment) {
                        this.document.insertString(Utilities.getRowStart(this.textPane, ind), "//", null);
                    } else {
                        this.document.remove(Utilities.getRowStart(this.textPane, ind), 2);
                    }
                    ind = Utilities.getRowStart(this.textPane, ind - 1);
                } while (Utilities.getRowStart(this.textPane, this.textPane.getSelectionStart()) <= ind);
            } else {
                int offs = this.textPane.getCaretPosition();
                String origLine = this.getTextLineByOffset(offs);
                if (origLine.length() > 0) {
                    String ch = origLine.substring(0, 2);
                    if (ch.equals("//")) {
                        this.document.remove(Utilities.getRowStart(this.textPane, offs), 2);
                    } else {
                        this.document.insertString(Utilities.getRowStart(this.textPane, offs), "//", null);
                    }
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public String getTextLine(int line) {
        String result = null;
        if (line > 0) {
            try {
                String text = this.document.getText(0, this.document.getLength());
                int pos = 0;
                while (pos >= 0) {
                    if (--line == 0) {
                        result = this.getTextLineByOffset(pos + 1);
                        break;
                    }
                    pos = text.indexOf(10, pos + 1);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        return result;
    }

    private String getTextLineByOffset(int offs) throws BadLocationException {
        return this.document.getText(Utilities.getRowStart(this.textPane, offs), Utilities.getRowEnd(this.textPane, offs) - Utilities.getRowStart(this.textPane, offs));
    }

    private void find(String str, int offset) {
        int index;
        String data = this.textPane.getText();
        if (offset == data.length()) {
            offset = 0;
        }
        if ((index = data.indexOf(str, offset)) != -1) {
            this.textPane.select(index, index + str.length());
            this.textPane.getCaret().setSelectionVisible(true);
        } else if (offset > 0 && (index = data.indexOf(str, 0)) != -1) {
            this.textPane.select(index, index + str.length());
            this.textPane.getCaret().setSelectionVisible(true);
        }
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    @Override
    public boolean hasFocus() {
        return this.textPane.hasFocus();
    }

    public void setText(String value) {
        this.textPane.setText(value);
        this.undoManager.discardAllEdits();
    }

    public String getText() {
        return this.textPane.getText().replaceAll("\r", "");
    }

    protected void setTabs(int charactersPerTab) {
        FontMetrics fm = this.textPane.getFontMetrics(this.textPane.getFont());
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[10];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = this.textPane.getDocument().getLength();
        this.textPane.getStyledDocument().setParagraphAttributes(0, length, attributes, true);
    }

    private void updateLineCount() {
        try {
            this.lineCountLabel.setText(String.valueOf(this.getLineCount(this.document.getText(0, this.document.getLength()))));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void updateCurrentLine() {
        int pos = this.textPane.getCaretPosition();
        int caretLine = 0;
        int caretColumn = 0;
        try {
            String text = this.document.getText(0, pos);
            caretLine = this.getLineCount(text);
            caretColumn = this.getColumnCount(text);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.caretLineLabel.setText(String.valueOf(caretLine));
        this.caretColumnLabel.setText(String.valueOf(caretColumn));
    }

    private int getLineCount(String text) {
        int result = 0;
        int pos = 0;
        while ((pos = text.indexOf(10, pos + 1)) >= 0) {
            ++result;
        }
        return ++result;
    }

    private int getColumnCount(String text) {
        int lastn = text.lastIndexOf(10);
        return lastn != -1 ? text.substring(lastn).length() : text.length() + 1;
    }

    public void setPosition(int line, int column) {
        try {
            if (line <= 1) {
                this.textPane.setCaretPosition(0);
            } else {
                String text = this.document.getText(0, this.document.getLength());
                int pos = 0;
                while (pos >= 0) {
                    if (--line == 0) {
                        this.textPane.setCaretPosition(pos + column + 1);
                        break;
                    }
                    pos = text.indexOf(10, pos + 1);
                }
                if (line > 0) {
                    this.textPane.setCaretPosition(this.textPane.getDocument().getLength());
                }
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    public void select(int line, int column, int line2, int column2) {
        try {
            if (line <= 1) {
                this.textPane.setCaretPosition(0);
            } else {
                String text = this.document.getText(0, this.document.getLength());
                int pos = 0;
                block2: while (pos >= 0) {
                    --line2;
                    if (--line == 0) {
                        this.textPane.setSelectionStart(pos + column + 1);
                        while (pos >= 0) {
                            if (line2 == 0) {
                                this.textPane.setSelectionEnd(pos + column2 + 1);
                                break block2;
                            }
                            --line2;
                            pos = text.indexOf(10, pos + 1);
                        }
                        break;
                    }
                    pos = text.indexOf(10, pos + 1);
                }
            }
            this.textPane.getCaret().setSelectionVisible(true);
            this.textPane.requestFocus();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    public void setEditable(boolean b) {
        this.textPane.setEditable(b);
    }

    public Pair<Integer, Integer> getStartEndLine(int line) throws BadLocationException {
        if (line < 1) {
            throw new BadLocationException("error line " + line, line);
        }
        String text = this.document.getText(0, this.document.getLength());
        int pos_prev = -1;
        int pos_curr = 0;
        int line_curr = 0;
        while ((pos_curr = text.indexOf(10, pos_curr + 1)) >= 0) {
            if (++line_curr == line) {
                return new Pair<Integer, Integer>(pos_prev + 1, pos_curr);
            }
            pos_prev = pos_curr;
        }
        if (++line_curr == line) {
            if (pos_curr == -1) {
                pos_curr = this.document.getLength();
            }
            return new Pair<Integer, Integer>(pos_prev + 1, pos_curr);
        }
        throw new BadLocationException("no line " + line + " (total " + line_curr + ")", line);
    }

    public void addHighlight(int start, int stop, Color color) {
        try {
            this.textPane.getHighlighter().addHighlight(start, stop, new DefaultHighlighter.DefaultHighlightPainter(color));
        }
        catch (BadLocationException e) {
            System.err.print("error addHighlight(" + start + ", " + stop + "): ");
            e.printStackTrace();
        }
    }

    public void addHighlightLine(int line, Color color) {
        try {
            Pair<Integer, Integer> startEnd = this.getStartEndLine(line);
            this.addHighlight(startEnd.getFirst(), startEnd.getSecond(), Color.YELLOW);
        }
        catch (BadLocationException e) {
            System.err.print("error addHighlightLine(" + line + "): ");
            e.printStackTrace();
        }
    }

    public void removeAllHighlights() {
        this.textPane.getHighlighter().removeAllHighlights();
    }
}

