/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.localize;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.TimeZone;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Preferences;
import ru.bitel.common.jmx.MBeanUtils;

public class Localizer
extends BGLogger {
    private static char decimalformatsymbolsDecimalseparator = (char)46;

    public static void initLocales(Preferences config) {
        BGLogger logger = new BGLogger(MBeanUtils.class);
        logger.getLogger().info("Init locales");
        try {
            char defaultDecimalformatsymbolsDecimalseparator;
            String defaultlocale;
            String defaulttz = config.get("locale.default.tz", null);
            if (defaulttz != null) {
                logger.getLogger().info("overwrite tz: " + defaulttz);
                TimeZone.setDefault(TimeZone.getTimeZone(defaulttz));
            }
            if ((defaultlocale = config.get("locale.default.locale", null)) != null) {
                logger.getLogger().info("overwrite locale: " + defaultlocale);
                Locale.setDefault(new Locale(defaultlocale));
            }
            if ((defaultDecimalformatsymbolsDecimalseparator = config.getChar("locale.default.decimalformatsymbols.decimalseparator", '\u0000')) != '\u0000') {
                logger.getLogger().info("overwrite decimalformatsymbols.decimalseparator: " + defaultDecimalformatsymbolsDecimalseparator);
                decimalformatsymbolsDecimalseparator = defaultDecimalformatsymbolsDecimalseparator;
            }
        }
        catch (Exception ex) {
            BGLogger.error((String)"error init locales", (Throwable)ex);
        }
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(decimalformatsymbolsDecimalseparator);
        return dfs;
    }
}

