/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;

public class AverageCounterEx {
    private final TimeUnit timeUnit;
    private final int period;
    private final double[] amount;
    private final long[] count;
    private final long delimeter;
    private long currentPeriod = 0L;

    public AverageCounterEx(long period, TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.period = (int)period + 2;
        this.amount = new double[this.period];
        this.count = new long[this.period];
        this.delimeter = TimeUnit.MILLISECONDS.convert(1L, this.timeUnit);
    }

    public synchronized void add(long nowMillis, double value) {
        int p;
        long currentPeriod = nowMillis / this.delimeter;
        this.update(currentPeriod);
        int n = p = (int)(currentPeriod % (long)this.period);
        this.amount[n] = this.amount[n] + value;
        int n2 = p;
        this.count[n2] = this.count[n2] + 1L;
    }

    public synchronized long addAndGetSum(long nowMillis, double value) {
        this.add(nowMillis, value);
        long result = 0L;
        for (int i = 0; i < this.period; ++i) {
            result = (long)((double)result + this.amount[i]);
        }
        return result;
    }

    public synchronized double addAverage(long nowMillis, double value, MathContext mc) {
        int p;
        long currentPeriod = nowMillis / this.delimeter;
        this.update(currentPeriod);
        int n = p = (int)(currentPeriod % (long)this.period);
        long l = this.count[n] + 1L;
        this.count[n] = l;
        this.amount[p] = BigDecimal.valueOf(this.amount[p]).multiply(BigDecimal.valueOf(this.count[p]), mc).add(BigDecimal.valueOf(value), mc).divide(BigDecimal.valueOf(l), mc).doubleValue();
        return this.amount[p];
    }

    public synchronized double addAverage(long nowMillis, double value) {
        int p;
        long currentPeriod = nowMillis / this.delimeter;
        this.update(currentPeriod);
        int n = p = (int)(currentPeriod % (long)this.period);
        long l = this.count[n] + 1L;
        this.count[n] = l;
        this.amount[p] = (this.amount[p] * (double)this.count[p] + value) / (double)l;
        return this.amount[p];
    }

    public synchronized double getSum(long nowMillis) {
        return this.getSum(nowMillis, this.period - 2);
    }

    public synchronized double getSum(long nowMillis, int period) {
        long currentPeriod = nowMillis / this.delimeter;
        this.update(currentPeriod);
        int p = (int)((currentPeriod - 1L) % (long)this.period);
        return this.sum(p, period);
    }

    public synchronized double getSum(long nowMillis, int period, TimeUnit timeUnit) {
        long currentPeriod = nowMillis / this.delimeter;
        this.update(currentPeriod);
        int p = (int)((currentPeriod - 1L) % (long)this.period);
        int period2 = (int)this.timeUnit.convert(period, timeUnit);
        return this.sum(p, period2);
    }

    public double getAverage(long nowMillis) {
        return this.getSum(nowMillis) / (double)(this.period - 2);
    }

    public double getAverage(long nowMillis, MathContext mc) {
        return BigDecimal.valueOf(this.getSum(nowMillis)).divide(BigDecimal.valueOf(this.period - 2), mc).doubleValue();
    }

    public double getAverage(long nowMillis, int period) {
        return this.getSum(nowMillis, period) / (double)period;
    }

    public double getAverage(long nowMillis, int period, MathContext mc) {
        return BigDecimal.valueOf(this.getSum(nowMillis, period)).divide(BigDecimal.valueOf(period), mc).doubleValue();
    }

    public double getAverage(long nowMillis, int period, TimeUnit timeUnit) {
        int period2 = (int)this.timeUnit.convert(period, timeUnit);
        return this.getSum(nowMillis, period2) / (double)period;
    }

    public double getAverage(long nowMillis, int period, TimeUnit timeUnit, MathContext mc) {
        int period2 = (int)this.timeUnit.convert(period, timeUnit);
        return BigDecimal.valueOf(this.getSum(nowMillis, period2)).divide(BigDecimal.valueOf(period), mc).doubleValue();
    }

    public synchronized double getPrevious(long nowMillis) {
        long currentPeriod = nowMillis / this.delimeter;
        return this.amount[(int)((currentPeriod - 1L) % (long)this.period)];
    }

    private void update(long currentPeriod) {
        long delta = currentPeriod - this.currentPeriod;
        if (delta >= (long)this.period) {
            if ((delta -= (long)this.period) >= (long)this.period) {
                this.clear(0, this.period);
            } else {
                this.clear((int)this.currentPeriod % this.period, (int)delta);
            }
        } else {
            int i = (int)((currentPeriod + 1L) % (long)this.period);
            this.amount[i] = 0.0;
            this.count[i] = 0L;
        }
        this.currentPeriod = currentPeriod;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    private void clear(int pos, int length) {
        int i;
        for (i = pos; i >= 0 && length-- > 0; --i) {
            this.amount[i] = 0.0;
            this.count[i] = 0L;
        }
        for (i = this.period - 1; length-- > 0 && i > pos; --i) {
            this.amount[i] = 0.0;
            this.count[i] = 0L;
        }
    }

    private double sum(int pos, int length) {
        int i;
        double result = 0.0;
        for (i = pos; i >= 0 && length-- > 0; --i) {
            result += this.amount[i];
        }
        for (i = this.period - 1; length-- > 0 && i > pos; --i) {
            result += this.amount[i];
        }
        return result;
    }

    public long get(long nowMillis) {
        return (long)this.getSum(nowMillis);
    }

    public long addAndGet(long nowMillis, int value) {
        return this.addAndGetSum(nowMillis, value);
    }

    public static void main(String[] args) {
        AverageCounterEx c = new AverageCounterEx(60L, TimeUnit.SECONDS);
        Runnable r = () -> {
            for (int i = 0; i < 50000000; ++i) {
                c.add(System.currentTimeMillis(), 1.0);
            }
        };
        Runnable r2 = () -> {
            for (int i = 0; i < 5000000; ++i) {
                System.out.println(NumberFormat.getInstance().format(c.getSum(System.currentTimeMillis())));
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        };
        for (int i = 0; i < 50; ++i) {
            new Thread(r).start();
        }
        new Thread(r2).start();
    }
}

