/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamItem;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public class PhoneUtils {
    public static final String getPhones(PhoneParamValue value, String formats) {
        if (value == null || value.size() == 0) {
            return "";
        }
        int countPhone = value.size();
        ArrayList<KeyValue> list = new ArrayList<KeyValue>(countPhone);
        for (int i = 0; i < countPhone; ++i) {
            PhoneParamItem item = value.getPhoneItem(i);
            list.add(new KeyValue(item.getPhone(), item.getComment()));
        }
        return PhoneUtils.getPhones(list, formats);
    }

    public static final String getPhones(EntityAttrPhone value, String formats) {
        if (value.getContactList() == null || value.getContactList().size() == 0) {
            return "";
        }
        int countPhone = value.getContactList().size();
        ArrayList<KeyValue> list = new ArrayList<KeyValue>(countPhone);
        for (int i = 0; i < countPhone; ++i) {
            EntityAttrPhone.PhoneContact item = value.getContactList().get(i);
            list.add(new KeyValue(item.getPhone(), item.getComment()));
        }
        return PhoneUtils.getPhones(list, formats);
    }

    private static final String getPhones(Collection<KeyValue> collection, String formats) {
        StringBuilder result = new StringBuilder(64);
        for (KeyValue e : collection) {
            result.append(PhoneUtils.phoneToFormat(formats, e.getKey().trim()));
            if (Utils.notBlankString(e.getValue())) {
                result.append('[').append(e.getValue()).append(']');
            }
            result.append("; ");
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    public static String phoneToFormat(String formats, String value) {
        if (Utils.isEmptyString(formats)) {
            return value;
        }
        return PhoneUtils.phoneToFormat(PhoneUtils.prefixMap(formats), value);
    }

    public static Map<Integer, List<String>> prefixMap(String formats) {
        if (Utils.isEmptyString(formats)) {
            return null;
        }
        String[] prefixsArray = formats.split(",");
        HashMap<Integer, List<String>> prefixs = new HashMap<Integer, List<String>>();
        for (int i = 0; i < prefixsArray.length; ++i) {
            int countDigits = EntityAttrPhone.phoneUnformatted(prefixsArray[i]).length();
            ArrayList<String> list = (ArrayList<String>)prefixs.get(countDigits);
            if (list == null) {
                list = new ArrayList<String>();
                prefixs.put(countDigits, list);
            }
            list.add(prefixsArray[i]);
        }
        return prefixs;
    }

    public static String phoneToFormat(Map<Integer, List<String>> prefixs, String value) {
        if (prefixs == null || prefixs.size() == 0) {
            return value;
        }
        String prefix = "";
        for (int i = value.length(); i >= 0; --i) {
            List<String> prefixsList = prefixs.get(i);
            if (prefixsList == null) continue;
            String valueOnlyDigits = EntityAttrPhone.phoneUnformatted(value);
            for (String pref : prefixsList) {
                String prefixOnlyDigits = EntityAttrPhone.phoneUnformatted(pref);
                if (prefixOnlyDigits.length() > valueOnlyDigits.length() || !valueOnlyDigits.startsWith(prefixOnlyDigits)) continue;
                prefix = pref;
                break;
            }
            if (!Utils.isBlankString(prefix)) break;
        }
        if (Utils.isBlankString(prefix)) {
            return value;
        }
        if (value.length() > prefix.length()) {
            value = value.substring(0, prefix.length());
        }
        int posValue = 0;
        int posResult = 0;
        StringBuilder resValue = new StringBuilder();
        while (posResult < prefix.length() && posValue < value.length()) {
            if (Character.isDigit(prefix.charAt(posResult)) || prefix.charAt(posResult) == 'X') {
                resValue.append(value.charAt(posValue));
                ++posValue;
                ++posResult;
                continue;
            }
            resValue.append(prefix.charAt(posResult));
            ++posResult;
        }
        if (posValue < value.length()) {
            resValue.append(value.substring(posValue));
        }
        return resValue.toString();
    }
}

