/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.tlv.TlvHeader;
import ru.bitel.bgbilling.kernel.network.tlv.TlvInfo;
import ru.bitel.common.ByteBufferUtils;
import ru.bitel.common.Utils;

public abstract class RadiusAttributeInfo<V>
extends TlvInfo<RadiusAttributeInfo<?>, V, RadiusAttributeHeader> {
    public final int vendor;
    protected final boolean addAvpName;
    protected final int tag;
    protected final boolean continuation;
    protected boolean fragmented;
    Set<String> aliases;

    public RadiusAttributeInfo(int vendor, int code, String name, int valueType, int tag, int paramTypeSize, int paramLengthSize, boolean continuation, boolean addAvpName, List<RadiusAttributeInfo<?>> children) {
        super(RadiusAttributeInfo.class, code, name, valueType, paramTypeSize, paramLengthSize, children);
        this.vendor = vendor;
        this.tag = tag;
        this.continuation = continuation;
        this.addAvpName = addAvpName;
    }

    public RadiusAttributeInfo(int vendor, int code, String name, int valueType, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(RadiusAttributeInfo.class, code, name, valueType, Utils.parseInt((String)attr.getAttribute("typeSize"), (int)1), Utils.parseInt((String)attr.getAttribute("lengthSize"), (int)1), children);
        this.vendor = vendor;
        String tagString = attr.getAttribute("tag");
        this.tag = "yes".equals(tagString) ? 1 : Utils.parseInt((String)tagString, (int)0);
        this.continuation = Utils.parseInt((String)attr.getAttribute("continuation"), (int)0) > 0;
        this.addAvpName = "yes".equals(attr.getAttribute("add"));
    }

    public RadiusAttribute<?> read(ByteBuffer bb, RadiusAttributeHeader header) {
        if (header.length < 0) {
            throw new IllegalArgumentException(this.name + " header.length=" + header.length);
        }
        ByteBuffer data = this.sliceData(bb, header.length);
        ByteBuffer dataWithoutTag = this.tagUnwrap(data, header);
        if (this.continuation) {
            dataWithoutTag = this.readWithContinuation(dataWithoutTag, bb);
        }
        return RadiusDictionary.newRadiusAttribute(this, header.tag, dataWithoutTag);
    }

    protected ByteBuffer tagUnwrap(ByteBuffer data, RadiusAttributeHeader header) {
        int tag;
        ByteBuffer dataWithoutTag = data;
        switch (this.tag) {
            case 1: {
                tag = data.get() & 0xFF;
                dataWithoutTag = data.slice();
                break;
            }
            case 2: {
                tag = data.get() & 0xFF;
                if (tag > 0 && tag <= 31) {
                    dataWithoutTag = data.slice();
                    break;
                }
                tag = 0;
                dataWithoutTag.rewind();
                break;
            }
            default: {
                tag = 0;
            }
        }
        header.tag = tag;
        return dataWithoutTag;
    }

    protected ByteBuffer readWithContinuation(ByteBuffer dataWithoutTag, ByteBuffer bb) {
        ByteBuffer wimaxData;
        byte continuation = dataWithoutTag.get();
        if (continuation != -128) {
            wimaxData = dataWithoutTag.slice();
        } else {
            int i;
            ArrayList<ByteBuffer> wimaxDataList = new ArrayList<ByteBuffer>();
            wimaxDataList.add(dataWithoutTag.slice());
            RadiusAttributeHeader header = new RadiusAttributeHeader();
            int position = bb.position();
            while (position < bb.limit()) {
                bb.position(position);
                ((RadiusAttributeInfo)this.parent).readTypeLength(bb, header, 0, true);
                int vendor = bb.getInt();
                if (header.type != 26 || vendor != this.vendor) {
                    throw new IllegalArgumentException();
                }
                this.readTypeLength(bb, header, header.length, true);
                if (header.type != this.type) {
                    throw new IllegalArgumentException();
                }
                ByteBuffer data = this.sliceData(bb, header.length);
                dataWithoutTag = this.tagUnwrap(data, header);
                continuation = dataWithoutTag.get();
                wimaxDataList.add(dataWithoutTag.slice());
                if (continuation != -128) break;
                position = bb.position();
            }
            int wimaxDataLength = 0;
            int size = wimaxDataList.size();
            for (i = 0; i < size; ++i) {
                wimaxDataLength += ((ByteBuffer)wimaxDataList.get(i)).capacity();
            }
            wimaxData = ByteBuffer.allocate(wimaxDataLength);
            size = wimaxDataList.size();
            for (i = 0; i < size; ++i) {
                wimaxData.put((ByteBuffer)wimaxDataList.get(i));
            }
        }
        wimaxData.clear();
        return wimaxData;
    }

    public void write(RadiusAttribute<?> attribute, ByteBuffer bb) {
        attribute.bufferPosition = bb.position();
        this.writeAttribute(attribute.getTag(), new ByteBuffer[]{attribute.getData()}, bb);
    }

    protected void writeAttribute(int tag, ByteBuffer[] data, ByteBuffer bb) {
        if (this.vendor == -1) {
            this.writeAttributeInternal(tag, data, bb, false);
        } else {
            bb.put((byte)26);
            bb.put((byte)0);
            bb.putInt(this.vendor);
            if (this.type != -1) {
                this.writeAttributeInternal(tag, data, bb, true);
            } else {
                int pos = bb.position();
                int size = data.length;
                for (int i = 0; i < size; ++i) {
                    bb.put(data[i]);
                }
                int length = bb.position() - pos + 2;
                bb.put(pos - 5, (byte)(length + 4 & 0xFF));
            }
        }
    }

    private void writeAttributeInternal(int tag, ByteBuffer[] data, ByteBuffer bb, boolean vendor) {
        switch (this.paramTypeLength) {
            case 2: {
                ByteBufferUtils.putUnsignedShort((ByteBuffer)bb, (int)this.type);
                break;
            }
            case 4: {
                bb.putInt(this.type);
                break;
            }
            default: {
                ByteBufferUtils.putUnsignedByte((ByteBuffer)bb, (int)this.type);
            }
        }
        switch (this.paramLengthLength) {
            case 2: {
                bb.putShort((short)0);
                break;
            }
            case 0: {
                break;
            }
            default: {
                bb.put((byte)0);
            }
        }
        int pos = bb.position();
        if (this.tag == 1 || this.tag == 2 && tag > 0) {
            bb.put((byte)(tag & 0xFF));
        }
        ByteBuffer[] continuationData = null;
        if (this.continuation || this.fragmented) {
            int continuationPosition = bb.position();
            bb.put((byte)0);
            int dataLength = 0;
            int size = data.length;
            for (int i = 0; i < size; ++i) {
                ByteBuffer d = data[i];
                if (dataLength + d.remaining() > 240) {
                    int oldLimit = d.limit();
                    int limit = 240 - dataLength;
                    d.limit(limit);
                    bb.put(d);
                    d.limit(oldLimit);
                    d = d.slice();
                    continuationData = new ByteBuffer[size - i];
                    continuationData[0] = d;
                    System.arraycopy(data, i + 1, continuationData, 1, continuationData.length - 1);
                    break;
                }
                bb.put(d);
            }
            if (this.continuation && continuationData != null) {
                bb.put(continuationPosition, (byte)-128);
            }
        } else {
            int size = data.length;
            for (int i = 0; i < size; ++i) {
                bb.put(data[i]);
            }
        }
        int length = bb.position() - pos + 2;
        switch (this.paramLengthLength) {
            case 2: {
                ByteBufferUtils.putUnsignedShort((ByteBuffer)bb, (int)(pos - this.paramLengthLength), (int)length);
                break;
            }
            case 0: {
                break;
            }
            default: {
                ByteBufferUtils.putUnsignedByte((ByteBuffer)bb, (int)(pos - this.paramLengthLength), (int)length);
            }
        }
        if (vendor) {
            bb.put(pos - this.paramLengthLength - this.paramTypeLength - 4 - 1, (byte)(length + 4 + this.paramTypeLength + this.paramLengthLength & 0xFF));
        }
        if (continuationData != null) {
            assert (this.continuation || this.fragmented);
            this.writeAttribute(tag, continuationData, bb);
        }
    }

    public static class RadiusAttributeHeader
    extends TlvHeader {
        public int vendor;
        public int tag;
    }
}

