/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.range;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeDao;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEvent;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeLoader;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;

public abstract class RangeManager
extends BGLogger
implements EventListener<TrafficRangeEvent>,
TrafficRangeLoader {
    protected final int moduleId;
    private final ConcurrentMap<Integer, TrafficRangeEntry> rangedTrafficMap = new ConcurrentHashMap<Integer, TrafficRangeEntry>(256);
    protected String tablename;
    private final boolean realtime;

    public RangeManager(int moduleId, boolean realtime) throws BGException {
        this.moduleId = moduleId;
        this.realtime = realtime;
        if (realtime) {
            EventProcessor.getInstance().addListener(this, TrafficRangeEvent.class, moduleId, null);
        }
    }

    public TrafficRangeEntry getRangedTrafficEntry(int contractId) {
        TrafficRangeEntry entry = (TrafficRangeEntry)this.rangedTrafficMap.get(contractId);
        if (entry == null) {
            TrafficRangeEntry newEntry = new TrafficRangeEntry();
            entry = this.rangedTrafficMap.putIfAbsent(contractId, newEntry);
            if (entry == null) {
                entry = newEntry;
            }
        }
        return entry;
    }

    public void removeRangedTrafficEntry(int contractId) {
        this.rangedTrafficMap.remove(contractId);
    }

    @Deprecated
    protected TrafficRange getRangedTraffica(TariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        return this.getRangedTraffic(workerContext, contractId, treeNodeId, key);
    }

    @Override
    public TrafficRange getRangedTraffic(TariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        return this.getCurrentRangedTraffic(workerContext, contractId, treeNodeId, key);
    }

    protected final TrafficRange getCurrentRangedTraffic(TariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        try {
            ResultSet rs = workerContext.getPSCache().execute("SELECT counter, amount, maxAmount FROM " + this.tablename + " WHERE contractId=? AND treeNodeId=? AND rangeKey=? ORDER BY yy DESC, mm DESC LIMIT 1", contractId, treeNodeId, key);
            TrafficRange rangedTraffic = rs.next() ? new TrafficRange(rs.getInt(1), rs.getLong(2), rs.getLong(3)) : new TrafficRange(0, 0L, 0L);
            rs.close();
            return rangedTraffic;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public TrafficRange getPrevMonthTraffic(Date month, TariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        try {
            int yy = TimeUtils.convertDateToCalendar(month).get(1);
            int mm = TimeUtils.convertDateToCalendar(month).get(2) + 1;
            String query = "SELECT counter, amount, maxAmount  FROM " + this.tablename + " WHERE contractId=? AND treeNodeId=? AND rangeKey=?  AND  ( (yy < ? ) or ( yy = ? AND mm < ? ) )  ORDER BY yy DESC, mm DESC LIMIT 1";
            ResultSet rs = workerContext.getPSCache().execute(query, contractId, treeNodeId, key, yy, yy, mm);
            TrafficRange rangeTraffic = new TrafficRange(0, 0L, 0L);
            if (rs.next()) {
                rangeTraffic = new TrafficRange(rs.getInt(1), rs.getLong(2), rs.getLong(3));
            }
            return rangeTraffic;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long addRangedTraffic(TrafficRangeEntry rangedTrafficEntry, TariffWorkerContext workerContext, int contractId, long treeNodeId, long rangeKey, long maxAmount, long amount, TrafficRangeLoader trafficRangeLoader) throws BGException {
        rangedTrafficEntry.lock();
        try {
            long delta;
            TrafficRangeKey key = rangedTrafficEntry.searchKey;
            key.setKey(treeNodeId, rangeKey);
            TrafficRange rangedTraffic = rangedTrafficEntry.map.get(key);
            if (rangedTraffic == null) {
                if (this.realtime && rangedTrafficEntry.map.size() > 8) {
                    TrafficRangeKey oldKey;
                    long minKey = 0L;
                    for (Map.Entry<TrafficRangeKey, TrafficRange> e : rangedTrafficEntry.map.entrySet()) {
                        oldKey = e.getKey();
                        if (oldKey.treeNodeId != key.treeNodeId || oldKey.key >= key.key || oldKey.key <= minKey) continue;
                        minKey = oldKey.key;
                    }
                    Iterator<Map.Entry<TrafficRangeKey, TrafficRange>> iter = rangedTrafficEntry.map.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<TrafficRangeKey, TrafficRange> e;
                        e = iter.next();
                        oldKey = e.getKey();
                        TrafficRange oldValue = e.getValue();
                        if (oldKey.treeNodeId != key.treeNodeId || oldValue.delta != 0L || oldKey.key >= minKey) continue;
                        this.getLogger().debug("Remove old TrafficRange from cache " + key);
                        iter.remove();
                    }
                }
                rangedTraffic = trafficRangeLoader.getRangedTraffic(workerContext, contractId, treeNodeId, key.key);
                rangedTraffic.maxAmount = maxAmount;
                rangedTrafficEntry.map.put(new TrafficRangeKey(key.treeNodeId, key.key), rangedTraffic);
            }
            if (maxAmount != 0L) {
                delta = maxAmount - rangedTraffic.amount;
                if (delta == 0L) {
                    long l = -1L;
                    return l;
                }
                delta = Math.min(amount, delta);
            } else {
                delta = amount;
            }
            rangedTraffic.amount += delta;
            rangedTraffic.delta += delta;
            rangedTraffic.maxAmount = maxAmount;
            if (delta != 0L || amount != 0L) {
                rangedTrafficEntry.delta = true;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Add to " + key + " delta=" + delta + " (amount=" + rangedTraffic.amount + ", maxAmount=" + maxAmount + ")");
            }
            long l = delta < 0L ? delta - 1L : delta;
            return l;
        }
        finally {
            rangedTrafficEntry.unlock();
        }
    }

    public long addRangedTraffic(TariffWorkerContext workerContext, int contractId, int accountingPeriodId, int contractTariffOptionId, long treeNodeId, int mode, int type, Calendar time, long maxAmount, long amount, TrafficRangeLoader trafficRangeLoader, Date dateFrom, Date dateTo) throws BGException {
        TrafficRangeEntry rangedTrafficEntry = this.getRangedTrafficEntry(contractId);
        long key = TrafficRangeKey.getKey(mode, type, accountingPeriodId, contractTariffOptionId, time);
        return this.addRangedTraffic(rangedTrafficEntry, workerContext, contractId, treeNodeId, key, maxAmount, amount, trafficRangeLoader);
    }

    public long addRangedTraffic(TariffWorkerContext workerContext, int contractId, long treeNodeId, long rangeKey, long maxAmount, long amount, TrafficRangeLoader trafficRangeLoader, Date dateFrom, Date dateTo) throws BGException {
        TrafficRangeEntry rangedTrafficEntry = this.getRangedTrafficEntry(contractId);
        return this.addRangedTraffic(rangedTrafficEntry, workerContext, contractId, treeNodeId, rangeKey, maxAmount, amount, trafficRangeLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(TrafficRangeEvent e, EventListenerContext ctx) throws BGException {
        TrafficRangeEntry rangedTrafficEntry = (TrafficRangeEntry)this.rangedTrafficMap.get(e.getContractId());
        if (rangedTrafficEntry != null) {
            rangedTrafficEntry.lock();
            try {
                TrafficRangeKey key = rangedTrafficEntry.searchKey;
                key.setKey(e.getTreeNodeId(), e.getKey());
                TrafficRange rangedTraffic = rangedTrafficEntry.map.get(key);
                if (rangedTraffic == null) {
                    rangedTraffic = new TrafficRange(e.getCounter(), e.getAmount(), e.getMaxAmount());
                    rangedTrafficEntry.map.put(new TrafficRangeKey(key.treeNodeId, key.key), rangedTraffic);
                } else if (e.getCounter() > rangedTraffic.counter) {
                    if (rangedTrafficEntry.delta) {
                        rangedTraffic.amount += e.getDelta();
                        rangedTraffic.maxAmount = e.getMaxAmount();
                    } else {
                        rangedTraffic.counter = e.getCounter();
                        rangedTraffic.amount = e.getAmount();
                        rangedTraffic.maxAmount = e.getMaxAmount();
                    }
                }
            }
            finally {
                rangedTrafficEntry.unlock();
            }
        }
    }

    public PreparedStatement createUpdatePS(Connection con, int moduleId, Calendar time) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCache(ConnectionSet connectionSet, boolean canClear) throws BGException {
        if (canClear) {
            this.getLogger().info("Clear trafficRange cache");
            this.rangedTrafficMap.clear();
            return;
        }
        this.getLogger().info("Updating trafficRange cache");
        TrafficRangeDao rangeDao = this.getTrafficRangeDao(connectionSet);
        for (Map.Entry e : this.rangedTrafficMap.entrySet()) {
            Integer contractId = (Integer)e.getKey();
            TrafficRangeEntry rangeEntry = (TrafficRangeEntry)e.getValue();
            rangeEntry.lock();
            try {
                for (Map.Entry<TrafficRangeKey, TrafficRange> ee : rangeEntry.map.entrySet()) {
                    TrafficRangeKey key = ee.getKey();
                    TrafficRange range = ee.getValue();
                    rangeDao.get(contractId, key, range);
                }
            }
            finally {
                rangeEntry.unlock();
            }
        }
        rangeDao.close();
        this.getLogger().info("TrafficRange cache updated");
    }

    protected abstract TrafficRangeDao getTrafficRangeDao(ConnectionSet var1) throws BGException;

    public Map<Integer, TrafficRangeEntry> rangedTrafficMap() {
        return Collections.unmodifiableMap(this.rangedTrafficMap);
    }
}

