/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.util.Random;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class Digest5090RadiusSession<N extends Nas<?, ?, ?>, P>
extends RadiusSession<N, P> {
    private static final Random RANDOM = new Random();
    private String nonce;

    public Digest5090RadiusSession(byte[] state, String userName, RadiusAttribute.RadiusAttributeString userNameAttribute, P sessionParams) {
        super(state, userName, userNameAttribute, sessionParams);
    }

    @Override
    public void accessRequest(RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        if (request.getAttribute(-1, 103) != null) {
            int errorCode = this.authentication(processor, req, nas, request, response, connectionSet, log_record_id);
            if (errorCode == 0) {
                response.setCode((byte)2);
            }
        } else {
            if (request.getAttribute(-1, 109) != null && request.getAttribute(-1, 105) == null) {
                byte[] nonceBytes = new byte[8];
                RANDOM.nextBytes(nonceBytes);
                this.nonce = Utils.bytesToHexString(nonceBytes).toLowerCase();
                response.setStringAttribute(-1, 105, this.nonce);
            }
            response.setStringAttribute(-1, 104, ((Nas)nas).getDigestRealm());
            response.setStringAttribute(-1, 110, ((Nas)nas).getDigestQop());
            response.setStringAttribute(-1, 111, "MD5");
            response.setCode((byte)11);
        }
    }
}

