/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.admin.TransferManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.list.renderer.TitleIdListCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.pattern.client.ContractPatternObjectsTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternGeneralPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternLabelAndGroupTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternPluginTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternScriptTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternTariffTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.PatternData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class PatternEditorTab
extends BGUTabPanel {
    protected int patternId = -1;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGTextField patternTitle = new BGTextField();
    private BGUList<IdTitle> patternList = new BGUList();
    private JCheckBox showHidden = new JCheckBox("\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043a\u0440\u044b\u0442\u044b\u0435");
    private JCheckBox hidden = new JCheckBox("\u0441\u043a\u0440\u044b\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d");
    private CardLayout rightPanelLayout = new CardLayout();
    private JPanel rightPanel = new JPanel(this.rightPanelLayout);

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getListPanel(), (Component)this.getRightPanel(), 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getListPanel() {
        this.patternList.setSelectionMode(0);
        this.patternList.setCellRenderer(new TitleIdListCellRenderer());
        this.patternList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PatternEditorTab.this.performAction("edit");
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.patternList);
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PatternEditorTab.this.patternList.setFixedCellWidth(PatternEditorTab.this.patternList.getParent().getWidth() - 20);
            }
        });
        this.showHidden.addActionListener(e -> this.performAction("refresh"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0428\u0430\u0431\u043b\u043e\u043d\u044b "));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.showHidden, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRightPanel() {
        this.patternTitle.setMinimumSize(new Dimension(165, 24));
        this.patternTitle.setPreferredSize(new Dimension(165, 24));
        this.patternTitle.setColumns(15);
        JPanel noSelectPanel = new JPanel(new GridBagLayout());
        noSelectPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", 0), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 30, 0, 30), 0, 0));
        Document moduleDoc1 = ClientUtils.getModuleDoc(this.getClass());
        this.tabbedPane.add((Component)new PatternGeneralPanel(moduleDoc1), "\u041e\u0431\u0449\u0438\u0435");
        this.tabbedPane.add((Component)new PatternModuleTabPanel(moduleDoc1), "\u041c\u043e\u0434\u0443\u043b\u0438");
        this.tabbedPane.add((Component)new PatternPluginTabPanel(moduleDoc1), "\u041f\u043b\u0430\u0433\u0438\u043d\u044b");
        this.tabbedPane.add((Component)new PatternLabelAndGroupTabPanel(moduleDoc1), "\u041c\u0435\u0442\u043a\u0438, \u0433\u0440\u0443\u043f\u043f\u044b");
        this.tabbedPane.add((Component)new PatternTariffTabPanel(moduleDoc1), "\u0413\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u0438 \u0442\u0430\u0440\u0438\u0444\u044b");
        this.tabbedPane.add((Component)new PatternScriptTabPanel(moduleDoc1), "\u0421\u043a\u0440\u0438\u043f\u0442 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f");
        this.tabbedPane.add((Component)new ContractPatternObjectsTabPanel(moduleDoc1), "\u041e\u0431\u044a\u0435\u043a\u0442\u044b");
        this.tabbedPane.addChangeListener(e -> ((PatternBaseTabPanel)this.tabbedPane.getSelectedComponent()).initUI());
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.patternTitle, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.hidden, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        BGButtonPanelRestoreOkCancelHelp okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        okCancelPanel.addActionListener(e -> this.okCancel_actionPerformed(e));
        JPanel patternSelectedPanel = new JPanel(new GridBagLayout());
        patternSelectedPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        patternSelectedPanel.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        patternSelectedPanel.add((Component)okCancelPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.rightPanel.setLayout(this.rightPanelLayout);
        this.rightPanel.add((Component)noSelectPanel, "info");
        this.rightPanel.add((Component)patternSelectedPanel, "editor");
        return this.rightPanel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (this.patternList.isEnabled()) {
                this.patternList.setData(((ClientContext)this.getContext()).getWebService(ContractPatternService.class).contractPatterns(this.showHidden.isSelected()));
                this.patternList.setFixedCellWidth(this.patternList.getParent().getWidth() - 20);
                PatternData patternData = ((ClientContext)this.getContext()).getWebService(ContractPatternService.class).patternDataGet();
                for (int index = 0; index < this.tabbedPane.getComponentCount(); ++index) {
                    ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).setData(patternData);
                }
            } else {
                this.getPatternData();
            }
        });
        new AbstractBGUPanel.BGActionNew(e -> {
            if (this.patternList.isEnabled()) {
                this.patternId = -1;
                this.getPatternData();
                this.rightPanelLayout.show(this.rightPanel, "editor");
                this.patternList.setEnabled(false);
                this.showHidden.setEnabled(false);
                this.tabbedPane.setSelectedIndex(0);
            }
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (this.patternList.isEnabled()) {
                IdTitle item = (IdTitle)this.patternList.getSelectedValue();
                if (item != null) {
                    this.patternId = item.getId();
                    this.getPatternData();
                    this.rightPanelLayout.show(this.rightPanel, "editor");
                    this.patternList.setEnabled(false);
                    this.showHidden.setEnabled(false);
                    this.tabbedPane.setSelectedIndex(0);
                } else {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d");
                }
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            if (this.patternList.isEnabled()) {
                IdTitle item = (IdTitle)this.patternList.getSelectedValue();
                if (item != null) {
                    if (ClientUtils.confirmDelete(item.getTitle())) {
                        try {
                            ((ClientContext)this.getContext()).getWebService(ContractService.class, 0).contractPatternDelete(item.getId());
                            this.rightPanelLayout.show(this.rightPanel, "info");
                            this.patternList.setEnabled(true);
                            this.showHidden.setEnabled(true);
                            this.performAction("refresh");
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog(ex);
                        }
                    }
                } else {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d");
                }
            }
        });
    }

    private void okCancel_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.getPatternData();
        } else if ("ok".equals(actionCommand)) {
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("UpdateContractPattern").setAttribute("pid", this.patternId).setAttribute("title", this.patternTitle.getText().trim()).setAttribute("hidden", this.hidden.isSelected());
            boolean result = true;
            for (int index = 0; index < this.tabbedPane.getComponentCount(); ++index) {
                try {
                    result = ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).setRequestData(request);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                    result = false;
                }
                if (!result) break;
            }
            if (result && ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                this.rightPanelLayout.show(this.rightPanel, "info");
                this.patternList.setEnabled(true);
                this.showHidden.setEnabled(true);
                this.performAction("refresh");
            }
        } else if ("cancel".equals(actionCommand)) {
            this.rightPanelLayout.show(this.rightPanel, "info");
            this.patternList.setEnabled(true);
            this.showHidden.setEnabled(true);
        }
    }

    protected void getPatternData() {
        if (this.patternId == -1) {
            this.patternTitle.setText("\u041d\u043e\u0432\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            this.hidden.setSelected(false);
            for (int index = 0; index < this.tabbedPane.getComponentCount(); ++index) {
                ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).resetData();
            }
        } else {
            try {
                ContractPattern contractPattern = this.getKernelContext().getWebService(ContractService.class).contractPatternGet(this.patternId);
                this.patternTitle.setText(contractPattern.getTitle());
                this.hidden.setSelected(contractPattern.isHidden());
                Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("GetPatternInfo").setAttribute("pid", this.patternId);
                Document doc = TransferManager.getDocument(request);
                if (!ClientUtils.checkStatus(doc)) {
                    return;
                }
                Element pattern = XMLUtils.selectElement(doc, "//pattern");
                for (int index = 0; index < this.tabbedPane.getComponentCount(); ++index) {
                    ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).setPatternData(pattern);
                    ((PatternBaseTabPanel)this.tabbedPane.getComponent(index)).setPatternData(contractPattern);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }
}

