/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.bgbilling.kernel.module.common.event.ServiceModifiedEvent;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

@DirectoryItem(eventClass=ServiceModifiedEvent.class, serviceClass=ModuleService.class)
public class Service
extends IdTitle {
    private Period activePeriod;
    private String config = "";
    private int moduleId;
    private int unit;
    private boolean using;

    public Service() {
    }

    public Service(int moduleId) {
        this.moduleId = moduleId;
    }

    public Object clone() {
        return this.copy();
    }

    public Service copy() {
        return Service.builder().setId(this.id).setTitle(this.title).setModuleId(this.moduleId).setUsing(this.using).setUnit(this.unit).setConfig(this.config).setActivePeriod(this.activePeriod.copy()).build();
    }

    @XmlElement
    public Period getActivePeriod() {
        return this.activePeriod;
    }

    @XmlElement
    public String getConfig() {
        return this.config;
    }

    public Preferences getConfigPreferences() {
        return new Preferences(this.config, "\n");
    }

    @XmlAttribute
    public int getModuleId() {
        return this.moduleId;
    }

    @XmlAttribute
    public int getUnit() {
        return this.unit;
    }

    @XmlAttribute
    public boolean isUsing() {
        return this.using;
    }

    public void setActivePeriod(Period activePeriod) {
        this.activePeriod = activePeriod;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public void setUsing(boolean used) {
        this.using = used;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Service service = new Service();

        private Builder() {
        }

        public Builder setId(int value) {
            this.service.id = value;
            return this;
        }

        public Builder setTitle(String title) {
            this.service.title = title;
            return this;
        }

        public Builder setActivePeriod(Period activePeriod) {
            this.service.activePeriod = activePeriod;
            return this;
        }

        public Builder setConfig(String config) {
            this.service.config = config;
            return this;
        }

        public Builder setModuleId(int moduleId) {
            this.service.moduleId = moduleId;
            return this;
        }

        public Builder setUnit(int unit) {
            this.service.unit = unit;
            return this;
        }

        public Builder setUsing(boolean used) {
            this.service.using = used;
            return this;
        }

        public Service build() {
            try {
                Service service = this.service;
                return service;
            }
            finally {
                this.service = null;
            }
        }
    }
}

