/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.bean;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.common.bean.emuns.PaymentType;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public abstract class AbstractTransactionManager<B extends Id>
extends AbstractIdDao<B> {
    protected ParameterMap moduleSetup = null;

    public AbstractTransactionManager(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
        this.moduleSetup = Setup.getSetup().getModuleSetup(moduleId);
    }

    public void searchTransaction(SearchResult<B> searchResult, SearchParam searchParam) throws SQLException {
        if (searchResult != null) {
            ResultSet rs;
            int index;
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            PeriodWithTime period = searchResult.getPeriodWithTime();
            List list = searchResult.getList();
            boolean typeFilter = searchParam.getType() != null && PaymentType.NO_SELECT != searchParam.getType();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.create_date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.create_date<?");
                }
            }
            this.queryStatus(query, searchParam.getStatus());
            query.append(typeFilter ? " AND pt.autopayment=?" : "");
            if (searchParam.getMethod() != null && !"---".equals(searchParam.getMethod())) {
                query.append(" AND pt.transaction_type=?");
            }
            if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                query.append(" AND c.title LIKE ?");
            }
            if (searchParam.getContractId() > 0) {
                query.append(" AND c.id=").append(searchParam.getContractId());
            }
            String querySelect = "SELECT pt.*, c.title AS contract_title" + query.toString() + this.getSQLOrder(sort, this.fields) + this.sqlLimit(page);
            try (PreparedStatement ps = this.con.prepareStatement(querySelect);){
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                index = this.psStatus(ps, searchParam.getStatus(), index);
                if (typeFilter) {
                    ps.setBoolean(index++, PaymentType.AUTO == searchParam.getType());
                }
                if (searchParam.getMethod() != null && !"---".equals(searchParam.getMethod())) {
                    ps.setString(index++, searchParam.getMethod());
                }
                if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                    ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                }
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        list.add((Id)this.getFromRS(rs));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            ps = this.con.prepareStatement("SELECT SUM(pt.sum), COUNT(*) " + query.toString());
            try {
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                index = this.psStatus(ps, searchParam.getStatus(), index);
                if (typeFilter) {
                    ps.setBoolean(index++, PaymentType.AUTO == searchParam.getType());
                }
                if (searchParam.getMethod() != null && !"---".equals(searchParam.getMethod())) {
                    ps.setString(index++, searchParam.getMethod());
                }
                if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                    ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                }
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        BigDecimal sum;
                        if (page != null) {
                            page.setRecordCount(rs.getInt(2));
                        }
                        if ((sum = rs.getBigDecimal(1)) == null) continue;
                        searchResult.setSum(sum);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    protected void queryStatus(StringBuilder query, String status) {
        if (Utils.notBlankString((String)status)) {
            query.append(" AND pt.status=?");
        }
    }

    protected int psStatus(PreparedStatement ps, String status, int index) throws SQLException {
        if (Utils.notBlankString((String)status)) {
            ps.setString(index++, status);
        }
        return index;
    }

    protected StringBuilder doConnection(String url, String requestMethod, boolean doInput, String outputText) throws IOException {
        return this.doConnection(url, requestMethod, doInput, outputText, null);
    }

    protected StringBuilder doConnection(String url, String requestMethod, boolean doInput, String outputText, Map<String, String> requestProperties) throws IOException {
        URL serverUrl = new URL(url);
        HttpsURLConnection connection = (HttpsURLConnection)serverUrl.openConnection();
        this.setConnectionTimeout(connection);
        connection.setRequestMethod(requestMethod);
        if (requestProperties != null && !requestProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(entry.getKey() + ": " + entry.getValue());
                }
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        connection.setDoOutput(outputText != null);
        connection.setDoInput(doInput);
        if (outputText != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Data: " + outputText);
            }
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            bw.write(outputText.toCharArray());
            bw.close();
        }
        connection.connect();
        StringBuilder resultJson = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream()));){
            if (bufferedReader.ready()) {
                String line = null;
                resultJson = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    resultJson.append(line);
                }
            }
        }
        connection.disconnect();
        return resultJson;
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(1000);
        connection.setReadTimeout(5000);
    }

    protected String setParameter(String data, String key, String value) {
        Object result = "";
        boolean setValue = false;
        for (String line : data.split("\n")) {
            boolean startsWith = line.startsWith(key + "=");
            setValue = setValue || startsWith;
            result = (String)(((String)result).length() == 0 ? "" : (String)result + "\n") + (String)(startsWith ? key + "=" + value : line);
        }
        if (!setValue) {
            result = (String)(((String)result).length() == 0 ? "" : (String)result + "\n") + key + "=" + value;
        }
        return result;
    }

    protected String getParameter(String data, String key) {
        String result = null;
        for (String line : data.split("\n")) {
            if (!line.startsWith(key + "=")) continue;
            result = line.substring(key.length() + 1);
        }
        return result;
    }

    protected static String getParamString(JSONObject resultJsonObject) {
        StringBuilder builder = new StringBuilder();
        AbstractTransactionManager.getParamString(resultJsonObject, builder, "");
        return builder.toString();
    }

    protected static String getParamString(JSONObject resultJsonObject, String params) {
        StringBuilder builder = new StringBuilder(params);
        AbstractTransactionManager.getParamString(resultJsonObject, builder, "");
        return builder.toString();
    }

    protected static void getParamString(JSONObject jsonObject, StringBuilder builder, String prefix) {
        if (jsonObject != null) {
            Iterator iterator = jsonObject.keySet().iterator();
            while (iterator.hasNext()) {
                String key = String.valueOf(iterator.next());
                Object value = jsonObject.get(key);
                if (key == null || value == null) continue;
                if (value instanceof JSONObject) {
                    AbstractTransactionManager.getParamString((JSONObject)value, builder, key + ".");
                    continue;
                }
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(prefix + key).append("=").append(value);
            }
        }
    }

    protected <T extends BGAbstractTransaction> String getPaymentData(T transaction) {
        return "";
    }
}

