/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import bitel.billing.module.common.BGComboBox;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.directory.address.AddressEntityEditor;
import ru.bitel.bgbilling.client.directory.address.AddressHouseEditor;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.directory.api.common.service.DirectoryService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityData;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityType;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.CityItem;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class DirectoryAddressEditorTab
extends AbstractBGUPanel<ClientContext, BGUPanel> {
    private static final String COUNTRY = "country";
    private static final String CITY = "city";
    private static final String STREET = "street";
    private static final String AREA = "area";
    private static final String QUARTER = "quarter";
    private static final String HOUSE = "house";
    private AddressEntityType mode = AddressEntityType.COUNTRY;
    private CardLayout tableLayout = new CardLayout();
    private JPanel tablePanel = new JPanel(this.tableLayout);
    private JLabel titleLabel;
    private JLabel subTitleLabel = new JLabel("");
    private JLabel recordCountLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    private JButton importButton = new JButton("\u0418\u043c\u043f\u043e\u0440\u0442...");
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private Map<String, Component> tableMap = new HashMap<String, Component>();
    private Map<String, BGButton> buttonMap = new HashMap<String, BGButton>();
    private Map<String, BGTextField> filterMap = new HashMap<String, BGTextField>();
    private Map<String, Object> objectMap = new HashMap<String, Object>();
    private Map<String, BGComboBox<String>> searchModeMap = new HashMap<String, BGComboBox<String>>();
    private Map<String, BGTableModel<Element>> tableModelMap = new HashMap<String, BGTableModel<Element>>();
    private CountryTableModel countryTableModel = new CountryTableModel();
    private CityTableModel cityTableModel = new CityTableModel();
    private BGUTable cityItemTable = new BGUTable(new CityItemTableModel(""));

    @Override
    protected void jbInit() throws Exception {
        this.tableModelMap.put(HOUSE, new HouseTableModel());
        this.tableMap.put(COUNTRY, new BGUTable(this.countryTableModel));
        this.tableMap.put(CITY, new BGUTable(this.cityTableModel));
        this.tableMap.put(HOUSE, new BGUTable(this.tableModelMap.get(HOUSE)));
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(COUNTRY)), COUNTRY);
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(CITY)), CITY);
        this.tablePanel.add((Component)new JScrollPane(this.cityItemTable), "cityItem");
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(HOUSE)), HOUSE);
        this.titleLabel = new JLabel(""){
            {
                this.setFont(new Font("Dialog", 1, 18));
            }
        };
        this.subTitleLabel.setFont(new Font("Dialog", 1, 16));
        this.tableMap.get(COUNTRY).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Country country;
                Object sourceObject;
                if (event.getClickCount() == 2 && (sourceObject = event.getSource()) instanceof BGUTable && (country = (Country)DirectoryAddressEditorTab.this.countryTableModel.getSelectedRow()) != null) {
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.COUNTRY, country, country.getTitle());
                    DirectoryAddressEditorTab.this.pagePanel.setPageIndex(1);
                    DirectoryAddressEditorTab.this.setData(AddressEntityType.CITY);
                }
            }
        });
        this.tableMap.get(CITY).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                City city;
                Object sourceObject;
                if (event.getClickCount() == 2 && (sourceObject = event.getSource()) instanceof BGUTable && (city = (City)DirectoryAddressEditorTab.this.cityTableModel.getSelectedRow()) != null) {
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.CITY, city, city.getTitle());
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.COUNTRY, city.getCountry(), city.getCountry().getTitle());
                    DirectoryAddressEditorTab.this.pagePanel.setPageIndex(1);
                    DirectoryAddressEditorTab.this.setData(AddressEntityType.STREET);
                }
            }
        });
        this.cityItemTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CityItem cityItem;
                Object sourceObject;
                if (event.getClickCount() == 2 && AddressEntityType.STREET == DirectoryAddressEditorTab.this.mode && (sourceObject = event.getSource()) instanceof BGUTable && (cityItem = (CityItem)((CityItemTableModel)DirectoryAddressEditorTab.this.cityItemTable.getModel()).getSelectedRow()) != null) {
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.STREET, cityItem, cityItem.getTitle());
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.CITY, cityItem.getCity(), cityItem.getCity().getTitle());
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.COUNTRY, cityItem.getCity().getCountry(), cityItem.getCity().getCountry().getTitle());
                    DirectoryAddressEditorTab.this.pagePanel.setPageIndex(1);
                    DirectoryAddressEditorTab.this.setData(AddressEntityType.HOUSE);
                }
            }
        });
        BGSwingUtilites.handleEdit((JTable)((BGUTable)this.tableMap.get(HOUSE)), this, "edit");
        this.pagePanel.addPropertyChangeListener(e -> {
            String name = e.getPropertyName();
            if (name != null && name.startsWith("to")) {
                this.setData(this.mode);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getSearchPanel(), (Component)this.getResultPanel(), 400L), "Center");
        this.performAction("refresh");
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.setData(AddressEntityType.COUNTRY));
        new AbstractBGUPanel.BGActionNew(e -> {
            if (AddressEntityType.COUNTRY != this.mode) {
                if (AddressEntityType.CITY == this.mode) {
                    if (this.filterMap.get(COUNTRY).isEditable()) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u0442\u0440\u0430\u043d\u0443");
                        return;
                    }
                } else if (AddressEntityType.AREA == this.mode || AddressEntityType.QUARTER == this.mode || AddressEntityType.STREET == this.mode) {
                    if (this.filterMap.get(COUNTRY).isEditable() || this.filterMap.get(CITY).isEditable()) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0443 \u0438 \u0433\u043e\u0440\u043e\u0434");
                        return;
                    }
                } else if (AddressEntityType.HOUSE == this.mode && (this.filterMap.get(COUNTRY).isEditable() || this.filterMap.get(CITY).isEditable() || this.filterMap.get(STREET).isEditable())) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0443, \u0433\u043e\u0440\u043e\u0434 \u0438 \u0443\u043b\u0438\u0446\u0443");
                    return;
                }
            }
            this.showEditor(null, null);
            this.setData(this.mode);
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            String id = null;
            Object item = null;
            if (AddressEntityType.COUNTRY == this.mode) {
                Country country = (Country)this.countryTableModel.getSelectedRow();
                if (country == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                    return;
                }
                id = String.valueOf(country.getId());
                item = country;
            } else if (AddressEntityType.CITY == this.mode) {
                City city = (City)this.cityTableModel.getSelectedRow();
                if (city == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                    return;
                }
                id = String.valueOf(city.getId());
                item = city;
            } else if (AddressEntityType.STREET == this.mode || AddressEntityType.AREA == this.mode || AddressEntityType.QUARTER == this.mode) {
                CityItem cityItem = (CityItem)((CityItemTableModel)this.cityItemTable.getModel()).getSelectedRow();
                if (cityItem == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                    return;
                }
                id = String.valueOf(cityItem.getId());
                item = cityItem;
            } else {
                BGTableModel<Element> tableModel = this.tableModelMap.get(this.mode.getType());
                Element element = tableModel.getSelectedRow();
                if (element == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                    return;
                }
                id = element.getAttribute("id");
                item = element;
            }
            if (this.tabbedPane.getSelectedIndex() != 0 && AddressEntityType.HOUSE == this.mode) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u043a\u043b\u0430\u0434\u043a\u0443 \"\u0423\u043b\u0438\u0446\u044b\" \u0432 \u0444\u0438\u043b\u044c\u0442\u0440\u0435.");
                return;
            }
            this.showEditor(id, item);
            this.setData(this.mode);
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            String title;
            List<Integer> selectedIds;
            if (AddressEntityType.COUNTRY == this.mode) {
                selectedIds = this.countryTableModel.getSelectedRows().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
                title = "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u0430\u043d\u044b";
            } else if (AddressEntityType.CITY == this.mode) {
                selectedIds = this.cityTableModel.getSelectedRows().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
                title = "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0433\u043e\u0440\u043e\u0434\u0430";
            } else if (AddressEntityType.AREA == this.mode || AddressEntityType.STREET == this.mode || AddressEntityType.QUARTER == this.mode) {
                selectedIds = ((CityItemTableModel)this.cityItemTable.getModel()).getSelectedRows().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
                title = "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0443\u043b\u0438\u0446\u044b";
            } else {
                selectedIds = this.tableModelMap.get(this.mode.getType()).getSelectedRows().stream().mapToInt(el -> Utils.parseInt(el.getAttribute("id"), -1)).boxed().collect(Collectors.toList());
                title = "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u043c\u0430";
            }
            if (Utils.isEmptyCollection(selectedIds)) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                return;
            }
            if (ClientUtils.confirmDelete(title, false)) {
                try {
                    switch (this.mode) {
                        case COUNTRY: 
                        case CITY: {
                            for (Integer id : selectedIds) {
                                ((ClientContext)this.getContext()).getWebService(AddressService.class, 0).addressEntityDataDelete(this.mode, id.intValue());
                            }
                            break;
                        }
                        case HOUSE: {
                            for (Integer id : selectedIds) {
                                ((ClientContext)this.getContext()).getPort(DirectoryService.class).addressHouseDelete(id);
                            }
                            break;
                        }
                        default: {
                            this.addressDelete(selectedIds, this.mode);
                        }
                    }
                    this.setData(this.mode);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
    }

    private void addressDelete(List<Integer> ids, AddressEntityType mode) throws Exception {
        DirectoryService service = ((ClientContext)this.getContext()).getPort(DirectoryService.class);
        for (Integer id : ids) {
            service.addressDirectoryDelete(id, mode.getCode(), "new");
        }
    }

    private void showEditor(String id, Object item) {
        AddressEntityData addressEntityData = new AddressEntityData();
        addressEntityData.setRecordId(Utils.parseInt(id));
        addressEntityData.setAddressEntityType(this.mode);
        if (this.mode == AddressEntityType.HOUSE) {
            AddressHouseEditor editor = new AddressHouseEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u043e\u043c\u0430", addressEntityData, (ClientContext)this.getContext());
            if (item != null) {
                Element house = (Element)item;
                addressEntityData.setRecordId(Utils.parseInt(house.getAttribute("id")));
                Street street = Street.builder().setId(Utils.parseInt(house.getAttribute("id"))).setCityId(Utils.parseInt(house.getAttribute("city_id"))).setTitle(house.getAttribute("item_title")).build();
                City city = City.builder().setTitle(house.getAttribute("city_title")).build();
                Country country = Country.builder().setTitle(house.getAttribute("country_title")).build();
                editor.setStreet(street);
                editor.setTitleLabelText(country.getTitle() + ", " + city.getTitle() + ", " + street.getTitle());
            } else {
                Street street = (Street)this.objectMap.get(STREET);
                City city = street.getCity();
                Country country = city.getCountry();
                editor.setStreet(street);
                editor.setTitleLabelText(country.getTitle() + ", " + city.getTitle() + ", " + street.getTitle());
            }
            editor.open();
        } else {
            AddressEntityEditor editor = new AddressEntityEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", addressEntityData, (ClientContext)this.getContext());
            if (item != null) {
                switch (this.mode) {
                    case COUNTRY: {
                        editor.setTitleLabelText("\u0421\u0442\u0440\u0430\u043d\u0430:");
                        editor.setTitlePrefixEnable(false);
                        editor.setTitleSuffixEnable(false);
                        break;
                    }
                    case CITY: {
                        City city = (City)item;
                        editor.setTitleLabelText("\u0413\u043e\u0440\u043e\u0434: [" + city.getCountry().getTitle() + "]");
                        break;
                    }
                    case STREET: {
                        CityItem cityItem = (CityItem)item;
                        editor.setTitleLabelText("\u0423\u043b\u0438\u0446\u0430: [" + cityItem.getCity().getCountry().getTitle() + ", " + cityItem.getCity().getTitle() + "]");
                        break;
                    }
                    case AREA: {
                        CityItem cityItem = (CityItem)item;
                        editor.setTitleLabelText("\u0420\u0430\u0439\u043e\u043d: [" + cityItem.getCity().getCountry().getTitle() + ", " + cityItem.getCity().getTitle() + "]");
                        break;
                    }
                    case QUARTER: {
                        CityItem cityItem = (CityItem)item;
                        editor.setTitleLabelText("\u041a\u0432\u0430\u0440\u0442\u0430\u043b: [" + cityItem.getCity().getCountry().getTitle() + ", " + cityItem.getCity().getTitle() + "]");
                        break;
                    }
                }
            } else {
                switch (this.mode) {
                    case COUNTRY: {
                        editor.setTitleLabelText("\u0421\u0442\u0440\u0430\u043d\u0430:");
                        editor.setTitlePrefixEnable(false);
                        editor.setTitleSuffixEnable(false);
                        break;
                    }
                    case CITY: {
                        Country country = (Country)this.objectMap.get(COUNTRY);
                        editor.setParentId(country.getId());
                        editor.setTitleLabelText("\u0413\u043e\u0440\u043e\u0434: [" + country.getTitle() + "]");
                        break;
                    }
                    case STREET: {
                        City city = (City)this.objectMap.get(CITY);
                        editor.setParentId(city.getId());
                        editor.setTitleLabelText("\u0423\u043b\u0438\u0446\u0430: [" + city.getCountry().getTitle() + ", " + city.getTitle() + "]");
                        break;
                    }
                    case AREA: {
                        City city = (City)this.objectMap.get(CITY);
                        editor.setParentId(city.getId());
                        editor.setTitleLabelText("\u0420\u0430\u0439\u043e\u043d: [" + city.getCountry().getTitle() + ", " + city.getTitle() + "]");
                        break;
                    }
                    case QUARTER: {
                        City city = (City)this.objectMap.get(CITY);
                        editor.setParentId(city.getId());
                        editor.setTitleLabelText("\u041a\u0432\u0430\u0440\u0442\u0430\u043b: [" + city.getCountry().getTitle() + ", " + city.getTitle() + "]");
                        break;
                    }
                }
            }
            editor.open();
        }
    }

    private void resetData(AddressEntityType mode) {
        switch (mode) {
            case COUNTRY: {
                this.unsetBlock(COUNTRY);
                this.unsetBlock(CITY);
                this.unsetBlock(STREET);
                this.unsetBlock(AREA);
                this.unsetBlock(QUARTER);
                this.unsetBlock(HOUSE);
                break;
            }
            case CITY: {
                this.unsetBlock(CITY);
                this.unsetBlock(STREET);
                this.unsetBlock(AREA);
                this.unsetBlock(QUARTER);
                this.unsetBlock(HOUSE);
                break;
            }
            case STREET: 
            case AREA: 
            case QUARTER: {
                this.unsetBlock(STREET);
                this.unsetBlock(AREA);
                this.unsetBlock(QUARTER);
                this.unsetBlock(HOUSE);
                break;
            }
            case HOUSE: {
                this.unsetBlock(HOUSE);
            }
        }
    }

    private JPanel getSearchPanel() {
        this.tabbedPane.add((Component)this.getSearchPanel("", STREET), "\u0423\u043b\u0438\u0446\u0430");
        this.tabbedPane.add((Component)this.getSearchPanel("", QUARTER), "\u041a\u0432\u0430\u0440\u0442\u0430\u043b");
        this.tabbedPane.add((Component)this.getSearchPanel("", AREA), "\u0420\u0430\u0439\u043e\u043d");
        int y = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0438\u0441\u043a\u0430"));
        Dimension dimension = panel.getPreferredSize();
        dimension.setSize(300.0, dimension.getHeight());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.setMaximumSize(dimension);
        panel.add((Component)this.getSearchPanel("\u0421\u0442\u0440\u0430\u043d\u0430:", COUNTRY), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getSearchPanel("\u0413\u043e\u0440\u043e\u0434:", CITY), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.tabbedPane, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(20, 10, 5, 10), 0, 0));
        panel.add((Component)this.getSearchPanel("\u0414\u043e\u043c/\u0434\u0440\u043e\u0431\u044c:", HOUSE), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getResultPanel() {
        this.importButton.addActionListener(e -> {
            switch (this.mode) {
                case CITY: {
                    new ImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442", ((Country)this.objectMap.getOrDefault(COUNTRY, new Country())).getId()).open();
                    break;
                }
                case STREET: 
                case AREA: 
                case QUARTER: {
                    new ImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442", ((City)this.objectMap.getOrDefault(CITY, new City())).getId()).open();
                    break;
                }
                case HOUSE: {
                    new ImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442", ((Street)this.objectMap.getOrDefault(STREET, new Street())).getId()).open();
                    break;
                }
            }
        });
        JPanel navPanel = new JPanel(new GridBagLayout());
        navPanel.add((Component)this.titleLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        navPanel.add((Component)this.subTitleLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 30), 0, 0));
        navPanel.add((Component)this.importButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        navPanel.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 20), 0, 0));
        navPanel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)navPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getSearchPanel(String title, String table) {
        BGTextField filter = new BGTextField();
        filter.setName(table);
        filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyChar() == '\n') {
                    DirectoryAddressEditorTab.this.pagePanel.setPageIndex(1);
                    DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.this.getAddressEntityTypeByType(((BGTextField)event.getSource()).getName()));
                }
            }
        });
        this.filterMap.put(table, filter);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        panel.add((Component)filter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 5, 10), 0, 0));
        panel.add((Component)this.getButtonPanel(table), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 5, 10), 0, 0));
        return panel;
    }

    private AddressEntityType getAddressEntityTypeByType(String type) {
        return Arrays.asList(AddressEntityType.values()).stream().filter(a -> a.getType().equals(type)).findFirst().orElse(null);
    }

    private JPanel getButtonPanel(String command) {
        BGButton clearButton = new BGButton("X");
        clearButton.setActionCommand(command);
        clearButton.addActionListener(actionEvent -> {
            this.pagePanel.setPageIndex(1);
            this.resetData(this.getAddressEntityTypeByType(actionEvent.getActionCommand()));
            this.setData(this.getAddressEntityTypeByType(actionEvent.getActionCommand()));
        });
        BGButton searchButton = new BGButton(">>");
        searchButton.setActionCommand(command);
        searchButton.addActionListener(actionEvent -> {
            this.pagePanel.setPageIndex(1);
            this.setData(this.getAddressEntityTypeByType(actionEvent.getActionCommand()));
        });
        this.buttonMap.put(command, searchButton);
        BGComboBox<String> comboBox = new BGComboBox<String>();
        comboBox.addItem("\u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0430");
        comboBox.addItem("\u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f");
        comboBox.addItem("\u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        comboBox.addItem("\u0440\u0430\u0432\u043d\u0430");
        this.searchModeMap.put(command, comboBox);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(comboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)clearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)searchButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setData(AddressEntityType mode) {
        this.mode = mode;
        if (!this.filterMap.isEmpty()) {
            String titleLabelText = "";
            String subTitleLabelText = "";
            try {
                AddressService addressService = ((ClientContext)this.getContext()).getPort(AddressService.class);
                boolean fl = true;
                if (AddressEntityType.COUNTRY == mode) {
                    titleLabelText = "\u0421\u0442\u0440\u0430\u043d\u044b";
                    this.importButton.setVisible(false);
                    SearchResult searchResult = addressService.searchCountryList(this.filterMap.get(COUNTRY).getText(), this.getSearchMode(this.searchModeMap.get(COUNTRY)), this.pagePanel.getPage());
                    this.countryTableModel.setData(searchResult.getList());
                    this.pagePanel.setPage(searchResult.getPage());
                    this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
                    this.tableLayout.show(this.tablePanel, mode.getType());
                } else if (AddressEntityType.CITY == mode) {
                    titleLabelText = "\u0413\u043e\u0440\u043e\u0434\u0430";
                    int countryId = ((Country)this.objectMap.getOrDefault(COUNTRY, new Country())).getId();
                    this.importButton.setVisible(countryId > 0);
                    subTitleLabelText = countryId > 0 ? "( " + this.filterMap.get(COUNTRY).getText() + " )" : "(\u0441\u0442\u0440\u0430\u043d\u0430 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430)";
                    searchResult = addressService.searchCityList(countryId, this.filterMap.get(CITY).getText(), this.getSearchMode(this.searchModeMap.get(CITY)), this.pagePanel.getPage());
                    this.cityTableModel.setData(searchResult.getList());
                    this.pagePanel.setPage(searchResult.getPage());
                    this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
                    this.tableLayout.show(this.tablePanel, mode.getType());
                } else if (AddressEntityType.AREA == mode || AddressEntityType.QUARTER == mode || AddressEntityType.STREET == mode) {
                    int cityId = ((City)this.objectMap.getOrDefault(CITY, new City())).getId();
                    this.importButton.setVisible(cityId > 0);
                    subTitleLabelText = cityId > 0 ? "( " + this.filterMap.get(CITY).getText() + " )" : "(\u0433\u043e\u0440\u043e\u0434 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                    searchResult = null;
                    CityItemTableModel cityItemTableModel = null;
                    if (AddressEntityType.AREA == mode) {
                        titleLabelText = "\u0420\u0430\u0439\u043e\u043d\u044b";
                        cityItemTableModel = new CityItemTableModel("\u0420\u0430\u0439\u043e\u043d\u044b");
                        searchResult = addressService.searchAreaList(cityId, this.filterMap.get(AREA).getText(), this.getSearchMode(this.searchModeMap.get(AREA)), this.pagePanel.getPage());
                    } else if (AddressEntityType.QUARTER == mode) {
                        titleLabelText = "\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u0430";
                        cityItemTableModel = new CityItemTableModel("\u0420\u0430\u0439\u043e\u043d\u044b");
                        searchResult = addressService.searchQuarterList(cityId, this.filterMap.get(QUARTER).getText(), this.getSearchMode(this.searchModeMap.get(QUARTER)), this.pagePanel.getPage());
                    } else if (AddressEntityType.STREET == mode) {
                        titleLabelText = "\u0423\u043b\u0438\u0446\u044b";
                        cityItemTableModel = new CityItemTableModel("\u0420\u0430\u0439\u043e\u043d\u044b");
                        searchResult = addressService.searchStreetList(cityId, this.filterMap.get(STREET).getText(), this.getSearchMode(this.searchModeMap.get(STREET)), this.pagePanel.getPage());
                    }
                    cityItemTableModel.setData(searchResult.getList());
                    this.cityItemTable.setModel(cityItemTableModel);
                    this.pagePanel.setPage(searchResult.getPage());
                    this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
                    this.tableLayout.show(this.tablePanel, "cityItem");
                } else {
                    fl = false;
                }
                if (!fl) {
                    Request request = new Request();
                    request.setModule(((ClientContext)this.getContext()).getModule());
                    request.setAction("SearchAddressDirectory");
                    request.setAttribute("mode", mode);
                    request.setPage(this.pagePanel);
                    if (AddressEntityType.HOUSE == mode) {
                        titleLabelText = "\u0414\u043e\u043c\u0430";
                        subTitleLabelText = "";
                        int submode = this.tabbedPane.getSelectedIndex();
                        request.setAttribute("submode", String.valueOf(submode));
                        if (submode == 1) {
                            int quarterId = ((Quarter)this.objectMap.getOrDefault(QUARTER, new Quarter())).getId();
                            request.setAttribute("quarterId", quarterId);
                            subTitleLabelText = quarterId > 0 ? "( " + this.filterMap.get(QUARTER).getText() + " )" : "(\u043a\u0432\u0430\u0440\u0442\u0430\u043b \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                            this.importButton.setVisible(quarterId > 0);
                        } else if (submode == 2) {
                            int areaId = ((Area)this.objectMap.getOrDefault(AREA, new Area())).getId();
                            request.setAttribute("areaId", areaId);
                            subTitleLabelText = areaId > 0 ? "( " + this.filterMap.get(AREA).getText() + " )" : "(\u0440\u0430\u0439\u043e\u043d \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                            this.importButton.setVisible(areaId > 0);
                        } else {
                            int streetId = ((Street)this.objectMap.getOrDefault(STREET, new Street())).getId();
                            request.setAttribute("streetId", streetId);
                            subTitleLabelText = streetId > 0 ? "( " + this.filterMap.get(STREET).getText() + " )" : "(\u0443\u043b\u0438\u0446\u0430 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                            this.importButton.setVisible(streetId > 0);
                        }
                        request.setAttribute("searchHouse", this.filterMap.get(HOUSE).getText());
                    }
                    this.titleLabel.setText(titleLabelText);
                    this.subTitleLabel.setText(subTitleLabelText);
                    Document doc = ((ClientContext)this.getContext()).getDocument(request);
                    if (ClientUtils.checkStatus(doc)) {
                        this.setDocument(doc, mode.getType());
                    }
                    this.tableLayout.show(this.tablePanel, mode.getType());
                } else {
                    this.titleLabel.setText(titleLabelText);
                    this.subTitleLabel.setText(subTitleLabelText);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    public void setDocument(Document doc) throws Exception {
        this.setDocument(doc, COUNTRY);
    }

    public void setDocument(Document doc, String mode) throws Exception {
        Node tableNode = XMLUtils.getNode(doc, "table");
        ArrayList<Element> data = new ArrayList<Element>();
        for (Element element : XMLUtils.selectElements(doc, "//table/data/row")) {
            data.add(element);
        }
        this.tableModelMap.get(mode).setData(data);
        this.pagePanel.setPageInfo((Element)tableNode);
        this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + ((Element)tableNode).getAttribute("recordCount"));
    }

    private String getSearchMode(BGComboBox<String> comboBox) {
        String result = "";
        String item = comboBox.getSelectedItem();
        if (item.equals("\u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0430")) {
            result = "subs";
        } else if (item.equals("\u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f")) {
            result = "start";
        } else if (item.equals("\u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f")) {
            result = "end";
        } else if (item.equals("\u0440\u0430\u0432\u043d\u0430")) {
            result = "equal";
        }
        return result;
    }

    private void setBlock(String mode, Object item, String title) {
        this.objectMap.put(mode, item);
        this.filterMap.get(mode).setEditable(false);
        this.filterMap.get(mode).setText(title);
        this.buttonMap.get(mode).setEnabled(false);
        this.searchModeMap.get(mode).setEnabled(false);
    }

    private void unsetBlock(String mode) {
        this.objectMap.remove(mode);
        this.filterMap.get(mode).setEditable(true);
        this.filterMap.get(mode).setText("");
        this.buttonMap.get(mode).setEnabled(true);
        this.searchModeMap.get(mode).setEnabled(true);
    }

    class CountryTableModel
    extends BGTableModel<Country> {
        public CountryTableModel() {
            super(CountryTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 0, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class CityTableModel
    extends BGTableModel<City> {
        public CityTableModel() {
            super(CityTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 100, 150, 200, "countryTitle", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 0, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(City city, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("countryTitle".equals(identifier)) {
                return city.getCountry().getTitle();
            }
            if ("title".equals(identifier)) {
                return city.toTitle();
            }
            return super.getValue(city, column);
        }
    }

    class CityItemTableModel
    extends BGTableModel<CityItem> {
        private String name;

        public CityItemTableModel(String name) {
            super(CityItemTableModel.class.getName());
            this.name = "?";
            this.name = name;
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 100, 150, 200, "country_title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 0, 150, 250, "city_title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn(this.name, 0, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(CityItem cityItem, int column) throws Exception {
            switch (this.getIdentifier(column)) {
                case "country_title": {
                    return cityItem.getCity().getCountry().getTitle();
                }
                case "city_title": {
                    return cityItem.getCity().getTitle();
                }
                case "title": {
                    return cityItem.toTitle();
                }
            }
            return super.getValue(cityItem, column);
        }
    }

    class HouseTableModel
    extends BGTableModel<Element> {
        public HouseTableModel() {
            super(HouseTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 100, 150, 200, "country_title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 0, 150, 250, "city_title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0439\u043e\u043d/\u041a\u0432\u0430\u0440\u0442\u0430\u043b/\u0423\u043b\u0438\u0446\u0430", 0, -1, -1, "item_title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u043e\u043c", 70, 70, 70, DirectoryAddressEditorTab.HOUSE, true, HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 0, -1, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class ImportDialog
    extends BGEditorDialog<Integer> {
        private JTextArea text;

        public ImportDialog(String title, Integer data) {
            super(title, data);
            this.text = new JTextArea(20, 50);
        }

        @Override
        public void doDialogPanel() {
            this.text.setMargin(new Insets(3, 3, 3, 3));
            this.panel.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.text), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.text.getText().isBlank()) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430...");
                return false;
            }
            int mode = switch (DirectoryAddressEditorTab.this.mode) {
                case AddressEntityType.COUNTRY -> AddressEntityType.COUNTRY.getCode();
                case AddressEntityType.CITY -> AddressEntityType.CITY.getCode();
                case AddressEntityType.AREA -> AddressEntityType.AREA.getCode();
                case AddressEntityType.QUARTER -> AddressEntityType.QUARTER.getCode();
                case AddressEntityType.STREET -> AddressEntityType.STREET.getCode();
                case AddressEntityType.HOUSE -> AddressEntityType.HOUSE.getCode();
                default -> 0;
            };
            ((ClientContext)DirectoryAddressEditorTab.this.getContext()).getWebService(AddressService.class, 0).addressImport(mode, ((Integer)this.data).intValue(), this.text.getText());
            DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.this.mode);
            return true;
        }
    }
}

