/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.v1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.v1.OldDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.v1.OldDataLogRecord;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;

public class OldDataLogReader
extends DataLogReader<OldDataLog>
implements FlowReader {
    protected final int recordSize = 20;
    protected final FlowArray<OldDataLogRecord> recordList;
    protected long milliseconds = -1L;

    protected OldDataLogReader(OldDataLog dataLog, ByteBuffer readBuffer) {
        super(dataLog, readBuffer);
        this.milliseconds = dataLog.hour.getTimeInMillis();
        this.readBuffer.position(this.readBuffer.capacity());
        int size = this.readBuffer.capacity() / 20;
        ArrayList<OldDataLogRecord> recordList = new ArrayList<OldDataLogRecord>(size);
        for (int i = 0; i < size; ++i) {
            recordList.add(new OldDataLogRecord());
        }
        this.recordList = new FlowArray(recordList);
    }

    public FlowArray<OldDataLogRecord> readChunk() {
        int offset;
        if (this.readBuffer.remaining() == 0) {
            try {
                if (this.readBuffer(this.readBuffer) == -1) {
                    return null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        int limit = this.readBuffer.limit() - 1;
        int timeOffset = -1;
        int arrayOffset = 0;
        for (offset = 0; offset < limit; offset += 20) {
            if (this.readBuffer.getInt(offset + 8) == -8913033 && this.readBuffer.getInt(offset + 16) == 0) {
                timeOffset = offset + 12;
                this.milliseconds = this.getMilliseconds(this.readBuffer, timeOffset);
                continue;
            }
            OldDataLogRecord rec = ((OldDataLogRecord[])this.recordList.array)[arrayOffset++];
            this.readBuffer.position(offset);
            rec.fillData(this.readBuffer);
            rec.setMilliseconds(this.milliseconds);
        }
        this.readBuffer.position(offset);
        this.recordList.size = arrayOffset;
        return this.recordList;
    }

    private long getMilliseconds(ByteBuffer byteBuffer, int timeOffset) {
        return ((long)byteBuffer.getInt(timeOffset) & 0xFFFFFFFFL) * 1000L + ((long)byteBuffer.getInt(timeOffset + 4) & 0xFFFFFFFFL) / 1000000L;
    }
}

