/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

public class BGNotification
extends JPopupMenu {
    private static final int MAXIMUM = 6;
    private static Timer timer = null;
    private static final Semaphore timerSemaphore = new Semaphore(1);
    private static ActionListener disappear = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            popup.setVisible(false);
            if (popup.getState() != null) {
                BGNotification.popup.getState().parent.setBackground(BGNotification.popup.getState().oldBackground);
            }
            timerSemaphore.release();
        }
    };
    private static final LinkedList<PopupState> messageQueue = new LinkedList();
    private static final Semaphore queueSemaphore = new Semaphore(0);
    private static final BGNotification popup = new BGNotification();
    private static final Thread showThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (timer == null) {
                timer = new Timer(3000, disappear);
                timer.setRepeats(false);
            }
            while (true) {
                try {
                    timerSemaphore.acquire();
                    queueSemaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PopupState state = null;
                LinkedList<PopupState> linkedList = messageQueue;
                synchronized (linkedList) {
                    if (!messageQueue.isEmpty()) {
                        state = messageQueue.poll();
                    }
                }
                if (state == null) continue;
                BGNotification.popup.headLabel.setText(state.head);
                BGNotification.popup.bodyLabel.setText(state.body);
                popup.setVisible(true);
                popup.setVisible(false);
                Point loc = state.parent.getLocationOnScreen();
                loc.x += state.parent.getWidth() / 2;
                loc.x -= popup.getWidth() / 2;
                loc.y -= popup.getHeight() + 10;
                popup.setLocation(loc);
                popup.setBackground(state.background);
                state.oldBackground = state.parent.getBackground();
                state.parent.setBackground(state.background);
                popup.setVisible(true);
                popup.setState(state);
                timer.start();
            }
        }
    });
    private PopupState state;
    private JLabel headLabel = new JLabel();
    private JLabel bodyLabel = new JLabel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showPopup(Component parent, String head, String body, boolean error) {
        PopupState state = new PopupState();
        state.head = head;
        state.body = body;
        state.background = error ? new Color(255, 0, 0, 150) : new Color(255, 255, 0, 150);
        state.parent = parent;
        state.parent = parent;
        LinkedList<PopupState> linkedList = messageQueue;
        synchronized (linkedList) {
            if (messageQueue.size() == 6) {
                messageQueue.poll();
            }
            messageQueue.add(state);
            queueSemaphore.release();
        }
        if (!showThread.isAlive()) {
            showThread.start();
        }
    }

    private void setState(PopupState state) {
        this.state = state;
    }

    private PopupState getState() {
        return this.state;
    }

    private BGNotification() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() >= 2) {
                    timer.stop();
                    for (ActionListener al : timer.getActionListeners()) {
                        al.actionPerformed(null);
                    }
                }
            }
        });
        this.setToolTipText("Double-click to close");
        this.setMinimumSize(new Dimension(200, 80));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.headLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.bodyLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private static class PopupState {
        String head;
        String body;
        Color background;
        Component parent;
        Color oldBackground;

        private PopupState() {
        }
    }
}

