/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.common.bean;

import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.CityItem;
import ru.bitel.oss.kernel.directories.address.common.event.AreaModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

@DirectoryItem(eventClass=AreaModifiedEvent.class, serviceClass=AddressService.class)
public class Area
extends CityItem {
    public Area() {
    }

    public Area(City city, int id, String title) {
        super(id, title);
        this.setCity(city);
    }

    public static Area from(Area area) {
        return Area.builder().setId(area.getId()).setTitle(area.getTitle()).setTitlePrefix(area.getTitlePrefix()).setTitleSuffix(area.getTitleSuffix()).setCityId(area.getCityId()).setCity(area.getCity()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Area area = new Area();

        private Builder() {
        }

        public Builder setId(int id) {
            this.area.id = id;
            return this;
        }

        public Builder setCityId(int cityId) {
            this.area.cityId = cityId;
            return this;
        }

        public Builder setCity(City city) {
            this.area.setCity(city);
            return this;
        }

        public Builder setTitle(String title) {
            this.area.title = title;
            return this;
        }

        public Builder setTitlePrefix(String titlePrefix) {
            this.area.setTitlePrefix(titlePrefix);
            return this;
        }

        public Builder setTitleSuffix(String titleSuffix) {
            this.area.setTitleSuffix(titleSuffix);
            return this;
        }

        public Area build() {
            try {
                Area area = this.area;
                return area;
            }
            finally {
                this.area = null;
            }
        }
    }
}

