/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;
import ru.bitel.common.StartElementIterator;
import ru.bitel.common.XMLUtils;

class BGXMLEventReaderImpl
extends EventReaderDelegate
implements XMLUtils.BGXMLEventReader {
    private final DepthEventFilter depth = new DepthEventFilter();

    BGXMLEventReaderImpl(XMLInputFactory factory, XMLEventReader reader) throws XMLStreamException {
        reader = factory.createFilteredReader(reader, this.depth);
        this.setParent(reader);
    }

    @Override
    public int getCurrentDepth() {
        return this.depth.depth;
    }

    @Override
    @Deprecated
    public Iterable<StartElement> newStartElementIterator(String path) {
        return this.iterable(path);
    }

    @Override
    public String getAttributeValue(StartElement element, String localPart) {
        Attribute attr = element.getAttributeByName(new QName(localPart));
        return attr != null ? attr.getValue() : null;
    }

    @Override
    public Map<String, String> getAttributes(StartElement element) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator<Attribute> i = element.getAttributes();
        while (i.hasNext()) {
            Attribute attr = i.next();
            result.put(attr.getName().getLocalPart(), attr.getValue());
        }
        return result;
    }

    @Override
    public Iterable<StartElement> iterable(String path) {
        return new StartElementIterator(this, path);
    }

    private class DepthEventFilter
    implements EventFilter {
        int depth = -1;
        private int currentPos = -1;
        private int last = -1;

        private DepthEventFilter() {
        }

        @Override
        public boolean accept(XMLEvent event) {
            int eventType = event.getEventType();
            Location loc = event.getLocation();
            int pos = loc.getCharacterOffset();
            if (pos != this.currentPos || this.last != eventType) {
                this.currentPos = pos;
                switch (event.getEventType()) {
                    case 1: {
                        ++this.depth;
                        break;
                    }
                    case 2: {
                        --this.depth;
                        break;
                    }
                    case 7: {
                        ++this.depth;
                        break;
                    }
                    case 8: {
                        --this.depth;
                        break;
                    }
                }
            }
            this.last = eventType;
            return true;
        }
    }
}

