/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.plugin.server;

import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginManagerBase;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.event.PluginConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BGPluginManagerServer
extends BGPluginManagerBase {
    private BGLogger logger = new BGLogger(this);
    private Map<String, BGPluginServer> pluginsMap = new LinkedHashMap<String, BGPluginServer>();
    private Map<Integer, BGPluginServer> pluginsUIDMap = new HashMap<Integer, BGPluginServer>();

    public void init(Connection con, String applicationName) throws BGException {
        this.logger.getLogger().info("Plugins init...");
        for (OnDestroyServer p : BGPluginManagerServer.getManager().getInvokeables(OnDestroyServer.class, false)) {
            p.onDestroyServer(applicationName);
        }
        this.pluginsUIDMap.clear();
        this.cacheInvokeablePoints.clear();
        this.cacheExtensionPoints.clear();
        HashMap<String, String[]> pluginsDataMap = new HashMap<String, String[]>();
        String query = "SELECT name, id, pack_server, plugin_config.config FROM installed_modules LEFT JOIN plugin_config ON plugin_config.pid=installed_modules.id WHERE type='plugin' AND enabled=1";
        try (PreparedStatement ps = con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String[] data = new String[]{rs.getString(2), rs.getString(3), rs.getString(4)};
                pluginsDataMap.put(rs.getString(1), data);
            }
        }
        catch (Exception e) {
            throw new BGException("error plugin load", e);
        }
        HashMap<String, BGPluginServer> pluginsMapTemp = new HashMap<String, BGPluginServer>();
        for (URL pluginUrl : BGPluginManagerServer.getPlugins()) {
            try {
                if (this.logger.getLogger().isDebugEnabled()) {
                    this.logger.getLogger().debug("pluginUrl = " + pluginUrl);
                }
                BGPluginServer plugin = new BGPluginServer();
                InputStream inputStream = pluginUrl.openStream();
                if (inputStream != null) {
                    plugin.setDocument(XMLUtils.parseDocument(new InputSource(inputStream)));
                    if (this.logger.getLogger().isDebugEnabled()) {
                        this.logger.getLogger().debug("plugin.getId() = {}", (Object)plugin.getId());
                    }
                }
                plugin.setResourceBundle(ResourceBundle.getBundle(plugin.getId() + ".plugin"));
                if (!pluginsDataMap.containsKey(plugin.getId())) continue;
                Object[] data = (String[])pluginsDataMap.get(plugin.getId());
                if (this.logger.getLogger().isDebugEnabled()) {
                    this.logger.getLogger().debug("data = {}", data);
                }
                plugin.setPluginUID(Integer.parseInt(data[0]));
                plugin.setPackServer((String)data[1]);
                if (data[2] != null) {
                    plugin.setSetup(new Preferences((String)data[2], "\r\n"));
                }
                pluginsMapTemp.put(plugin.getId(), plugin);
                this.pluginsUIDMap.put(plugin.getPluginUID(), plugin);
                if (!this.logger.getLogger().isDebugEnabled()) continue;
                this.logger.getLogger().debug("plugin " + plugin.getId() + " load");
            }
            catch (Exception ex) {
                throw new BGException("error plugin " + pluginUrl.toString() + " load", ex);
            }
        }
        LinkedHashMap<String, BGPluginServer> sortedPluginsMap = new LinkedHashMap<String, BGPluginServer>();
        try {
            String pluginsOrderConf = Setup.getSetup().get("plugins.order");
            if (Utils.notBlankString(pluginsOrderConf)) {
                String[] plugins;
                for (String plugin : plugins = pluginsOrderConf.split(",")) {
                    String pluginId = "ru.bitel.bgbilling.plugins." + plugin.trim();
                    BGPluginServer pluginServer = (BGPluginServer)pluginsMapTemp.get(pluginId);
                    if (pluginServer == null) continue;
                    pluginsMapTemp.remove(pluginId);
                    sortedPluginsMap.put(pluginId, pluginServer);
                }
            }
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        sortedPluginsMap.putAll(pluginsMapTemp);
        this.pluginsMap = sortedPluginsMap;
        for (OnInitServer p : BGPluginManagerServer.getManager().getInvokeables(OnInitServer.class, false)) {
            p.onInitServer(applicationName);
        }
    }

    public static final BGPluginManagerServer getManager() {
        if (ourInstance == null) {
            ourInstance = new BGPluginManagerServer();
        }
        return (BGPluginManagerServer)ourInstance;
    }

    @Override
    public BGPluginServer getPlugin(String id) {
        return this.pluginsMap.get(id);
    }

    public BGPluginServer getPluginByUID(int uid) {
        return this.pluginsUIDMap.get(uid);
    }

    public Optional<BGPluginServer> optPluginByUID(int uid) {
        return Optional.ofNullable(this.pluginsUIDMap.get(uid));
    }

    public Map<String, BGPluginServer> getPluginsMap() {
        return this.pluginsMap;
    }

    public <T> Collection<BGPluginServer> getPluginsForInvokeablePoints(Class<T> point) {
        return this.pluginsMap.values();
    }

    static {
        try {
            EventProcessor.getInstance().addListener(new EventListener<PluginConfigModifiedEvent>(){

                @Override
                public void notify(PluginConfigModifiedEvent e, EventListenerContext ctx) throws BGException {
                    BGPluginManagerServer.getManager().init(ctx.getConnection(), ctx.getApplicationName());
                }
            }, PluginConfigModifiedEvent.class);
        }
        catch (BGException ex) {
            BGLogger.error(ex);
        }
    }
}

