/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.ActionPerformer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Contractable;

public class AbstractMonitorPanel
extends BGUPanel
implements ActionPerformer {
    private transient Vector<ActionListener> actionListeners;
    protected BGTableModel<?> model;
    protected BGUTable table;

    @Override
    protected void jbInit() {
        this.table = new BGUTable(this.model);
        JButton close = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        close.addActionListener(e -> close.getParent().getParent().setVisible(false));
        JButton openContract = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        openContract.addActionListener(e -> this.openSelectedContract());
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)close, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)openContract, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.openSelectedContract());
    }

    private void openSelectedContract() {
        this.model.optSelectedRow().ifPresent(a -> {
            if (a instanceof Contractable) {
                Contractable selected = (Contractable)a;
                BGClientBase.getFrame().getTabbedPane().addContractEditorTab(selected.getContractId());
            }
        });
    }

    @Override
    public void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector<ActionListener> listeners = new Vector<ActionListener>(this.actionListeners);
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).actionPerformed(e);
            }
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector<ActionListener> v = new Vector<ActionListener>();
        if (this.actionListeners != null) {
            v.addAll(this.actionListeners);
        }
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }
}

