/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.web.action;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class XSLManager {
    private static final Logger logger = LogManager.getLogger();
    private static final String DEFAULT_XSL_ROOT_PATH = "webroot/xsl/";
    private String xslRootPath = null;
    private static XSLManager instance;
    private boolean cacheTemplates = false;
    private final HashMap<String, Templates> templates = new HashMap(32);
    private static ErrorListener errorListener;

    public static final XSLManager getInstance() {
        if (instance == null) {
            instance = new XSLManager();
        }
        return instance;
    }

    private XSLManager() {
        this.reloadConfig();
        File rootPath = new File(DEFAULT_XSL_ROOT_PATH);
        if (rootPath.exists() && rootPath.isDirectory()) {
            this.xslRootPath = DEFAULT_XSL_ROOT_PATH;
        } else {
            String envServerDir = System.getenv("BGBILLING_SERVER_DIR");
            if (Utils.notBlankString(envServerDir) && (rootPath = Paths.get(envServerDir, DEFAULT_XSL_ROOT_PATH).toFile()).exists() && rootPath.isDirectory()) {
                this.xslRootPath = rootPath.getAbsolutePath();
                if (!this.xslRootPath.endsWith(File.separator)) {
                    this.xslRootPath = this.xslRootPath + File.separator;
                }
            }
        }
        if (this.xslRootPath == null) {
            logger.fatal("error or not found xsl root path (webroot/xsl/ or env var \"BGBILLING_SERVER_DIR\")");
        }
    }

    public void reloadConfig() {
        this.cacheTemplates = Setup.getSetup().getBoolean("xslt.cache", true);
    }

    public String getXslRootPath() {
        return this.xslRootPath;
    }

    public File getTemplateFile(String xsltFile) {
        if (this.xslRootPath != null) {
            return new File(this.xslRootPath + xsltFile);
        }
        return new File("/error-xsl-root-path/" + xsltFile);
    }

    private final Transformer getTransformer(String xsltFile, Map<String, Object> transformerParams) throws BGException {
        if (Utils.isEmptyString(xsltFile)) {
            throw new BGException("XSLT file name is empty!");
        }
        try {
            Transformer transformer;
            if (this.cacheTemplates) {
                Templates template = this.templates.get(xsltFile);
                if (template == null) {
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    tFactory.setErrorListener(errorListener);
                    File file = this.getTemplateFile(xsltFile);
                    if (file.exists()) {
                        template = tFactory.newTemplates(new StreamSource(file));
                        this.templates.put(xsltFile, template);
                    }
                }
                transformer = template != null ? template.newTransformer() : null;
            } else {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                tFactory.setErrorListener(errorListener);
                transformer = tFactory.newTransformer(new StreamSource(this.getTemplateFile(xsltFile)));
            }
            if (transformer == null) {
                throw new BGException("error new transformer for template xslt file (does not exist?) " + this.getTemplateFile(xsltFile).getAbsolutePath());
            }
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.setParameter("xsltFile", xsltFile);
            transformer.setErrorListener(errorListener);
            if (transformerParams != null) {
                for (Map.Entry<String, Object> e : transformerParams.entrySet()) {
                    transformer.setParameter(e.getKey(), e.getValue());
                }
            }
            return transformer;
        }
        catch (TransformerConfigurationException ex) {
            throw new BGException("Error XSLT file " + xsltFile, ex);
        }
    }

    public final void transform(Source source, String xsltFile, Node out) throws BGException {
        this.transform(source, xsltFile, new DOMResult(out), null);
    }

    public final void transform(Source source, String xsltFile, OutputStream out) throws BGException {
        this.transform(source, xsltFile, new StreamResult(out), null);
    }

    public final void transform(Source source, String xsltFile, Result out) throws BGException {
        this.transform(source, xsltFile, out, null);
    }

    public final void transform(Source source, String xsltFile, Result out, Map<String, Object> transformerParams) throws BGException {
        try {
            this.getTransformer(xsltFile, transformerParams).transform(source, out);
        }
        catch (Exception ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 " + xsltFile, ex);
        }
    }

    public void transformToResponse(HttpServletResponse response, String xsltFile, Source source, Map<String, Object> transformerParams, String contentType, String fileName, boolean zip) throws BGException {
        Transformer transformer = this.getTransformer(xsltFile, transformerParams);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IOException ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 (IO) \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 " + xsltFile, ex);
        }
        this._transform(transformer, (OutputStream)out, xsltFile, source, fileName, zip);
        if (zip) {
            response.setContentType("application/zip");
            response.setHeader("Content-disposition", "filename=" + fileName + ".zip");
        } else {
            if (fileName != null) {
                response.setHeader("Content-disposition", "filename=" + fileName);
            }
            String encoding = transformer.getOutputProperty("encoding");
            if (((String)contentType).startsWith("text")) {
                contentType = (String)contentType + "; charset=" + encoding;
            }
            response.setContentType((String)contentType);
            response.setCharacterEncoding(encoding);
        }
    }

    public void transform(OutputStream out, String xsltFile, Source source, Map<String, Object> transformerParams, String fileName, boolean zip) throws BGException {
        this._transform(this.getTransformer(xsltFile, transformerParams), out, xsltFile, source, fileName, zip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _transform(Transformer transformer, OutputStream out, String xsltFile, Source source, String fileName, boolean zip) throws BGException {
        try {
            ZipOutputStream z = null;
            try {
                if (zip) {
                    z = new ZipOutputStream(out);
                    z.putNextEntry(new ZipEntry(fileName));
                    out = z;
                }
                transformer.transform(source, new StreamResult(out));
            }
            finally {
                if (z != null) {
                    z.closeEntry();
                    z.flush();
                    z.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
        catch (IOException ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 (IO) \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 " + xsltFile, ex);
        }
        catch (TransformerException ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 (transformer) \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 " + xsltFile, ex);
        }
    }

    public DataSource transform(String xsltFile, Source source, Map<String, Object> params, String contentType, String fileName, boolean zip) throws BGException {
        Transformer transformer = this.getTransformer(xsltFile, params);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        this._transform(transformer, baos, xsltFile, source, fileName, zip);
        if (zip) {
            contentType = "application/zip";
        } else {
            String encoding = transformer.getOutputProperty("encoding");
            if (((String)contentType).startsWith("text")) {
                contentType = (String)contentType + "; charset=" + encoding;
            }
        }
        ByteArrayDataSource dataSource = new ByteArrayDataSource(baos.toByteArray(), (String)contentType);
        if (fileName != null) {
            if (zip) {
                dataSource.setName(fileName + ".zip");
            } else {
                dataSource.setName(fileName);
            }
        }
        return dataSource;
    }

    public void transformAndSend(String xsltFile, Source source, Map<String, Object> params, String contentType, String fileName, boolean zip, String email, String emailSubject) throws BGException {
        try {
            emailSubject = Utils.maskBlank(emailSubject, "REPORT");
            DataSource dataSource = this.transform(xsltFile, source, params, contentType, fileName, zip);
            MimeMultipart m = new MimeMultipart();
            MimeBodyPart attach = new MimeBodyPart();
            m.addBodyPart((BodyPart)attach);
            attach.setDataHandler(new DataHandler(dataSource));
            if (fileName != null) {
                attach.setFileName(dataSource.getName());
            }
            new MailMsg((Preferences)Setup.getSetup()).sendMessage(email, emailSubject, (Multipart)m);
        }
        catch (MessagingException ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 (mail) \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 " + xsltFile, ex);
        }
    }

    static {
        errorListener = new ErrorListener(){

            private boolean check(TransformerException e) {
                Throwable t = e;
                while (((Throwable)t).getCause() != null) {
                    Exception x;
                    if (!((t = ((Throwable)t).getCause()) instanceof SAXException ? (x = ((SAXException)t).getException()) instanceof IOException || x instanceof EOFException || x instanceof SocketException : t instanceof IOException || t instanceof EOFException || t instanceof SocketException)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void error(TransformerException e) throws TransformerException {
                if (this.check(e)) {
                    logger.error("error transform", (Throwable)e);
                }
            }

            @Override
            public void fatalError(TransformerException e) throws TransformerException {
                if (this.check(e)) {
                    throw new TransformerException("fatal error transform", e);
                }
            }

            @Override
            public void warning(TransformerException e) throws TransformerException {
                if (this.check(e)) {
                    logger.warn("warning transform", (Throwable)e);
                }
            }
        };
    }
}

