/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.pc.server;

import jakarta.servlet.Servlet;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.server.api.DynamicExecutor;
import ru.bitel.bgbilling.server.api.HttpService;
import ru.bitel.bgbilling.server.util.KeyStoreUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public interface BGServerUtils {
    default public void initConnectors(Service service, Connector oldConnector) {
        Setup setup = Setup.getSetup();
        Logger logger = LogManager.getLogger();
        service.removeConnector(oldConnector);
        String connectorHttp = null;
        connectorHttp = setup.get("connector.http");
        logger.info("HTTP Connector: " + connectorHttp);
        if (connectorHttp != null) {
            String maxThreads = setup.get("connector.http.thread.max", "100");
            String compression = setup.get("connector.http.compression", "off");
            for (String connectorHttpItem : connectorHttp.split(",")) {
                int port;
                int pos = (connectorHttpItem = connectorHttpItem.trim()).lastIndexOf(58);
                if (pos <= -1) continue;
                String host = connectorHttpItem.substring(0, pos);
                if ("*".equals(host)) {
                    String string = host = "true".equals(System.getProperty("java.net.preferIPv4Stack")) ? "0.0.0.0" : "::";
                }
                if ((port = Utils.parseInt((String)connectorHttpItem.substring(pos + 1), (int)-1)) <= 0) continue;
                logger.info("Starting HTTP connector " + host + ":" + port + "...");
                Connector connector = new Connector();
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)host);
                connector.setPort(port);
                connector.setEnableLookups(false);
                connector.setProperty("maxThreads", maxThreads);
                connector.setProperty("compression", compression);
                connector.setProperty("compressionMinSize", "2048");
                connector.setProperty("compressableMimeType", "text/xml");
                connector.setProperty("sendReasonPhrase", "true");
                this.setCommonConnectorOptions(connector);
                service.addConnector(connector);
            }
        }
        String connectorHttps = setup.get("connector.https");
        logger.info("HTTPS Connector: " + connectorHttps);
        if (connectorHttps != null) {
            String connectorHttpsThreadMax = setup.get("connector.https.thread.max", "10");
            String sslEnabledProtocols = setup.get("connector.https.sslEnabledProtocols", null);
            String sslCiphers = setup.get("connector.https.ciphers", null);
            for (String connectorHttpsItem : connectorHttps.split(",")) {
                int port;
                int pos = (connectorHttpsItem = connectorHttpsItem.trim()).lastIndexOf(58);
                if (pos <= -1) continue;
                String host = connectorHttpsItem.substring(0, pos);
                if ("*".equals(host)) {
                    String string = host = "true".equals(System.getProperty("java.net.preferIPv4Stack")) ? "0.0.0.0" : "::";
                }
                if ((port = Utils.parseInt((String)connectorHttpsItem.substring(pos + 1), (int)-1)) <= 0) continue;
                logger.info("Starting HTTPS connector " + host + ":" + port + "...");
                String password = setup.get("keystore.password", "bgbilling");
                String alias = setup.get("keystore.alias");
                Connector connector = new Connector();
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)host);
                connector.setPort(port);
                connector.setEnableLookups(false);
                connector.setScheme("https");
                connector.setProperty("SSLEnabled", "true");
                connector.setProperty("maxThreads", connectorHttpsThreadMax);
                connector.setProperty("sendReasonPhrase", "true");
                SSLHostConfig sslConfig = new SSLHostConfig();
                if (KeyStoreUtils.getKeyStoreFile().exists()) {
                    SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslConfig, SSLHostConfigCertificate.Type.RSA);
                    certificate.setCertificateKeyPassword(password);
                    certificate.setCertificateKeystorePassword(password);
                    if (alias != null) {
                        certificate.setCertificateKeyAlias(alias);
                    }
                    certificate.setCertificateKeystoreFile(KeyStoreUtils.getKeyStoreFile().getAbsolutePath());
                    sslConfig.addCertificate(certificate);
                    if (KeyStoreUtils.checkTrustStoreNotEmpty(password)) {
                        logger.info("Found public certificates in keystore. Set as truststore.");
                        sslConfig.setTruststoreFile(KeyStoreUtils.getKeyStoreFile().getAbsolutePath());
                        sslConfig.setTruststorePassword(password);
                    } else {
                        logger.info("Not found public certificates in keystore. Skip as truststore.");
                        sslConfig.setTruststorePassword(password);
                    }
                    sslConfig.setCertificateVerification("want");
                    connector.addSslHostConfig(sslConfig);
                } else {
                    logger.error("KeyStore file " + KeyStoreUtils.getKeyStoreFile().getAbsolutePath() + " NOT FOUND! Certificates and private key not loaded!");
                }
                this.setCommonConnectorOptions(connector);
                if (sslEnabledProtocols != null) {
                    connector.setProperty("sslEnabledProtocols", sslEnabledProtocols);
                }
                if (sslCiphers != null) {
                    connector.setProperty("ciphers", sslCiphers);
                }
                service.addConnector(connector);
            }
        }
    }

    private void setCommonConnectorOptions(Connector connector) {
        Setup setup = Setup.getSetup();
        connector.setUseBodyEncodingForURI(true);
        connector.setMaxPostSize(setup.getInt("max.post.size", 10000000));
        connector.setMaxSavePostSize(1000000);
    }

    default public void addServlet(StandardContext context, String servletName, String servletClass, String[] mappings) {
        Logger logger = LogManager.getLogger();
        if (mappings != null && servletClass != null) {
            try {
                Class<?> clazz;
                Object servlet = (Servlet)Utils.newInstance((String)servletClass, Servlet.class);
                if (servlet == null && (clazz = DynamicClassManager.getInstance().loadClass(servletClass)) != null && HttpService.class.isAssignableFrom(clazz)) {
                    servlet = new DynamicExecutor(servletClass);
                }
                if (servlet != null) {
                    servletName = servletName != null ? servletName : servletClass;
                    Wrapper wrapper = context.createWrapper();
                    wrapper.setName(servletName);
                    wrapper.setServletClass(servletClass);
                    wrapper.setServlet(servlet);
                    context.addChild((Container)wrapper);
                    for (String mapping : mappings) {
                        context.addServletMappingDecoded(mapping, servletName);
                        logger.info("Add mapping: " + servletClass + " to " + mapping);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error while init class " + servletClass, (Throwable)e);
            }
        }
    }

    default public void setServletFilter(StandardContext context, Map<String, WebFilter> filtersMap) {
        Logger logger = LogManager.getLogger();
        ArrayList sortKeys = new ArrayList();
        filtersMap.keySet().forEach(e -> sortKeys.add(e));
        Collections.sort(sortKeys, (o1, o2) -> {
            int sort1 = Utils.parseInt((String)this.getSort((WebFilter)filtersMap.get(o1)), (int)Integer.MAX_VALUE);
            int sort2 = Utils.parseInt((String)this.getSort((WebFilter)filtersMap.get(o2)), (int)Integer.MAX_VALUE);
            return sort1 - sort2;
        });
        for (String filterClass : sortKeys) {
            WebFilter webFilter = filtersMap.get(filterClass);
            String filterName = webFilter.filterName();
            String[] mappings = webFilter.urlPatterns();
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            filterDef.setFilterClass(filterClass);
            for (WebInitParam webInitParam : webFilter.initParams()) {
                filterDef.addInitParameter(webInitParam.name(), webInitParam.value());
            }
            context.addFilterDef(filterDef);
            for (String string : mappings) {
                FilterMap filterMap = new FilterMap();
                filterMap.addURLPattern(string);
                filterMap.setFilterName(filterName);
                context.addFilterMap(filterMap);
                logger.info("Add mapping: " + filterClass + " to " + string);
            }
        }
    }

    default public void checkFiles(String[] customFileName) {
        Logger logger = LogManager.getLogger();
        Path webrootPath = Paths.get("webroot", new String[0]);
        if (Files.exists(webrootPath, new LinkOption[0])) {
            Path customPath = Paths.get(webrootPath.toString(), customFileName);
            if (!Files.exists(customPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(customPath.getParent(), new FileAttribute[0]);
                    Files.createFile(customPath, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                }
            }
        } else {
            logger.error(webrootPath.toString() + " not found!");
        }
    }

    private String getSort(WebFilter webFilter) {
        String sort = "";
        for (WebInitParam webInitParam : webFilter.initParams()) {
            if (!"sort".equals(webInitParam.name())) continue;
            sort = webInitParam.value();
        }
        return sort;
    }
}

