/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPatternNamedNumber;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPatternNamedNumberDao;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractParameterData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractPatternInfo;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractCreateInfo;
import ru.bitel.bgbilling.kernel.generator.common.bean.BGGenerator;
import ru.bitel.bgbilling.kernel.generator.common.bean.enums.BGGeneratorType;
import ru.bitel.bgbilling.kernel.generator.server.bean.BGGeneratorDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ContractPatternDao
extends AbstractIdDao<ContractPattern> {
    public static final String TITLE_PARAM_CARD = "card";
    public static final String TITLE_PARAM_CARD_SERIES = "card_series";
    private static List<ContractCreateInfo> lastTitles = new ArrayList<ContractCreateInfo>();
    private static Map<Integer, ContractPattern> cache = null;

    public ContractPatternDao(Connection con) {
        super(con, 0, "contract_pattern");
        if (cache == null) {
            this.reloadCache();
        }
    }

    public ContractPattern getPattern(int id) throws BGException {
        return this.optPattern(id).map(a -> a.copy()).orElse(null);
    }

    public Optional<ContractPattern> optPattern(int id) throws BGException {
        return Optional.ofNullable(cache.get(id));
    }

    public List<IdTitle> contractPatternTitles(boolean showHidden) throws Exception {
        ArrayList<IdTitle> titles = new ArrayList<IdTitle>();
        String query = "SELECT id, title FROM contract_pattern" + (showHidden ? "" : " WHERE `hidden`=0") + " ORDER BY title";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                titles.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
        }
        return titles;
    }

    private void loadContractPattern(ContractPattern result, ResultSet rs) throws Exception {
        Element modulesElement;
        PatternData patternData = this.parsePatternData(rs.getBytes("data"));
        result.setData(patternData.doc);
        this.deserializePattern(result);
        result.setClosesumma(rs.getBigDecimal("closesumma")).setTariffPlanList(Utils.toList(rs.getString("tpid"))).setGroups(rs.getLong("contract_groups")).setDaysToLive(rs.getInt("dtl")).setFc(rs.getInt("fc")).setMode(rs.getInt("mode")).setParamsGroupId(rs.getInt("pgid")).setTitle(rs.getString("title")).setTariffGroupList(Utils.toIntegerList(rs.getString("tgid"))).setScriptList(Utils.toIntegerList(rs.getString("scrid"))).setNamePatternId(rs.getInt("name_pattern_id")).setHidden(rs.getBoolean("hidden")).setPatternId(rs.getInt("patid")).setDomainId(rs.getInt("domainId")).setId(rs.getInt("id"));
        ArrayList<Element> modules = new ArrayList<Element>();
        String query = "SELECT mid FROM contract_pattern_modules WHERE pid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, result.getId());
            try (ResultSet rsModules = ps.executeQuery();){
                while (rsModules.next()) {
                    Element moduleElement = patternData.doc.createElement("module");
                    moduleElement.setAttribute("mid", rsModules.getString(1));
                    modules.add(moduleElement);
                }
            }
        }
        query = "SELECT sid, mid FROM contract_pattern_services LEFT JOIN service ON sid=id WHERE pid=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, result.getId());
            try (ResultSet rsServices = ps.executeQuery();){
                block21: while (rsServices.next()) {
                    String mid = rsServices.getString(2);
                    for (Element moduleElement : modules) {
                        if (!moduleElement.getAttribute("mid").equals(mid)) continue;
                        Element addServicesElement = XMLUtils.selectElement(moduleElement, "addServices");
                        if (addServicesElement == null) {
                            addServicesElement = XMLUtils.createElement(moduleElement, "addServices");
                        }
                        XMLUtils.createElement(addServicesElement, "item").setAttribute("sid", rsServices.getString(1));
                        continue block21;
                    }
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        if (!modules.isEmpty() && (modulesElement = XMLUtils.selectElement(patternData.doc, "/data/modules")) != null) {
            for (Element moduleElement : modules) {
                modulesElement.appendChild(moduleElement);
            }
        }
    }

    public void updateContractPattern(int id, ContractPattern pattern) {
        boolean insert = id < 1;
        try {
            Object query = (insert ? "INSERT INTO " : "UPDATE ") + "contract_pattern SET title=?, closesumma=?, tpid=?, `contract_groups`=?, mode=?, pgid=?, fc=?, dtl=?, tgid=?, scrid=?, name_pattern_id=?, data=?, patid=?, domainId=?, `hidden`=?" + (insert ? "" : " WHERE id=?");
            try (PreparedStatement ps = this.con.prepareStatement((String)query, 1);){
                this.serializePattern(pattern);
                int index = 1;
                ps.setString(index++, pattern.getTitle());
                ps.setBigDecimal(index++, pattern.getClosesumma());
                ps.setString(index++, Utils.toString(pattern.getTariffPlanList()));
                ps.setLong(index++, 0L);
                ps.setInt(index++, pattern.getMode());
                ps.setInt(index++, pattern.getParamsGroupId());
                ps.setInt(index++, pattern.getFc());
                ps.setInt(index++, pattern.getDaysToLive());
                ps.setString(index++, Utils.toString(pattern.getTariffGroupList()));
                ps.setString(index++, Utils.toString(pattern.getScriptList()));
                ps.setInt(index++, pattern.getNamePatternId());
                ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                XMLUtils.serialize((Node)pattern.getData(), bos, "UTF-8");
                ps.setBytes(index++, bos.toByteArray());
                ps.setInt(index++, pattern.getPatternId());
                ps.setInt(index++, pattern.getDomainId());
                ps.setBoolean(index++, pattern.isHidden());
                if (!insert) {
                    ps.setInt(index++, id);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(ps.toString());
                }
                ps.executeUpdate();
                pattern.setId(id > 0 ? id : ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            query = "DELETE FROM contract_pattern_services WHERE pid=?";
            try (PreparedStatement psDelete = this.con.prepareStatement((String)query);){
                psDelete.setInt(1, pattern.getId());
                psDelete.executeUpdate();
            }
            query = "DELETE FROM contract_pattern_modules WHERE pid=?";
            psDelete = this.con.prepareStatement((String)query);
            try {
                psDelete.setInt(1, pattern.getId());
                psDelete.executeUpdate();
            }
            finally {
                if (psDelete != null) {
                    psDelete.close();
                }
            }
        }
        catch (Exception ex) {
            this.logError("error updateContractPattern #" + id, ex);
            throw new RuntimeException(ex);
        }
        this.reloadCache();
    }

    @Override
    public int delete(int patternId) throws SQLException {
        String query = "DELETE FROM contract_pattern WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, patternId);
            ps.executeUpdate();
        }
        query = "DELETE FROM contract_pattern_services WHERE pid=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, patternId);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        this.reloadCache();
        return 0;
    }

    private void serializePattern(ContractPattern pattern) {
        Element data = pattern.getData().getDocumentElement();
        Element general = data.getOwnerDocument().createElement("general");
        data.appendChild(general);
        general.setAttribute("status", "" + pattern.getStatus());
        general.setAttribute("dtl", "" + pattern.getDaysToLive());
        general.setAttribute("limitMode", pattern.getLimitMode());
        general.setAttribute("patternMode", pattern.getPatternMode());
        general.setAttribute("masterHandlerClass", pattern.getMasterHandlerClass());
        general.setAttribute("masterTariffMode", pattern.getMasterTariffMode());
        general.setAttribute("masterRequiredParameterIds", Utils.toString(pattern.getMasterRequiredParameterIds()));
        general.setAttribute("masterOptionalParameterIds", Utils.toString(pattern.getMasterOptionalParameterIds()));
        if (Utils.notBlankString(pattern.getObjectString())) {
            String[] pairs;
            Element objectsElem = data.getOwnerDocument().createElement("objects");
            general.appendChild(objectsElem);
            for (String pair : pairs = pattern.getObjectString().split(",")) {
                String[] curObject = pair.split(":");
                Element objElement = objectsElem.getOwnerDocument().createElement("object");
                objectsElem.appendChild(objElement);
                objElement.setAttribute("type", curObject[0]);
                objElement.setAttribute("amount", curObject[1]);
            }
        }
    }

    private void deserializePattern(ContractPattern pattern) throws Exception {
        Element general;
        if (pattern.getData() != null && (general = XMLUtils.selectElement(pattern.getData(), "//data/general")) != null) {
            pattern.setLimitMode("on".equals(general.getAttribute("limitMode")) ? "on" : "off");
            pattern.setStatus(Utils.parseInt(general.getAttribute("status")));
            pattern.setDaysToLive(Utils.parseInt(general.getAttribute("dtl")));
            pattern.setPatternMode(XMLUtils.getAttribute(general, "patternMode", "basic"));
            pattern.setMasterHandlerClass(XMLUtils.getAttribute(general, "masterHandlerClass", ""));
            pattern.setMasterTariffMode(XMLUtils.getAttribute(general, "masterTariffMode", "noSelectTariff"));
            pattern.setMasterRequiredParameterIds(Utils.toIntegerSet(XMLUtils.getAttribute(general, "masterRequiredParameterIds", "")));
            pattern.setMasterOptionalParameterIds(Utils.toIntegerSet(XMLUtils.getAttribute(general, "masterOptionalParameterIds", "")));
        }
    }

    public String getContractTitle(String namePattern, Date date) throws Exception {
        return this.getContractTitle(namePattern, date, Collections.emptyMap());
    }

    public synchronized String getContractTitle(String namePattern, Date date, Map<String, Object> titleParams) throws Exception {
        String result = null;
        try {
            ContractPatternNamedNumberDao numberDao = new ContractPatternNamedNumberDao(this.con);
            if (lastTitles.size() > 1000) {
                long time = new Date().getTime() / 1000L;
                lastTitles = lastTitles.stream().filter(s -> time - s.date.getTime() / 1000L < 1200L).toList();
            }
            Object regexp = "^";
            Pattern p = Pattern.compile("\\$\\{([\\w_]+)([\\d]*)\\}");
            ArrayList<PatternPart> parts = new ArrayList<PatternPart>(3);
            int numberPosition = 0;
            if (Utils.isEmptyString(namePattern) && titleParams.containsKey(TITLE_PARAM_CARD)) {
                namePattern = "K${card:00000}-${time:yy}";
            }
            int pos = 0;
            int elementPos = 0;
            Matcher m = Pattern.compile("\\$\\{([^}]+)\\}").matcher(namePattern);
            while (m.find()) {
                ++elementPos;
                regexp = (String)regexp + namePattern.substring(pos, m.start());
                pos = m.end();
                int count = 0;
                String letter = m.group(1);
                String format = null;
                Object namedNumber = null;
                if (letter.startsWith("NS")) {
                    String title = letter.substring(2);
                    namedNumber = numberDao.getFromTitle(title);
                    if (namedNumber == null) {
                        throw new BGMessageException("\u0418\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0438\u043c\u0435\u043d\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 -\"" + title + "\" \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d. \u0421\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u0442\u0430\u043a\u043e\u0439, \u043b\u0438\u0431\u043e \u043e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0438\u043c\u0435\u043d\u0438");
                    }
                    count = ((ContractPatternNamedNumber)namedNumber).getCountNumber();
                    letter = "NS";
                } else if (letter.matches("(.+):(.+)")) {
                    m1 = Pattern.compile("(.+):(.+)").matcher(letter);
                    if (!m1.find()) continue;
                    letter = m1.group(1);
                    format = m1.group(2);
                } else if (letter.matches("(.+)(\\d+)")) {
                    m1 = Pattern.compile("(.+)(\\d+)").matcher(letter);
                    if (!m1.find()) continue;
                    letter = m1.group(1);
                    count = Utils.parseInt(m1.group(2), 0);
                    if (letter.equals("N")) {
                        numberPosition = elementPos;
                    }
                }
                regexp = (String)regexp + (String)(count > 0 ? "([0-9]{" + count + "})" : "([0-9a-zA-Z\u0430-\u044f\u0410-\u042f_]+)");
                parts.add(new PatternPart(letter, count, format, (ContractPatternNamedNumber)namedNumber));
            }
            regexp = (String)regexp + namePattern.substring(pos) + "$";
            long lastNumber = 0L;
            if (numberPosition > 0) {
                long number;
                p = Pattern.compile((String)regexp);
                try {
                    Object reg = regexp;
                    for (ContractCreateInfo n : lastTitles.stream().filter(arg_0 -> ContractPatternDao.lambda$getContractTitle$2((String)reg, arg_0)).collect(Collectors.toList())) {
                        m = p.matcher(n.title);
                        if (!m.find() || (number = Utils.parseLong(m.group(numberPosition), 0L)) <= lastNumber) continue;
                        lastNumber = number;
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
                String query = "SELECT title FROM contract WHERE CAST(`title` AS BINARY) REGEXP BINARY '" + (String)regexp + "'";
                try (PreparedStatement ps = this.con.prepareStatement(query);
                     ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        m = p.matcher(rs.getString(1));
                        if (!m.find() || (number = Utils.parseLong(m.group(numberPosition), 0L)) <= lastNumber) continue;
                        lastNumber = number;
                    }
                }
            }
            result = namePattern;
            Collections.sort(parts);
            PatternPart NRpart = null;
            for (PatternPart pp : parts) {
                switch (pp.letter) {
                    case "NS": {
                        String locResult;
                        int i = 0;
                        DecimalFormat dfNS = new DecimalFormat("############" + Utils.multiLetter("0", pp.count));
                        boolean isLastNS = result.indexOf("${") == result.lastIndexOf("${");
                        do {
                            locResult = result.replaceAll(pp.getFullString(), dfNS.format(numberDao.getNextNamedNumberIndex(pp.namedNumber.getTitle())));
                        } while (isLastNS && this.isContractTitleDuplicated(locResult, false, -1) && ++i < 5000);
                        result = locResult;
                        break;
                    }
                    case "N": {
                        DecimalFormat df = new DecimalFormat("############" + Utils.multiLetter("0", pp.count));
                        result = result.replaceAll(pp.getFullString(), df.format(++lastNumber));
                        break;
                    }
                    case "NR": {
                        NRpart = pp;
                        break;
                    }
                    case "Y": {
                        SimpleDateFormat dfY = new SimpleDateFormat(pp.count == 2 ? "yy" : "yyyy");
                        result = result.replaceAll(pp.getFullString(), dfY.format(date.getTime()));
                        break;
                    }
                    case "card_login": 
                    case "card": {
                        Long login = (Long)titleParams.get(TITLE_PARAM_CARD);
                        if (login != null) {
                            if (pp.count > 0 || Utils.notEmptyString(pp.format)) {
                                DecimalFormat dfC = new DecimalFormat(pp.count > 0 ? Utils.multiLetter("0", pp.count) : pp.format);
                                result = result.replaceAll(pp.getFullString(), dfC.format(login));
                                break;
                            }
                            result = result.replaceAll(pp.getFullString(), String.valueOf(login));
                            break;
                        }
                        result = result.replaceAll(pp.getFullString(), "0");
                        break;
                    }
                    case "card_series": {
                        String serial = (String)titleParams.get(TITLE_PARAM_CARD_SERIES);
                        result = result.replaceAll(pp.getFullString(), serial != null ? serial : "0");
                        break;
                    }
                    case "time": {
                        SimpleDateFormat dfT = new SimpleDateFormat(Utils.isEmptyString(pp.format) ? (pp.format = "yy") : pp.format);
                        result = result.replaceAll(pp.getFullString(), dfT.format(date.getTime()));
                    }
                }
            }
            if (NRpart != null) {
                DecimalFormat df = new DecimalFormat(Utils.multiLetter("0", NRpart.count));
                int lastCurNumber = ContractPatternDao.getLastContractWithPattern(result, NRpart.count, this.con);
                result = result.replaceAll(NRpart.getFullString(), df.format(lastCurNumber));
            }
        }
        catch (Exception ex) {
            if (ex instanceof BGMessageException) {
                throw new BGMessageException(ex.getMessage());
            }
            this.logError(ex);
        }
        if (Utils.notBlankString(result)) {
            lastTitles.add(new ContractCreateInfo(result));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isContractTitleDuplicated(String title, boolean add, int notVerifyContractId) {
        if (title == null) {
            return false;
        }
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            if (!contractDao.checkContractTitleOnDublication(title, notVerifyContractId)) {
                boolean bl = true;
                return bl;
            }
            for (ContractCreateInfo createData : lastTitles) {
                if (!createData.title.equals(title)) continue;
                Contract contract = (Contract)contractDao.get(notVerifyContractId);
                if (notVerifyContractId > 0 && (contract == null || contract.getTitle().equals(title))) break;
                boolean bl = true;
                return bl;
            }
        }
        catch (BGException ex) {
            this.logError(ex);
        }
        if (!add) return false;
        lastTitles.add(new ContractCreateInfo(title));
        return false;
    }

    public static synchronized void removeContractTitleFromLastTitles(int contractId, Connection con) {
        ContractPatternDao.removeContractTitleFromLastTitles(new ContractUtils(con).getContractTitle(contractId, false));
    }

    public static synchronized void removeContractTitleFromLastTitles(String title) {
        if (title == null) {
            return;
        }
        for (ContractCreateInfo createData : lastTitles) {
            if (!createData.title.equals(title)) continue;
            lastTitles.remove(createData);
            return;
        }
    }

    public static synchronized void removeLastTitles() {
        lastTitles.clear();
    }

    public Map<Integer, Document> getListPatternData() throws Exception {
        HashMap<Integer, Document> map = new HashMap<Integer, Document>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT id, data FROM contract_pattern");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                byte[] data = rs.getBytes("data");
                if (data == null || data.length <= 0) continue;
                map.put(rs.getInt("id"), XMLUtils.parseDocument(data));
            }
        }
        return map;
    }

    public List<IdTitle> getPatternTitleList() throws SQLException {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        String query = "SELECT id, title FROM contract_pattern ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                list.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
        }
        return list;
    }

    public void setDataPattern(int idPattern, Document data) throws Exception {
        String query = "UPDATE contract_pattern SET data=? WHERE id=" + idPattern;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            XMLUtils.serialize((Node)data, bos, "UTF-8");
            ps.setBytes(1, bos.toByteArray());
            ps.executeUpdate();
        }
    }

    public Map<Integer, Integer> getPatternParameterGroupCountMap() throws SQLException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String query = "SELECT pgid, COUNT(*) FROM contract_pattern GROUP BY pgid";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                map.put(rs.getInt(1), rs.getInt(2));
            }
        }
        return map;
    }

    public List<ContractPatternInfo> getContractPatternList(Set<Integer> domainIds) throws SQLException {
        ArrayList<ContractPatternInfo> patterns = new ArrayList<ContractPatternInfo>();
        List<BGGenerator> generators = new BGGeneratorDao(this.con).list(BGGeneratorType.CONTRACT);
        Map<Integer, ContractPattern> map = cache;
        for (ContractPattern pattern : map.values()) {
            int domainId;
            if (pattern.isHidden() || (domainId = pattern.getDomainId()) > 0 && Utils.notEmptyCollection(domainIds) && !domainIds.contains(domainId)) continue;
            ArrayList<String> masterStep = null;
            if ("master".equals(pattern.getPatternMode())) {
                masterStep = new ArrayList<String>();
                masterStep.add("START");
                masterStep.add("PARAM");
                if ("selectTariffFromGroup".equals(pattern.getMasterTariffMode()) || "selectTariffFromList".equals(pattern.getMasterTariffMode())) {
                    masterStep.add("TARIFF");
                }
                masterStep.add("CREATE");
            }
            patterns.add(ContractPatternInfo.builder().setId(pattern.getId()).setTitle(pattern.getTitle()).setPatternMode(pattern.getPatternMode()).setMasterStep(masterStep).setTitlePattern(generators.stream().filter(a -> a.getId() == pattern.getNamePatternId()).findFirst().map(a -> a.getPattern()).orElse("")).build());
        }
        patterns.sort(Comparator.comparing(IdTitle::getTitle));
        return patterns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getLastContractWithPattern(String currentTitle, int numsCount, Connection con) throws SQLException {
        int result = 0;
        Pattern nrPattern = Pattern.compile("([\\S\\s]*)\\$\\{NR" + numsCount + "\\}([\\S\\s]*)");
        String partone = null;
        String parttwo = null;
        Matcher m = nrPattern.matcher(currentTitle);
        if (m.find()) {
            partone = m.group(1);
            parttwo = m.group(2);
        }
        if (Utils.isBlankString(partone) && Utils.isBlankString(parttwo)) {
            return result;
        }
        Pattern takeNumPat = Pattern.compile(partone + "(\\d{" + numsCount + "})" + parttwo);
        String query = "SELECT title FROM contract WHERE title LIKE ?";
        try (PreparedStatement ps = con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, partone + "%" + parttwo);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    try {
                        int number;
                        Matcher takeNum = takeNumPat.matcher(rs.getString(1));
                        if (!takeNum.find() || (number = Utils.parseInt(takeNum.group(1))) <= result) continue;
                        result = number;
                    }
                    catch (Exception exception) {}
                }
                return result + 1;
            }
        }
    }

    public List<ContractParameterData> contractParameterDataList(int contractPatternId) throws Exception {
        ArrayList<ContractParameterData> list = new ArrayList<ContractParameterData>();
        ContractPattern contractPattern = cache.get(contractPatternId);
        if (contractPattern != null) {
            ServerContext context = (ServerContext)ServerContext.get();
            for (ContractParameterGroupAttr attr : context.getService(ContractParameterService.class, 0).contractParameterGroupAttrList()) {
                ContractParameterData data = new ContractParameterData();
                if (contractPattern.getMasterRequiredParameterIds().contains(attr.getId())) {
                    data.setRequired(true);
                } else if (!contractPattern.getMasterOptionalParameterIds().contains(attr.getId())) continue;
                data.setId(attr.getId());
                data.setTitle(attr.getTitle());
                data.setType((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)attr.getType()).get());
                list.add(data);
            }
        }
        return list;
    }

    private PatternData parsePatternData(byte[] bytes) throws Exception {
        Element general;
        PatternData patternData = new PatternData();
        patternData.doc = bytes != null && bytes.length > 0 ? XMLUtils.parseDocument(bytes) : XMLUtils.newDocument();
        patternData.patternMode = "basic";
        if (patternData.doc != null && (general = XMLUtils.selectElement(patternData.doc, "//data/general")) != null) {
            patternData.patternMode = XMLUtils.getAttribute(general, "patternMode", "basic");
            patternData.masterHandlerClass = XMLUtils.getAttribute(general, "masterHandlerClass", "");
            patternData.masterRequiredParameterIds = Utils.toIntegerSet(XMLUtils.getAttribute(general, "masterRequiredParameterIds", ""));
            patternData.masterOptionalParameterIds = Utils.toIntegerSet(XMLUtils.getAttribute(general, "masterOptionalParameterIds", ""));
        }
        return patternData;
    }

    private void reloadCache() {
        HashMap<Integer, ContractPattern> map = new HashMap<Integer, ContractPattern>();
        String query = "SELECT * FROM contract_pattern";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                ContractPattern result = new ContractPattern();
                this.loadContractPattern(result, rs);
                map.put(result.getId(), result);
            }
            cache = map;
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    @Override
    protected ContractPattern getFromRS(ResultSet rs) throws SQLException {
        return null;
    }

    @Override
    protected void updateImpl(ContractPattern b) throws SQLException {
    }

    private static /* synthetic */ boolean lambda$getContractTitle$2(String reg, ContractCreateInfo s) {
        return s.title != null ? s.title.matches(reg) : false;
    }

    class PatternData {
        Document doc;
        String patternMode;
        String masterHandlerClass;
        Set<Integer> masterRequiredParameterIds;
        Set<Integer> masterOptionalParameterIds;

        PatternData() {
        }
    }

    private static class PatternPart
    implements Comparable<PatternPart> {
        public String letter;
        public String format;
        public int count;
        public ContractPatternNamedNumber namedNumber;

        public PatternPart(String letter, int count, String format, ContractPatternNamedNumber namedNumber) {
            this.letter = letter;
            this.count = count;
            this.format = format;
            this.namedNumber = namedNumber;
        }

        public String getFullString() {
            StringBuffer result = new StringBuffer(10);
            result.append("\\$\\{");
            result.append(this.letter);
            if (this.namedNumber != null) {
                result.append(this.namedNumber.getTitle());
            } else {
                if (this.format != null) {
                    result.append(":").append(this.format);
                }
                if (this.count != 0) {
                    result.append(this.count);
                }
            }
            result.append("\\}");
            return result.toString();
        }

        @Override
        public int compareTo(PatternPart o) {
            if (this.namedNumber != null && o.namedNumber != null) {
                return 0;
            }
            if (this.namedNumber != null && o.namedNumber == null) {
                return 1;
            }
            return -1;
        }
    }
}

