/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.directory;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.common.model.IdTitle;

public class DirectoriesManager {
    private Hashtable<String, Directory> directories = new Hashtable();
    private ModuleTariffConfig moduleTariffConfig;
    private int moduleId;

    public DirectoriesManager(ModuleTariffConfig mtc, int moduleId) {
        this.moduleTariffConfig = mtc;
        this.moduleId = moduleId;
        this.initDirs(moduleId);
    }

    private void initDirs(int moduleId) {
        Vector<Directory> dirs = this.moduleTariffConfig.getDirectories();
        for (int i = 0; i < dirs.size(); ++i) {
            try {
                Directory dir = dirs.get(i);
                this.directories.put(dir.getName(), new LazyDirectory(moduleId, dir));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Directory getDirectory(String name) {
        return this.directories.get(name);
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public static class LazyDirectory
    implements Directory {
        private final int moduleId;
        private Directory directory;
        private boolean inited;

        public LazyDirectory(int moduleId, Directory directory) {
            this.moduleId = moduleId;
            this.directory = directory;
            this.inited = false;
        }

        public Directory getDirectory() throws Exception {
            this.init(this.moduleId);
            return this.directory;
        }

        @Override
        public void init(int moduleId) throws Exception {
            if (!this.inited) {
                this.inited = true;
                this.directory.init(moduleId);
            }
        }

        @Override
        public String getValue(int code) throws Exception {
            return this.getDirectory().getValue(code);
        }

        @Override
        public int addValue(String value) throws Exception {
            return this.getDirectory().addValue(value);
        }

        @Override
        public void removeValue(int code) throws Exception {
            this.getDirectory().removeValue(code);
        }

        @Override
        public void renameValue(int code, String newName) throws Exception {
            this.getDirectory().renameValue(code, newName);
        }

        @Override
        public List<IdTitle> getItems() throws Exception {
            return this.getDirectory().getItems();
        }

        @Override
        public void setName(String value) throws Exception {
            this.getDirectory().setName(value);
        }

        @Override
        public String getName() throws Exception {
            return this.getDirectory().getName();
        }

        @Override
        public int getCode(String value) throws Exception {
            return this.getDirectory().getCode(value);
        }
    }
}

