/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.netflow.nat;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.NatLogExportParameters;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.kernel.network.flow.Netflow9Processor;
import ru.bitel.common.inet.IpAddress;

abstract class SeNatLogProcessor
implements Netflow9Processor {
    final long timeFromMillis;
    final long timeToMillis;
    final byte[] extAddress;
    final int[] extPorts;

    public SeNatLogProcessor(long timeFromMillis, long timeToMillis, byte[] extAddress, Set<Integer> extPorts) {
        this.timeFromMillis = timeFromMillis;
        this.timeToMillis = timeToMillis;
        this.extAddress = extAddress;
        if (extPorts == null || extPorts.size() == 0) {
            this.extPorts = null;
        } else {
            this.extPorts = new int[extPorts.size()];
            int pos = 0;
            for (Integer port : extPorts) {
                this.extPorts[pos++] = port;
            }
        }
    }

    @Override
    public void process(ByteBuffer readBuffer, int offset, long millis, NetFlow9Template template) throws Exception {
        if (!template.seNatLog) {
            return;
        }
        readBuffer.position(offset);
        int assignSec = 0;
        int unassignSec = 0;
        byte[] intAddr = null;
        byte[] extAddr = null;
        int extPortFirst = 0;
        int extPortLast = 0;
        if (template.natLogFieldIdxContextId.init) {
            readBuffer.position(offset + template.natLogFieldIdxContextId.offset);
            readBuffer.getInt();
        }
        if (template.natLogFieldIdxAssignTsSec.init) {
            readBuffer.position(offset + template.natLogFieldIdxAssignTsSec.offset);
            assignSec = readBuffer.getInt();
        }
        if (template.natLogFieldIdxUnassignTsSec.init) {
            readBuffer.position(offset + template.natLogFieldIdxUnassignTsSec.offset);
            unassignSec = readBuffer.getInt();
        }
        if (template.natLogFieldIdxIpv4IntAddr.init) {
            readBuffer.position(offset + template.natLogFieldIdxIpv4IntAddr.offset);
            intAddr = new byte[template.natLogFieldIdxIpv4IntAddr.length];
            readBuffer.get(intAddr);
        }
        if (template.natLogFieldIdxIpv4ExtAddr.init) {
            readBuffer.position(offset + template.natLogFieldIdxIpv4ExtAddr.offset);
            extAddr = new byte[template.natLogFieldIdxIpv4ExtAddr.length];
            readBuffer.get(extAddr);
        }
        if (template.natLogFieldIdxExtPortFirst.init) {
            readBuffer.position(offset + template.natLogFieldIdxExtPortFirst.offset);
            extPortFirst = readBuffer.getShort() & 0xFFFF;
        }
        if (template.natLogFieldIdxExtPortLast.init) {
            readBuffer.position(offset + template.natLogFieldIdxExtPortLast.offset);
            extPortLast = readBuffer.getShort() & 0xFFFF;
        }
        this.process(millis, (long)assignSec * 1000L, (long)unassignSec * 1000L + 999L, intAddr, extAddr, extPortFirst, extPortLast);
    }

    protected void process(long millis, long assingMillis, long unassignMillis, byte[] intAddress, byte[] extAddress, int extPortFirst, int extPortLast) throws Exception {
        if (this.timeFromMillis != 0L && this.timeFromMillis > unassignMillis || this.timeToMillis != 0L && this.timeToMillis < assingMillis) {
            return;
        }
        if (this.extAddress != null && !IpAddress.equals(this.extAddress, extAddress)) {
            return;
        }
        if (this.extPorts != null) {
            boolean find = false;
            for (int port : this.extPorts) {
                if (extPortFirst > port || extPortLast < port) continue;
                find = true;
                break;
            }
            if (!find) {
                return;
            }
        }
        this.processFilter(millis, assingMillis, unassignMillis, intAddress, extAddress, extPortFirst, extPortLast);
    }

    protected abstract void processFilter(long var1, long var3, long var5, byte[] var7, byte[] var8, int var9, int var10) throws IOException;

    public static class ExportSENatLogProcessor
    extends SeNatLogProcessor {
        final Date utilDate = new Date();
        final Writer writer;
        final DateFormat format;

        public ExportSENatLogProcessor(NatLogExportParameters exportParameters, Writer writer, DateFormat format) throws IOException {
            super(exportParameters.timeFromMillis, exportParameters.timeToMillis, exportParameters.address, exportParameters.ports);
            this.writer = writer;
            this.format = format;
            writer.write("Record time");
            writer.write(9);
            writer.write("Assign time");
            writer.write(9);
            writer.write("Unassign time");
            writer.write(9);
            writer.write("Int. address");
            writer.write(9);
            writer.write("Ext. address");
            writer.write(9);
            writer.write("Ext. port first");
            writer.write(9);
            writer.write("Ext. port last");
            writer.write(10);
        }

        @Override
        protected void processFilter(long millis, long assingMillis, long unassignMillis, byte[] intAddress, byte[] extAddress, int extPortFirst, int extPortLast) throws IOException {
            if (this.format != null) {
                this.utilDate.setTime(millis);
                this.writer.write(this.format.format(this.utilDate));
                this.writer.write(9);
                this.utilDate.setTime(assingMillis);
                this.writer.write(this.format.format(this.utilDate));
                this.writer.write(9);
                this.utilDate.setTime(unassignMillis);
                this.writer.write(this.format.format(this.utilDate));
            } else {
                this.writer.write(String.valueOf(millis));
                this.writer.write(9);
                this.writer.write(String.valueOf(assingMillis));
                this.writer.write(9);
                this.writer.write(String.valueOf(unassignMillis));
            }
            this.writer.write(9);
            this.writer.write(IpAddress.toString(intAddress));
            this.writer.write(9);
            this.writer.write(IpAddress.toString(extAddress));
            this.writer.write(9);
            this.writer.write(String.valueOf(extPortFirst));
            this.writer.write(9);
            this.writer.write(String.valueOf(extPortLast));
            this.writer.write(10);
        }
    }
}

