/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.common.dao;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.persistence.Column;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public abstract class AbstractDao<B>
extends AbstarctDaoConstant {
    protected static final Pattern orderByPattern = Pattern.compile("\\A[\\w\\s\\d,_\\-\\.]+\\z");
    protected final Connection con;
    protected final int moduleId;
    protected final String tableName;

    public AbstractDao(Connection con, int moduleId, String tableName) {
        this(con, moduleId, tableName, null);
    }

    public AbstractDao(Connection con, int moduleId, String tableName, Date date) {
        this.con = con;
        this.moduleId = moduleId;
        this.tableName = this.getTableName(tableName, moduleId, date);
    }

    protected String getTableName(String tableName, int moduleId, Date date) {
        if (moduleId > 0) {
            if (date != null) {
                return ServerUtils.getModuleMonthTableName((String)tableName, (Date)date, (int)moduleId);
            }
            return tableName + "_" + moduleId;
        }
        if (date != null) {
            return ServerUtils.getMonthTableName((String)tableName, (Date)date);
        }
        return tableName;
    }

    protected abstract B getFromRS(ResultSet var1) throws SQLException;

    protected PreparedStatement listImplPS(String what, String filter, String orderBy, int pageIndex, int pageSize) throws SQLException {
        return this.listImplPS(what, null, filter, orderBy, new Page(pageIndex, pageSize));
    }

    protected PreparedStatement listImplPS(String what, String join, String filter, String orderBy, Page page) throws SQLException {
        StringBuilder sb = new StringBuilder().append("SELECT ");
        sb.append(what).append(" FROM ").append(this.tableName);
        if (join != null && join.length() > 0) {
            sb.append(" ").append(join);
        }
        if (filter != null && filter.length() > 0) {
            sb.append(" WHERE ").append(filter);
        }
        if (orderBy != null && orderBy.length() > 0) {
            sb.append(" ORDER BY ").append(orderBy);
        }
        if (page != null) {
            sb.append(page.sqlLimit());
        }
        return this.con.prepareStatement(sb.toString());
    }

    protected List<B> getListFromRS(ResultSet rs) throws SQLException {
        ArrayList<B> result = new ArrayList<B>();
        while (rs.next()) {
            result.add(this.getFromRS(rs));
        }
        return result;
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected List<B> listImpl(Page page, String what, String join, String filter, String orderBy, Object ... params) throws SQLException {
        ArrayList<B> result = new ArrayList<B>();
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            this.getLogger().error("Table \"{}\" not found!", (Object)this.tableName);
            return result;
        }
        try (PreparedStatement ps = this.listImplPS(what, join, filter, orderBy, page);){
            int idx = 0;
            for (int i = 0; i < params.length; ++i) {
                this.setStatementParam(ps, ++idx, params[i]);
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("ps = {}", (Object)ps);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (what.contains("SQL_CALC_FOUND_ROWS")) {
                    page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
                }
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        return result;
    }

    protected void setStatementParam(PreparedStatement ps, int idx, Object param) throws SQLException {
        if (param instanceof Calendar) {
            this.logError("param #" + idx + " has type Calendar", new BGException());
            param = ((Calendar)param).getTime();
        }
        ps.setObject(idx, param);
    }

    protected List<B> listImpl(Page page, String filter, String orderBy, Object ... params) throws SQLException {
        return this.listImpl(page, "*", null, filter, orderBy, params);
    }

    protected List<B> list(String filter, String orderBy, Object ... params) throws SQLException {
        return this.listImpl(new Page(), filter, orderBy, params);
    }

    protected Result<B> list(Page page, String filter, String orderBy, Object ... params) throws SQLException {
        List<B> result = this.listImpl(page, "SQL_CALC_FOUND_ROWS *", null, filter, orderBy, params);
        return new Result<B>(result, page);
    }

    protected B get(String filter, Object ... params) throws SQLException {
        B result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE " + filter;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                this.setStatementParam(ps, i + 1, params[i]);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        return result;
    }

    protected int delete(String filter, Object ... params) throws SQLException {
        int result = 0;
        String query = "DELETE FROM " + this.tableName + " WHERE " + filter;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                this.setStatementParam(ps, i + 1, params[i]);
            }
            result = ps.executeUpdate();
        }
        return result;
    }

    protected B getImpl(int id) throws SQLException {
        return this.getById(id);
    }

    protected String getQueryById() {
        return "SELECT * FROM " + this.tableName + " WHERE id=?";
    }

    protected B getById(int id) throws SQLException {
        B result = null;
        try (PreparedStatement ps = this.con.prepareStatement(this.getQueryById());){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        return result;
    }

    protected int deleteImpl(int id) throws SQLException {
        return this.delete("id=?", id);
    }

    protected abstract void updateImpl(B var1) throws SQLException;

    public void update(B b) throws SQLException {
        this.updateImpl(b);
    }

    public String getSQLOrder(List<String> sortFields, String[] fieldNames) {
        StringBuilder order = new StringBuilder();
        if (sortFields != null) {
            block0: for (String field : sortFields) {
                String[] data = field.split(":");
                if (data.length != 2) continue;
                for (String fieldName : fieldNames) {
                    if (!fieldName.equals(data[0])) continue;
                    if (order.length() > 0) {
                        order.append(", ");
                    }
                    order.append(fieldName).append("0".equals(data[1]) ? "" : " DESC");
                    continue block0;
                }
            }
        }
        return order.length() > 0 ? " ORDER BY ".concat(order.toString()) : "";
    }

    protected Period getPeriod(ResultSet rs) throws SQLException {
        return new Period(rs.getDate("date_from"), rs.getDate("date_to"));
    }

    protected String queryPeriod(Period period, @Nonnull String fieldName) {
        Objects.requireNonNull(fieldName);
        return Optional.ofNullable(period).map(a -> Optional.ofNullable(a.getLocalDateFrom()).map(d -> " AND " + fieldName + ">=?").orElse("") + Optional.ofNullable(a.getLocalDateTo()).map(d -> " AND " + fieldName + "<?").orElse("")).orElse("");
    }

    protected int psSetPeriod(@Nonnull PreparedStatement ps, int index, Period period) throws SQLException {
        Objects.requireNonNull(ps);
        if (period == null) {
            return index;
        }
        int newIndex = index;
        LocalDate from = period.getLocalDateFrom();
        if (from != null) {
            ps.setDate(newIndex++, TimeUtils.convertLocalDateToSqlDate(from));
        }
        LocalDate to = period.getLocalDateFrom();
        if (from != null) {
            ps.setDate(newIndex++, TimeUtils.convertLocalDateToSqlDate(to));
        }
        return newIndex;
    }

    protected <T> T ormFromResultSet(ResultSet rs, Class<T> clazz) throws SQLException {
        try {
            T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<T> currentClass = clazz;
            while (!currentClass.equals(Object.class)) {
                block7: for (Method method : currentClass.getMethods()) {
                    if (method.getName().equals("setPeriod")) {
                        method.invoke(t, this.getPeriod(rs));
                        continue;
                    }
                    if (!method.getName().startsWith("set")) continue;
                    for (Annotation annotation : method.getAnnotations()) {
                        Method getMethod2;
                        String columnName;
                        if (!annotation.annotationType().equals(Column.class)) continue;
                        Column column = (Column)annotation;
                        String string = columnName = column.name().isEmpty() ? null : column.name();
                        if (columnName == null || method.getParameterCount() != 1) continue block7;
                        if (method.getParameterTypes()[0].equals(Integer.TYPE)) {
                            method.invoke(t, rs.getInt(columnName));
                            continue block7;
                        }
                        if (method.getParameterTypes()[0].equals(Long.TYPE)) {
                            method.invoke(t, rs.getLong(columnName));
                            continue block7;
                        }
                        if (method.getParameterTypes()[0].equals(String.class)) {
                            method.invoke(t, rs.getString(columnName));
                            continue block7;
                        }
                        if (method.getParameterTypes()[0].equals(Boolean.TYPE)) {
                            method.invoke(t, rs.getBoolean(columnName));
                            continue block7;
                        }
                        if (method.getParameterTypes()[0].equals(LocalDateTime.class)) {
                            method.invoke(t, TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp(columnName)));
                            continue block7;
                        }
                        if (method.getParameterTypes()[0].equals(Date.class)) {
                            method.invoke(t, TimeUtils.convertTimestampToDate(rs.getTimestamp(columnName)));
                            continue block7;
                        }
                        if (method.getParameterTypes()[0].equals(Calendar.class)) {
                            method.invoke(t, TimeUtils.convertSqlDateToCalendar(rs.getDate(columnName)));
                            continue block7;
                        }
                        if (!method.getParameterTypes()[0].isEnum()) continue block7;
                        Class<?> enumClass = method.getParameterTypes()[0];
                        boolean find = false;
                        try {
                            getMethod2 = enumClass.getDeclaredMethod("get" + enumClass.getSimpleName() + "ByCode", Integer.TYPE);
                            method.invoke(t, getMethod2.invoke(null, rs.getInt(columnName)));
                            find = true;
                        }
                        catch (Exception getMethod2) {
                            // empty catch block
                        }
                        if (find) continue block7;
                        try {
                            getMethod2 = enumClass.getDeclaredMethod("get" + enumClass.getSimpleName() + "ByCode", String.class);
                            method.invoke(t, getMethod2.invoke(null, rs.getString(columnName)));
                            find = true;
                        }
                        catch (Exception exception) {}
                        continue block7;
                    }
                }
                currentClass = currentClass.getSuperclass();
            }
            return t;
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    protected void ormUpdateImpl(Object bean) throws SQLException {
        try {
            this.ormUpdateImpl(bean, null, null, null, null);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    protected void ormUpdateImpl(Object bean, String extraQuerySet) throws SQLException {
        this.ormUpdateImpl(bean, extraQuerySet, null);
    }

    protected void ormUpdateImpl(Object bean, String extraQuerySet, String extraQueryWhere) throws SQLException {
        try {
            this.ormUpdateImpl(bean, extraQuerySet, extraQueryWhere, null, null);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    protected void ormUpdateImpl(Object bean, String extraQuerySet, String extraQueryWhere, Object[] extraSetParams, Object[] extraWhereParams) throws SQLException {
        Objects.requireNonNull(bean, this.getClass().getName() + " update bean must not be null");
        try {
            Class<?> clazz = bean.getClass();
            Method getIdMethod = clazz.getMethod("getId", new Class[0]);
            boolean insert = (Integer)getIdMethod.invoke(bean, new Object[0]) < 1;
            StringBuilder query = new StringBuilder((insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET ");
            StringBuilder setQuery = new StringBuilder(extraQuerySet == null ? "" : extraQuerySet);
            block9: for (Method method : clazz.getMethods()) {
                if (method.getName().equals("getPeriod")) {
                    if (setQuery.length() > 0) {
                        setQuery.append(", ");
                    }
                    setQuery.append("date_from=?, date_to=?");
                    continue;
                }
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                for (Annotation annotation : method.getAnnotations()) {
                    String columnName;
                    if (!annotation.annotationType().equals(Column.class)) continue;
                    Column column = (Column)annotation;
                    String string = columnName = column.name().isEmpty() ? null : column.name();
                    if (setQuery.length() > 0) {
                        setQuery.append(", ");
                    }
                    setQuery.append("`" + columnName + "`").append("=?");
                    continue block9;
                }
            }
            query.append((CharSequence)setQuery);
            if (!insert) {
                if (Utils.notBlankString(extraQueryWhere)) {
                    query.append(" WHERE ").append(extraQueryWhere);
                } else {
                    query.append(" WHERE id=?");
                }
            }
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                int index = 1;
                block11: for (Method method : clazz.getMethods()) {
                    if (method.getName().equals("getPeriod")) {
                        Period period = (Period)method.invoke(bean, new Object[0]);
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateFrom()));
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateTo()));
                        continue;
                    }
                    if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                    for (Annotation annotation : method.getAnnotations()) {
                        if (!annotation.annotationType().equals(Column.class)) continue;
                        Class<?> returnClass = method.getReturnType();
                        if (returnClass.equals(Integer.TYPE)) {
                            ps.setInt(index++, (Integer)method.invoke(bean, new Object[0]));
                            continue block11;
                        }
                        if (returnClass.equals(Long.TYPE)) {
                            ps.setLong(index++, (Long)method.invoke(bean, new Object[0]));
                            continue block11;
                        }
                        if (returnClass.equals(Boolean.TYPE)) {
                            ps.setBoolean(index++, (Boolean)method.invoke(bean, new Object[0]));
                            continue block11;
                        }
                        if (returnClass.equals(String.class)) {
                            ps.setString(index++, Utils.maskNull((String)method.invoke(bean, new Object[0])));
                            continue block11;
                        }
                        if (returnClass.equals(Date.class)) {
                            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)method.invoke(bean, new Object[0])));
                            continue block11;
                        }
                        if (returnClass.equals(Calendar.class)) {
                            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)method.invoke(bean, new Object[0])));
                            continue block11;
                        }
                        if (!returnClass.isEnum()) continue block11;
                        try {
                            Method getCode = returnClass.getMethod("getCode", new Class[0]);
                            if (getCode == null) continue block11;
                            if (getCode.getReturnType().equals(String.class)) {
                                ps.setString(index++, (String)getCode.invoke(method.invoke(bean, new Object[0]), new Object[0]));
                                continue block11;
                            }
                            if (!getCode.getReturnType().equals(Integer.TYPE)) continue block11;
                            ps.setInt(index++, (Integer)getCode.invoke(method.invoke(bean, new Object[0]), new Object[0]));
                        }
                        catch (Exception ex) {
                            this.logError(ex);
                        }
                        continue block11;
                    }
                }
                if (!insert) {
                    ps.setInt(index++, (Integer)getIdMethod.invoke(bean, new Object[0]));
                }
                ps.executeUpdate();
                if (insert) {
                    Method setIdMethod = clazz.getMethod("setId", Integer.TYPE);
                    setIdMethod.invoke(bean, ServerUtils.lastInsertId((PreparedStatement)ps));
                }
            }
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }
}

