/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.call.LimitData;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class TableLimit
extends BGTable {
    public TableLimit() {
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.setModel(this.tableModel);
        this.getSelectionModel().setSelectionMode(0);
        this.tableModel.setColumnCount(5);
        this.setColumnProperties(0, "ID", 0, 0, 0);
        this.setColumnProperties(1, "\u0422\u0438\u043f", 30, 30, 30);
        this.setColumnProperties(2, "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435", 150, 150, 200);
        this.setColumnProperties(3, "\u041f\u0435\u0440\u0438\u043e\u0434", 150, 150, 150);
        this.setColumnProperties(4, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1);
    }

    public void setRowData(Node nodeRows) {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
        if (nodeRows == null || !nodeRows.hasChildNodes()) {
            return;
        }
        for (Element item : XMLUtils.elements(nodeRows.getChildNodes())) {
            String typeString = XMLUtils.getAttribute(item, "type", null);
            if (typeString == null) continue;
            LimitData limitData = new LimitData();
            limitData.setType(Utils.parseInt(typeString, -1));
            limitData.setParam1(XMLUtils.getAttribute(item, "param1", "0"));
            limitData.setParam2(XMLUtils.getAttribute(item, "param2", "0"));
            limitData.setDate1(XMLUtils.getAttribute(item, "date1", ""));
            limitData.setDate2(XMLUtils.getAttribute(item, "date2", ""));
            limitData.setServices(XMLUtils.getAttribute(item, "sid", ""));
            limitData.setComment(XMLUtils.getAttribute(item, "comment", ""));
            NodeList list1 = item.getElementsByTagName("item");
            StringBuffer buf = new StringBuffer();
            int j = 0;
            for (Element condition : XMLUtils.elements(list1)) {
                int[] values = new int[4];
                try {
                    values[0] = "".equals(condition.getAttribute("hh")) ? 0 : Integer.parseInt(condition.getAttribute("hh"));
                    values[1] = "".equals(condition.getAttribute("dw")) ? 0 : Integer.parseInt(condition.getAttribute("dw"));
                    values[2] = "".equals(condition.getAttribute("dm")) ? 0 : Integer.parseInt(condition.getAttribute("dm"));
                    values[3] = "".equals(condition.getAttribute("mm")) ? 0 : Integer.parseInt(condition.getAttribute("mm"));
                    buf = buf.append(values[0]);
                    buf = buf.append("_");
                    buf = buf.append(values[1]);
                    buf = buf.append("_");
                    buf = buf.append(values[2]);
                    buf = buf.append("_");
                    buf = buf.append(values[3]);
                    if (j < list1.getLength() - 1) {
                        buf.append('-');
                    }
                    limitData.setTimeCondition(buf.toString());
                    ++j;
                }
                catch (Exception exception) {}
            }
            this.addRow(limitData);
        }
    }

    private Vector<Object> buildRow(LimitData limitData) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(limitData);
        rowData.addElement(String.valueOf(limitData.getType()));
        StringBuffer buf = new StringBuffer();
        if (limitData.getType() == 1 || limitData.getType() == 2 || limitData.getType() == 5) {
            buf.append(limitData.getParam1().equals("0") ? "allow" : "deny");
        } else if (limitData.getType() == 4) {
            float money = Float.parseFloat(limitData.getParam1()) / 100.0f;
            buf.append(Float.toString(money));
        } else {
            buf.append(limitData.getParam1());
        }
        buf.append(" ");
        if (limitData.getType() == 2) {
            buf.append("0".equals(limitData.getParam2()) ? "\u0432\u0445\u043e\u0434" : "\u0440\u0430\u0431\u043e\u0442\u0430");
        } else if (limitData.getType() == 3 || limitData.getType() == 4) {
            buf.append("0".equals(limitData.getParam2()) ? "\u0437\u0430 \u043c\u0435\u0441\u044f\u0446" : "\u0437\u0430 \u0434\u0435\u043d\u044c");
        } else {
            buf.append(limitData.getParam2());
        }
        rowData.addElement(buf.toString());
        rowData.addElement(limitData.getDate1() + " - " + limitData.getDate2());
        rowData.addElement(limitData.getComment());
        return rowData;
    }

    public void addRow(LimitData limitData) {
        this.tableModel.addRow(this.buildRow(limitData));
    }

    public void updateRow(int row, LimitData limitData) {
        Vector<Object> rowData = this.buildRow(limitData);
        this.tableModel.insertRow(row, rowData);
        this.tableModel.removeRow(row + 1);
    }

    public void moveRow(int direct) {
        int row = this.getSelectedRow();
        if (row == -1) {
            return;
        }
        if (direct == 0 && row != 0) {
            this.tableModel.removeRow(row - 1);
            this.tableModel.insertRow(row, this.tableModel.getDataVector().get(row - 1));
            --row;
        }
        if (direct == 1 && row != this.tableModel.getRowCount() - 1) {
            this.tableModel.removeRow(row + 1);
            this.tableModel.insertRow(row, this.tableModel.getDataVector().get(row + 1));
            ++row;
        }
    }

    public DefaultTableModel getDefaultModel() {
        return this.tableModel;
    }
}

