/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import bitel.billing.server.ActionBase;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTaskManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIface;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIfaceManager;
import ru.bitel.common.TimeUtils;

public class ActionCreateDetailMonth
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int addressId = this.getIntParameter("address_id", -1);
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        if (date1 == null || date2 == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434");
        }
        String file = this.getParameter("file");
        if (addressId <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        AddressRangeManager manager = new AddressRangeManager(this.con, this.mid);
        AddressRange range = manager.getAddressRange(addressId);
        if (range == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        if (range.getDate1() != null && TimeUtils.dateBefore((Calendar)date2, (Calendar)range.getDate1()) || range.getDate2() != null && TimeUtils.dateBefore((Calendar)range.getDate2(), (Calendar)date1)) {
            throw new BGMessageException("\u0412 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0430\u0434\u0440\u0435\u0441\u0430 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0430\u043b\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
        }
        if (range.getDate1() != null && TimeUtils.dateBefore((Calendar)date1, (Calendar)range.getDate1())) {
            date1 = range.getDate1();
        }
        if (range.getDate2() != null && TimeUtils.dateBefore((Calendar)range.getDate2(), (Calendar)date2)) {
            date2 = range.getDate2();
        }
        HashMap<Integer, HashSet<Integer>> sourceIfaces = new HashMap<Integer, HashSet<Integer>>();
        for (RangeIface rangeIface : new RangeIfaceManager(this.con, this.mid).getAdressRangeIfaces(addressId)) {
            HashSet<Integer> ifaceSet = (HashSet<Integer>)sourceIfaces.get(rangeIface.getSourceId());
            if (ifaceSet == null) {
                ifaceSet = new HashSet<Integer>();
                sourceIfaces.put(rangeIface.getSourceId(), ifaceSet);
            }
            ifaceSet.add(rangeIface.getIfaceId());
        }
        DetailCreateTaskManager taskManager = new DetailCreateTaskManager(this.con, this.mid);
        int count = sourceIfaces.entrySet().size();
        for (Map.Entry me : sourceIfaces.entrySet()) {
            int sourceId = (Integer)me.getKey();
            Set ifaces = (Set)me.getValue();
            DetailCreateTask task = new DetailCreateTask();
            task.setModule(2);
            task.setSourceId(sourceId);
            task.setMonthPeriod(true);
            task.setCount(count);
            task.setFileName(file);
            task.setIpnFromAddr(range.getAddr1());
            task.setIpnToAddr(range.getAddr2());
            task.setIpnIfaceSet(ifaces);
            task.setSessionStart(date1);
            task.setSessionEnd(date2);
            taskManager.addTask(task);
        }
    }
}

