/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.common.ParameterMap;

public class DhcpNetOptions {
    private static final Logger log = LogManager.getLogger();
    private List<NetOptions> netOptions = new ArrayList<NetOptions>();

    public DhcpNetOptions(ParameterMap pref, String prefix) {
        ParameterMap conf = pref.sub(prefix);
        for (Map.Entry me : conf.entrySet()) {
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            int pos = key.lastIndexOf(46);
            if (pos <= 0) {
                log.error("Incorrect net param key: " + key);
                continue;
            }
            String net = key.substring(0, pos);
            String optionName = key.substring(pos + 1);
            String[] addr_mask = net.split(":");
            if (addr_mask.length != 2) {
                log.error("Incorrect net params: " + (String)me.getValue());
                continue;
            }
            long netAddr = IPUtils.convertStringIPtoLong((String)addr_mask[0]);
            long netMask = IPUtils.convertStringIPtoLong((String)addr_mask[1]);
            DhcpOption option = DhcpOption.parseOption((String)optionName, (String)value);
            if (option == null) continue;
            NetOptions options = this.getNetParams(netAddr);
            if (options == null) {
                options = new NetOptions(netAddr, netMask);
                this.netOptions.add(options);
            }
            options.optionList.add(option);
        }
    }

    public NetOptions getNetParams(long ipAddress) {
        NetOptions result = null;
        for (NetOptions params : this.netOptions) {
            if ((ipAddress & params.mask) != params.net) continue;
            result = params;
            break;
        }
        return result;
    }

    public static class NetOptions {
        public final long net;
        public final long mask;
        public final List<DhcpOption> optionList = new ArrayList<DhcpOption>();

        public NetOptions(long net, long mask) {
            this.net = net;
            this.mask = mask;
        }
    }
}

