/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import bitel.billing.common.VersionInfo;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.slf4j.event.Level;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogger;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.processors.CommonKernelEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.ScriptEventProcessor;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServUtils;
import ru.bitel.bgbilling.modules.inet.server.event.InetAccountingPeriodModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadEvent;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.RequestLogEventProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetServiceCost;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.level.DeviceLevelManager;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntimeManager;

public abstract class InetApplication
extends BGLogger
implements CommandListener,
ThreadContextFactory<ServerContext>,
ExtendedLifecycle {
    public final boolean realtime;
    public final Date initialDate;
    public final Date initialMonth;
    public final Setup setup;
    public final int applicationId;
    public final int moduleId;
    public final int rootDeviceId;
    public final TrafficTypeLinkRuntimeMap trafficTypeLinkRuntimeMap;
    public InetServTypeRuntimeMap servTypeRuntimeMap;
    public volatile Set<Integer> childrenDeviceIds;
    public final InetDeviceRuntimeMap deviceMap;
    public final IpResourceRuntimeManager ipResourceManager;
    public final PoolEventPublisher<InetAccountingEvent> sessionAccountingEP;
    public final PoolEventPublisher<InetAccountingPeriodModifiedEvent> accountingPeriodActivatedEP;
    public final ConvergenceBalanceManager convergenceBalanceManager;
    public final InetTariffContext tariffContext;
    public static final int EMPTY_ROOT_DEVICE_ID = -10;
    public static final int CHECK_TARIFF_PRICE_DISABLE = 0;
    public static final int CHECK_TARIFF_PRICE_ENABLE = 1;
    public static final int CHECK_TARIFF_PRICE_STRICT = 2;
    public static final int CHECK_TARIFF_PRICE_ENABLE_WITHOUT_TIME = 3;
    public static final int CHECK_TARIFF_PRICE_STRICT_WITHOUT_TIME = 4;
    public final int checkTariffPrice;
    public final boolean servDisableOnTariffError;
    public final boolean accountingPeriodActivateFromMonthStart;
    public volatile Set<String> singlesignonRealmSet;
    protected Set<Integer> disableServIds = Collections.emptySet();
    private final EventListener<InetReloadEvent> reloadEventListener = new EventListener<InetReloadEvent>(){

        public void notify(final InetReloadEvent e, EventListenerContext ctx) throws BGException {
            if (e.getRootDeviceId() > 0 && e.getRootDeviceId() != InetApplication.this.rootDeviceId) {
                return;
            }
            InetApplication.this.getLogger().info("InetReloadEvent");
            new Thread("inet-reload"){

                @Override
                public void run() {
                    ServerContext context = new ServerContext(InetApplication.this.setup, InetApplication.this.moduleId, 0);
                    context.init();
                    ThreadContext.set((ThreadContext)context);
                    try {
                        InetApplication.this.reload(e.getUserId());
                        context.commit();
                    }
                    catch (Exception ex) {
                        InetApplication.this.getLogger().error(ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        ThreadContext.set(null);
                        context.destroy();
                    }
                }
            }.start();
        }
    };

    public InetApplication(boolean realtime, Setup setup, int applicationId, int moduleId, boolean loadSaScripts) throws Exception {
        this(realtime, setup, applicationId, moduleId, loadSaScripts, -1, new Date());
    }

    public InetApplication(boolean realtime, Setup setup, int applicationId, int moduleId, boolean loadSaScripts, int rootDeviceId, Date dateFrom) throws Exception {
        ModuleSetup moduleSetup;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Starting Inet Application. app name: %s; app id: %d; inet mid: %s; rootDeviceId: %d; realtime: %s", SetupParam.getApplicationName(), SetupParam.getApplicationId((ParameterMap)setup), SetupParam.getModuleId((ParameterMap)setup), rootDeviceId, realtime));
        }
        this.realtime = realtime;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        this.initialDate = calendar.getTime();
        calendar.set(5, 1);
        this.initialMonth = calendar.getTime();
        this.applicationId = applicationId;
        this.moduleId = moduleId;
        if (rootDeviceId != -1) {
            this.rootDeviceId = rootDeviceId;
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Param rootDeviceId not specify, try to find...");
            }
            this.rootDeviceId = rootDeviceId = setup.getInt("rootDeviceId", -1);
        }
        this.setup = setup;
        if (moduleId <= 0) {
            throw new BGException("Not defined 'moduleId' in XML!");
        }
        if (rootDeviceId != -10 && rootDeviceId <= 0) {
            throw new BGException("Not defined 'rootDeviceId' in XML!");
        }
        if (rootDeviceId == -10) {
            rootDeviceId = 0;
        }
        this.getLogger().debug("rootDeviceId=" + rootDeviceId);
        EventProcessor ep = EventProcessor.getInstance();
        this.convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
        this.sessionAccountingEP = ep.newPoolEventPublisher(InetAccountingEvent.class, moduleId, 500, 100L);
        this.accountingPeriodActivatedEP = ep.newPoolEventPublisher(InetAccountingPeriodModifiedEvent.class, moduleId, 100, 100L);
        this.ipResourceManager = new IpResourceRuntimeManager(realtime, setup, moduleId);
        if (realtime) {
            new RequestLogEventProcessor((DefaultServerSetup)setup);
        }
        int n = this.checkTariffPrice = (moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId))) == null ? 1 : moduleSetup.getInt("accounting.tariffication.checkPrice", 1);
        boolean bl = moduleSetup == null ? false : (this.accountingPeriodActivateFromMonthStart = moduleSetup.getInt("accounting.period.activation.mode", 0) > 0);
        this.servDisableOnTariffError = moduleSetup == null ? false : moduleSetup.getInt("serv.disableOnTariffError", 0) > 0;
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)setup, (boolean)true);){
            this.deviceMap = new InetDeviceRuntimeMap(this, realtime, setup, moduleId, rootDeviceId, loadSaScripts);
            this.tariffContext = new InetTariffContext((DefaultServerSetup)setup, connectionSet, moduleId, MathContext.DECIMAL64, TimeUtils.convertDateToCalendar((Date)dateFrom), realtime);
            this.trafficTypeLinkRuntimeMap = new TrafficTypeLinkRuntimeMap(realtime, connectionSet.getConnection(), moduleId);
            this.servTypeRuntimeMap = new InetServTypeRuntimeMap(realtime, connectionSet.getConnection(), moduleId, this.trafficTypeLinkRuntimeMap);
        }
        try {
            if (realtime) {
                new ScriptEventProcessor(setup).start();
                new CommonKernelEventProcessor(setup);
                try {
                    Setup.getEnvironment().bind("threadContextFactory", (Object)this);
                }
                catch (NamingException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (BGException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
        }
    }

    public Set<Integer> getDisableServIds() {
        return this.disableServIds;
    }

    protected static Set<Integer> loadDisableServIds(InetDeviceRuntimeMap deviceMap) {
        HashSet<String> set = new HashSet<String>();
        for (InetDeviceRuntime device : deviceMap.values()) {
            String ids = device.config.get("radius.disable.servId", null);
            if (Utils.notEmptyString((String)ids) && !set.contains(ids)) {
                set.add(ids);
            }
            if (!Utils.notEmptyString((String)(ids = device.config.get("dhcp.disable.servId", null))) || set.contains(ids)) continue;
            set.add(ids);
        }
        return set.stream().flatMap(a -> Utils.toIntegerSet((String)a).stream()).filter(a -> a != 0).collect(Collectors.toSet());
    }

    public void init() throws Exception {
        ServerContext context = (ServerContext)ThreadContext.get();
        this.deviceMap.load(context.getConnection());
    }

    public void start() throws Exception {
        if (this.realtime) {
            EventProcessor.getInstance().addListener(this.reloadEventListener, InetReloadEvent.class, this.moduleId, null);
        }
    }

    private synchronized void reload(int userId) throws BGException {
        EventProcessor.getInstance().request((QueueEvent)new InetReloadLocalEvent(this.moduleId, userId, this.childrenDeviceIds));
    }

    public void stop() throws Exception {
        EventProcessor.getInstance().removeListener(this.reloadEventListener);
        if (this.tariffContext != null && this.tariffContext.getLevelManager() != null) {
            this.tariffContext.getLevelManager().persist();
        }
    }

    protected InetTariffRequest tarifficate(Level level, ConnectionSet connectionSet, InetServRuntime inetServRuntime, int deviceId, String realm, List<TariffModuleTreeSet.Entry> treeList, long millis, boolean[] checkPrice, boolean restrictions, ConvergenceBalance convergenceBalance, BigDecimal accountDelta, boolean balanceInsufficient) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Tarifficating serv: " + inetServRuntime.inetServId);
        }
        InetServTypeRuntime inetServTypeRuntime = inetServRuntime.inetServTypeRef.get();
        int contractId = inetServRuntime.getInetServ().getContractId();
        AtomicReference<TrafficTypeLinkRuntime> trafficTypeLinkRef = inetServTypeRuntime.trafficTypeLinkRuntimeRef;
        TrafficTypeLinkRuntime trafficTypeLink = trafficTypeLinkRef.get();
        Integer[] trafficServiceIds = trafficTypeLink.trafficServiceIds;
        AbstractPeriodItemSet.PeriodItem accountingPeriod = inetServRuntime.getAccountingPeriod(this, connectionSet, millis, false);
        if (accountingPeriod == null) {
            this.getLogger().warn("Accounting period not found for inetServ:" + inetServRuntime.inetServId);
            return null;
        }
        GregorianCalendar time = new GregorianCalendar();
        time.setTimeInMillis(millis);
        int domainId = inetServRuntime.contractRuntime.getDomainId();
        ProductPeriodRuntimeList productPeriodRuntimeList = inetServRuntime.contractRuntime.getProductPeriods(millis);
        InetTariffRequest inetTariffRequest = new InetTariffRequest(domainId, this.moduleId, contractId, deviceId, 0L, inetServRuntime.contractRuntime.getContractLabelIds(), accountingPeriod.id, accountingPeriod.timeFrom, accountingPeriod.timeTo, realm, null, inetServRuntime, inetServRuntime.getContractSuspendPeriods(), productPeriodRuntimeList);
        inetTariffRequest.setTime(time);
        inetTariffRequest.setConnectionSet(connectionSet);
        inetTariffRequest.setBalanceInsufficient(balanceInsufficient);
        inetTariffRequest.setConvergenceBalance(convergenceBalance);
        inetTariffRequest.setAccountDelta(accountDelta);
        ContractTariffOptionList tariffOptions = inetServRuntime.contractRuntime.getTariffOptions(this.initialDate);
        Map tariffOptionsMap = null;
        if (tariffOptions != null) {
            inetTariffRequest.setContractTariffOptions(tariffOptions);
            tariffOptionsMap = inetTariffRequest.getTariffOptionMap(millis);
            inetTariffRequest.setTariffOptionMap(tariffOptionsMap);
        }
        this.getLogger().atLevel(level).log("contract tariffOptions: " + tariffOptionsMap);
        for (Integer serviceId : trafficServiceIds) {
            ArrayList<InetServiceCost> serviceCostList = new ArrayList<InetServiceCost>(3);
            serviceCostList.add(new InetServiceCost(serviceId, null, null, null, null, 0L));
            inetTariffRequest.setServiceCost(serviceId, serviceCostList);
        }
        InetTariffWorkerContext workerContext = new InetTariffWorkerContext(this.setup, connectionSet, this.moduleId);
        workerContext.init();
        try {
            int restrictionAccessCode;
            for (TariffModuleTreeSet.Entry tree : treeList) {
                inetTariffRequest.setTariffTreeSetEntry(tree);
                tree.getTree().execute((AbstractTariffRequest)inetTariffRequest, (TariffContext)this.tariffContext, (ThreadContext)workerContext);
            }
            if (checkPrice != null && (this.checkTariffPrice == 2 || this.checkTariffPrice == 4)) {
                block7: for (List serviceCostList : inetTariffRequest.getServiceCost().values()) {
                    int size = serviceCostList.size();
                    for (int i = 0; i < size; ++i) {
                        String what;
                        InetServiceCost serviceCost = (InetServiceCost)((Object)serviceCostList.get(i));
                        if (serviceCost.getServiceId() > 0 && serviceCost.getCost() != null || serviceCost.amountNull || serviceCost.getServiceId() == -1 && this.checkTariffPrice == 4) continue;
                        checkPrice[0] = false;
                        if (serviceCost.getCost() == null) {
                            what = serviceCost.getServiceId() < 0 ? "trafficTypeId=" + (-serviceCost.getServiceId() - 1) : "serviceId=" + serviceCost.getServiceId();
                            this.getLogger().error("Cost not set for " + what);
                        } else {
                            what = "trafficTypeId=" + (-serviceCost.getServiceId() - 1);
                            this.getLogger().error("Service not set for " + what);
                        }
                        String key = "inet.tariffication.priceNotFound";
                        AlarmSender.sendAlarm((String)key, (long)600000L, (String)"Inet: \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u0435", (String)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u0430\u0445 \u0434\u043b\u044f " + what + " \u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 id " + inetServRuntime.contractRuntime.contractId));
                        break block7;
                    }
                }
            }
            if (restrictions && (restrictionAccessCode = inetServRuntime.checkRestrictions(workerContext, this, null, inetTariffRequest)) != AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && inetTariffRequest.getAccessCode() == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                inetTariffRequest.setAccessCode(restrictionAccessCode);
            }
            workerContext.commit();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            workerContext.destroy();
        }
        return inetTariffRequest;
    }

    protected abstract BigDecimal getSessionCostDelta(InetServRuntime var1) throws BGException;

    public Set<Integer> inetServOptionSet(ConnectionSet connectionSet, long millis, InetServRuntime inetServRuntime, String realm) throws Exception {
        Set<Integer> servInetOptions;
        InetTariffRequest req;
        BigDecimal sessionCostDelta;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("inetServOptionSet for serv: " + inetServRuntime.inetServId);
        }
        HashSet<Integer> result = new HashSet<Integer>();
        inetServRuntime = inetServRuntime.getRootInetServRuntime(this);
        ConvergenceBalance balance = this.convergenceBalanceManager.getBalance(connectionSet, Integer.valueOf(inetServRuntime.contractRuntime.contractId), millis);
        boolean balanceInsufficient = !balance.isBalanceExceedsLimit(sessionCostDelta = this.getSessionCostDelta(inetServRuntime));
        List treeList = inetServRuntime.getTariffTreeSet().getEntryList(millis);
        if (treeList.size() > 0 && (req = this.tarifficate(Level.DEBUG, connectionSet, inetServRuntime, 0, realm, treeList, millis, null, false, balance, sessionCostDelta, balanceInsufficient)) != null) {
            result.addAll(req.getInetOptionSet());
        }
        if ((servInetOptions = inetServRuntime.getOptions(millis)).size() > 0) {
            if (result.size() > 0) {
                InetOptionRuntimeMap inetOptionRuntimeMap = InetOptionRuntimeMap.getInstance(connectionSet, this.moduleId);
                for (Integer inetOptionId : servInetOptions) {
                    InetOptionRuntime optionRuntime = inetOptionRuntimeMap.get(inetOptionId);
                    if (optionRuntime == null || optionRuntime.replaceIds == null) continue;
                    result.removeAll(optionRuntime.replaceIds);
                }
            }
            result.addAll(servInetOptions);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("OptionSet: " + result);
        }
        return result;
    }

    public String executeCommand(String cmd, String param) {
        if (cmd.equals("flushDataLoggers")) {
            HourlyDataLogger dataLogger2;
            boolean wasError = false;
            try {
                dataLogger2 = (HourlyDataLogger)Setup.getEnvironment().lookup("radiusDataLogger");
                dataLogger2.flush(null).get();
            }
            catch (NamingException dataLogger2) {
            }
            catch (Exception e) {
                wasError = true;
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            try {
                dataLogger2 = (HourlyDataLogger)Setup.getEnvironment().lookup("flowDataLogger");
                dataLogger2.flush(null).get();
            }
            catch (NamingException dataLogger3) {
            }
            catch (Exception e) {
                wasError = true;
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            return wasError ? "Error on flushing dataLoggers." : "DataLoggers flushed.";
        }
        if (cmd.equals("conpool")) {
            return this.setup.getPoolStackTrace();
        }
        if ("status".equals(cmd)) {
            StringBuilder sb = new StringBuilder();
            VersionInfo vi = VersionInfo.getVersionInfo((String)"server");
            sb.append("Kernel version ");
            sb.append(vi.getVersionString());
            sb.append("\n");
            vi = VersionInfo.getVersionInfo((String)"inet");
            sb.append("Inet version ");
            sb.append(vi.getVersionString());
            String ipStatus = this.ipResourceManager.status();
            sb.append('\n').append('\n').append(ipStatus);
            if (ipStatus.length() > 0) {
                sb.append('\n');
            }
            return sb.toString();
        }
        if ("setDeviceLevel".equals(cmd)) {
            String[] params = param.split("\\s+");
            if (params.length != 2) {
                return "Params error";
            }
            int deviceId = Utils.parseInt((String)params[0]);
            int level = Utils.parseInt((String)params[1], (int)-1);
            if (deviceId == 0 ? level != 0 : deviceId <= 0 || level < 0) {
                return "Params error";
            }
            try {
                DeviceLevelManager.setLevel(this.moduleId, deviceId, level);
                return "Ok";
            }
            catch (BGException e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }
        if ("printDeviceLevel".equals(cmd)) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry e : this.tariffContext.getLevelManager().getLevelMap().entrySet()) {
                sb.append(e.getKey()).append('\t').append(e.getValue()).append('\n');
            }
            if (sb.length() == 0) {
                sb.append("Level map is empty");
            }
            return sb.toString();
        }
        return Application.executeCommonCommand((String)cmd, (String)param);
    }

    public String getCommandsHelp() {
        return "flushDataLoggers - flush buffer of flow and radius dataLoggers on disk\nconpool - db connection pool trace\ndynClassRun dyn.class.Name arg0 arg1\ndiskBenchmark - disk benchmark\nstackTrace - get stack trace\nmbeanQuery, mbeanGet, mbeanSet, mbeanInvoke - MBean operations\n";
    }

    public abstract ContractRuntimeMap getContractRuntimeMap();

    public abstract InetServRuntimeMap getInetServRuntimeMap();

    public ServerContext newThreadContext() {
        return new ServerContext(this.setup, this.moduleId, 0);
    }

    public AuthResult authorization(InetServRuntime inetServRuntime, InetServRuntime childInetServRuntime, boolean alive, int deviceId, int agentDeviceId, String realm, String identifier, int setIdentifier, byte[] macAddress, int setMacAddress, int checkDuplicateSessionOnSessionLimit, boolean checkDuplicateUsername, String callingStationId, String username, boolean checkSessionCountLimit, BigDecimal accountDelta, boolean activateAccountingPeriod) throws Exception {
        return this.authorization(Level.DEBUG, inetServRuntime, childInetServRuntime, alive, deviceId, agentDeviceId, realm, identifier, setIdentifier, macAddress, setMacAddress, checkDuplicateSessionOnSessionLimit, checkDuplicateUsername, callingStationId, username, checkSessionCountLimit, accountDelta, activateAccountingPeriod);
    }

    public AuthResult authorization(Level level, InetServRuntime inetServRuntime, InetServRuntime childInetServRuntime, boolean alive, int deviceId, int agentDeviceId, String realm, String identifier, int setIdentifier, byte[] macAddress, int setMacAddress, int checkDuplicateSessionOnSessionLimit, boolean checkDuplicateUsername, String callingStationId, String username, boolean checkSessionCountLimit, BigDecimal accountDelta, boolean activateAccountingPeriod) throws Exception {
        long now;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("authoring serv: " + inetServRuntime.inetServId);
        }
        InetServ inetServ = inetServRuntime.getInetServ();
        int contractId = inetServ.getContractId();
        if (inetServ.getDeviceState() == InetServState.STATE_DELETED.getCode() && !RangeUtils.inRange((long)(now = System.currentTimeMillis()), (long)now, (long)inetServRuntime.getDateFromMillis(), (long)inetServRuntime.getDateToMillis())) {
            this.getLogger().info("inetServ[id=" + inetServ.getId() + "] period is closed.");
            return new AuthResult(AccessCode.INVALID_ACCOUNT.getCode());
        }
        ConnectionSet connectionSet = ((DefaultContext)ThreadContext.get(DefaultContext.class)).getConnectionSet();
        if (!InetServUtils.checkIdentifier(connectionSet, this.moduleId, inetServ, identifier, setIdentifier)) {
            this.getLogger().info("inetServ[id=" + inetServ.getId() + "] identifier not equals.");
            return new AuthResult(AccessCode.IDENTIFIER_DENY.getCode());
        }
        if (!InetServUtils.checkMacAddress(connectionSet, this.moduleId, inetServ, macAddress, setMacAddress)) {
            this.getLogger().info("inetServ[id=" + inetServ.getId() + "] MAC-addresses not equals.");
            return new AuthResult(AccessCode.MAC_DENY.getCode());
        }
        if (inetServ.getStatus() != InetServStatus.STATUS_ON) {
            this.getLogger().info("inetServ[id=" + inetServ.getId() + "] status not active (accessCode=" + inetServ.getAccessCode() + ").");
            return new AuthResult(20);
        }
        if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, inetServRuntime.contractRuntime.getStatus())) {
            this.getLogger().info("inetServ[id=" + inetServ.getId() + "] contract status not active.");
            return new AuthResult(11);
        }
        long millis = System.currentTimeMillis();
        List treeList = inetServRuntime.getTariffTreeSet().getEntryList(millis);
        if (treeList.size() == 0) {
            this.getLogger().info("Tariff not found");
            return new AuthResult(AccessCode.TARIFF_NOT_FOUND.getCode());
        }
        AbstractPeriodItemSet.PeriodItem accountingPeriod = inetServRuntime.accountingPeriodCheck(this, connectionSet, millis, true, activateAccountingPeriod);
        if (accountingPeriod == null) {
            this.getLogger().info("Accounting period not available");
            return new AuthResult(AccessCode.ACCOUNTING_PERIOD_NOT_AVAILABLE.getCode());
        }
        HashSet<Integer> optionSet = new HashSet<Integer>();
        boolean[] checkPrice = new boolean[]{true};
        ConvergenceBalance balance = this.convergenceBalanceManager.getBalance(connectionSet, Integer.valueOf(contractId), millis);
        boolean balanceInsufficient = !balance.isBalanceExceedsLimit(accountDelta);
        InetTariffRequest req = this.tarifficate(level, connectionSet, inetServRuntime, deviceId, realm, treeList, millis, checkPrice, true, balance, accountDelta, balanceInsufficient);
        if (!checkPrice[0]) {
            this.getLogger().error("Price not found");
            return new AuthResult(AccessCode.PRICE_NOT_FOUND.getCode());
        }
        boolean checkBalance = true;
        if (req != null) {
            if (req.getAccessCode() != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                this.getLogger().info("Authorization denied (by tariff or serv restriction) with accessCode " + req.getAccessCode());
                return new AuthResult(req.getAccessCode());
            }
            if (req.isIgnoreBalanceInsufficient()) {
                checkBalance = false;
            }
            optionSet.addAll(req.getInetOptionSet());
        }
        if (checkBalance) {
            if (balanceInsufficient) {
                this.getLogger().info("inetServ[id=" + inetServ.getId() + "] balance is out of limit: " + balance);
                return new AuthResult(12);
            }
            this.getLogger().atLevel(level).log("inetServ[id=" + inetServ.getId() + "] balance ok: " + balance);
        } else {
            this.getLogger().atLevel(level).log("inetServ[id=" + inetServ.getId() + "] skip balance check");
        }
        Set<Integer> servInetOptions = inetServRuntime.getOptions(millis);
        if (servInetOptions.size() > 0) {
            if (optionSet.size() > 0) {
                InetOptionRuntimeMap inetOptionRuntimeMap = InetOptionRuntimeMap.getInstance(connectionSet, this.moduleId);
                for (Integer inetOptionId : servInetOptions) {
                    InetOptionRuntime optionRuntime = inetOptionRuntimeMap.get(inetOptionId);
                    if (optionRuntime == null || optionRuntime.replaceIds == null) continue;
                    optionSet.removeAll(optionRuntime.replaceIds);
                }
            }
            optionSet.addAll(servInetOptions);
        }
        this.getLogger().atLevel(level).log("OptionSet: {}", optionSet);
        return new AuthResult(AccessCode.AUTHORIZATION_SUCCEEDED.getCode(), optionSet, req);
    }
}

