/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgent;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceSelector;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.datalog.snmp.SnmpFlowArray;
import ru.bitel.bgbilling.kernel.network.datalog.snmp.SnmpWorker;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Id;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;
import uk.co.westhawk.snmp.stack.AsnObjectId;

public class InetSnmpWorker
extends SnmpWorker
implements Lifecycle {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;
    private final Set<Integer> agentDeviceIds;
    private FlowAgentInterfaceSelector ifaceSelector;
    private long period;
    private final ConcurrentMap<Integer, List<long[][]>> queryMap = new ConcurrentHashMap<Integer, List<long[][]>>();

    @ConstructorProperties(value={"setup", "accounting", "flowDataLogger", "agentDeviceIds", "period"})
    public InetSnmpWorker(Setup setup, Accounting accounting, IPHourlyDataLogger flowDataLogger, Set<Integer> agentDeviceIds, long period) throws BGException {
        super(setup, accounting.moduleId, flowDataLogger, "datalog.flow.dir", false);
        this.accounting = accounting;
        this.agentDeviceIds = agentDeviceIds;
        this.period = period > 0L ? Math.max(period, 5L) : 30L;
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetReloadLocalEvent>(){

            public void notify(InetReloadLocalEvent e, EventListenerContext ctx) throws BGException {
                InetSnmpWorker.this.queryMap.clear();
            }
        }, InetReloadLocalEvent.class, accounting.moduleId, null);
    }

    public void start() throws Exception {
        this.ifaceSelector = this.accounting.ifaceMap.newSelector(this.agentDeviceIds, 4);
        ServerContextThreadFactory threadContextFactory = new ServerContextThreadFactory(this.setup, this.moduleId, null, null);
        ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new WorkerThreadFactory("snmp-wrkr", "flowListener", (ThreadContextFactory)threadContextFactory));
        scheduledExecutorService.scheduleAtFixedRate((Runnable)((Object)this), 5L, this.period, TimeUnit.SECONDS);
    }

    public void stop() throws Exception {
    }

    protected void runImpl0() {
        if (logger.isDebugEnabled()) {
            logger.debug("Start collecting data using SNMP...");
        }
        for (FlowAgent flowAgent : this.ifaceSelector.getAgentIdMap().values()) {
            InetDeviceRuntime deviceRuntime = this.accounting.deviceMap.get(flowAgent.getId());
            InetDevice agentDevice = deviceRuntime.inetDevice;
            List hosts = agentDevice.getHostsAsString();
            String[] host = hosts != null && hosts.size() > 0 ? (String[])hosts.get(0) : null;
            ArrayList<Long> ifaces = new ArrayList<Long>();
            for (Integer iface : flowAgent.ifIndexSet(System.currentTimeMillis())) {
                ifaces.add((long)iface.intValue() & 0xFFFFFFFFL);
            }
            this.processSource((Id)flowAgent, host != null ? host[0] : agentDevice.getHost(), Utils.parseInt((String)(host != null ? host[1] : "161")), agentDevice.getSecret(), deviceRuntime.config, ifaces);
        }
    }

    protected void processFlow(Id source, long _iface, SnmpFlowArray flowArray, long millis, Long hour) {
        FlowAgent flowAgent = (FlowAgent)source;
        this.processPacketImpl(flowAgent, (FlowArray<? extends Data>)flowArray, millis, hour);
    }

    protected void processPacketImpl(FlowAgent flowAgent, FlowArray<? extends Data> flows, long millis, Long hour) {
        int size = flows.size;
        for (int i = 0; i < size; ++i) {
            Data flow = flows.array[i];
            if (logger.isTraceEnabled()) {
                logger.trace("Processing " + flow.toString());
            }
            IpAddress srcAddress = flow.getSrcIpAddress();
            IpAddress dstAddress = flow.getDstIpAddress();
            int srcPort = flow.getSrcPort();
            int dstPort = flow.getDstPort();
            long octets = flow.getOctets();
            int inputIface = flow.getInputInterface();
            int outputIface = flow.getOutputInterface();
            int diffServ = flow.getDiffServ();
            FlowAgentInterface iface = flowAgent.getInterface(hour, millis, inputIface);
            if (iface == null || !iface.processFlow(flow, hour, millis, srcAddress, 1, outputIface, dstAddress, dstPort, diffServ, octets, true)) {
                if (logger.isTraceEnabled()) {
                    if (iface == null) {
                        logger.trace("Not found iface = " + inputIface);
                    } else {
                        logger.trace("Session not found on iface = " + inputIface);
                    }
                }
                if (flowAgent.defaultIface != null) {
                    if (!flowAgent.defaultIface.processFlow(flow, hour, millis, srcAddress, 1, outputIface, dstAddress, dstPort, diffServ, octets, true)) {
                        logger.trace("Session not found on default iface");
                    }
                } else {
                    logger.trace("Default iface not found");
                }
            }
            if ((iface = flowAgent.getInterface(hour, millis, outputIface)) != null && iface.processFlow(flow, hour, millis, dstAddress, 2, inputIface, srcAddress, srcPort, diffServ, octets, true)) continue;
            if (logger.isTraceEnabled()) {
                if (iface == null) {
                    logger.trace("Not found iface = " + outputIface);
                } else {
                    logger.trace("Session not found on iface = " + outputIface);
                }
            }
            if (flowAgent.defaultIface != null) {
                if (flowAgent.defaultIface.processFlow(flow, hour, millis, dstAddress, 2, inputIface, srcAddress, srcPort, diffServ, octets, true)) continue;
                logger.trace("Session not found on default iface");
                continue;
            }
            logger.trace("Default iface not found");
        }
    }

    protected List<long[][]> getQuery(Id source) {
        long[] suffix;
        long[] prefix;
        ArrayList<long[][]> result = (ArrayList<long[][]>)this.queryMap.get(source.getId());
        if (result != null) {
            return result;
        }
        FlowAgent flowAgent = (FlowAgent)source;
        String ifIndex = flowAgent.config.get("flow.agent.snmp.oid.ifIndex", null);
        String ifInOctets = flowAgent.config.get("flow.agent.snmp.oid.ifInOctets", null);
        String ifOutOctets = flowAgent.config.get("flow.agent.snmp.oid.ifOutOctets", null);
        if (Utils.isBlankString((String)ifInOctets) && Utils.isBlankString((String)ifOutOctets) && Utils.isBlankString((String)ifIndex)) {
            result = super.getQuery(source);
            this.queryMap.put(source.getId(), result);
            return result;
        }
        List defaultQuery = super.getQuery(source);
        result = new ArrayList<long[][]>(defaultQuery.size());
        for (long[][] q : defaultQuery) {
            result.add(new long[][]{Arrays.copyOf(q[0], q[0].length), q[1] != null ? Arrays.copyOf(q[1], q[1].length) : null});
        }
        if (Utils.notBlankString((String)ifIndex)) {
            prefix = null;
            suffix = null;
            String[] ifIndexA = ifIndex.split("\\?");
            if (ifIndexA.length == 1) {
                prefix = new AsnObjectId(ifIndexA[0]).getOid();
            } else {
                prefix = new AsnObjectId(ifIndexA[0].substring(0, ifIndexA[0].length() - 1)).getOid();
                suffix = new AsnObjectId(ifIndexA[1].substring(1)).getOid();
            }
            result.set(1, new long[][]{prefix, suffix});
        }
        if (Utils.notBlankString((String)ifInOctets)) {
            prefix = null;
            suffix = null;
            String[] ifInOctetsA = ifInOctets.split("\\?");
            if (ifInOctetsA.length == 1) {
                prefix = new AsnObjectId(ifInOctetsA[0]).getOid();
            } else {
                prefix = new AsnObjectId(ifInOctetsA[0].substring(0, ifInOctetsA[0].length() - 1)).getOid();
                suffix = new AsnObjectId(ifInOctetsA[1].substring(1)).getOid();
            }
            result.set(2, new long[][]{prefix, suffix});
        }
        if (Utils.notBlankString((String)ifOutOctets)) {
            prefix = null;
            suffix = null;
            String[] ifOutOctetsA = ifOutOctets.split("\\?");
            if (ifOutOctetsA.length == 1) {
                prefix = new AsnObjectId(ifOutOctetsA[0]).getOid();
            } else {
                prefix = new AsnObjectId(ifOutOctetsA[0].substring(0, ifOutOctetsA[0].length() - 1)).getOid();
                suffix = new AsnObjectId(ifOutOctetsA[1].substring(1)).getOid();
            }
            result.set(3, new long[][]{prefix, suffix});
        }
        this.queryMap.put(source.getId(), result);
        return result;
    }
}

