/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao0;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.InetDeviceEntityAttrDaoSupport;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTreeFilter;

public class InetDeviceDao
extends AbstractEntityDao<InetDevice> {
    private static final Logger logger = LogManager.getLogger();
    private InetDeviceDao0 inetDeviceDao0;
    private Directory<InetDeviceType> deviceTypeDir;
    protected Directory<? extends EntitySpec> entitySpecDirectory;

    public InetDeviceDao(Connection con, int moduleId) throws BGException {
        super(con, moduleId, 0, "inet_device_tree", "inet_device", (EntityAttrDaoSupport)new InetDeviceEntityAttrDaoSupport());
        this.inetDeviceDao0 = new InetDeviceDao0(con, moduleId, this.userId);
        this.deviceTypeDir = ServerDirectoryFactory.newUnmodifiableDirectory(InetDeviceType.class, (Connection)con, (int)moduleId, (boolean)false);
    }

    public InetDevice root(DeviceTreeFilter deviceTreeFilter, boolean loadAncestors) throws BGException {
        return this.inetDeviceDao0.root(deviceTreeFilter, loadAncestors);
    }

    public InetDevice node(List<FilterEntityAttr> entityFilter, int deviceId, boolean loadDeviceGroupIds) throws BGException {
        return this.inetDeviceDao0.node(entityFilter, deviceId, loadDeviceGroupIds);
    }

    public InetDevice get(int id) throws BGException {
        return this.inetDeviceDao0.get(id);
    }

    public Directory<? extends EntitySpec> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(EntitySpec.class, (Connection)this.con, (int)0, (boolean)true);
        }
        return this.entitySpecDirectory;
    }

    private String equals(String value, String invValue) {
        if (invValue == null) {
            return null;
        }
        if (value == null) {
            return invValue;
        }
        if (value.equals(invValue)) {
            return null;
        }
        return value;
    }

    private InetDevice find(InetDevice device, int id) {
        if (device.getId() == id) {
            return device;
        }
        if (device.getChildren() != null) {
            for (InetDevice child : device.getChildren()) {
                InetDevice result = this.find(child, id);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void move(int newParentId, Set<Integer> children) throws BGException {
        if (newParentId < 0 || children == null || children.size() == 0) {
            throw new BGIllegalArgumentException();
        }
        for (Integer id : children) {
            InetDevice child = this.node(null, id, false);
            if (this.find(child, newParentId) == null) continue;
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0435\u0435.");
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=? WHERE id IN (" + Utils.toString(children) + ")");
            ps.setInt(1, newParentId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int delete(int id) throws BGException {
        int result = 0;
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, id);
            result = ps.executeUpdate();
            PreparedStatement deleteGroupLinkPS = this.con.prepareStatement("DELETE FROM inet_device_group_link_" + this.moduleId + " WHERE deviceId=?");
            deleteGroupLinkPS.setInt(1, id);
            deleteGroupLinkPS.executeUpdate();
            deleteGroupLinkPS.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void close() throws BGException {
        super.close();
        try {
            this.inetDeviceDao0.close();
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public InetDevice rootSource() throws BGException {
        return this.inetDeviceDao0.rootSource();
    }

    public List<InetDevice> listSource() throws BGException {
        return this.inetDeviceDao0.listSource();
    }

    public List<InetDevice> listByInvDeviceId(int id) throws BGException {
        return this.inetDeviceDao0.listByInvDeviceId(id);
    }

    public static void checkTables(Connection con, int moduleId, Date initialDate) {
        try {
            if (ServerUtils.tableExists((Connection)con, (String)("inet_device_tree_" + moduleId))) {
                return;
            }
            logger.warn("CONVERT TABLE inet_device_ TO inet_device_tree_ AND inv_device_");
            Statement stmt = con.createStatement();
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `inet_device_tree_" + moduleId + "` ( `id` int(11) NOT NULL AUTO_INCREMENT, `sort` int(11) NOT NULL DEFAULT 0, `invDeviceId` varchar(45) NOT NULL, `parentId` int(11) NOT NULL, `title` varchar(200) NOT NULL, `deviceTypeId` int(11) NOT NULL DEFAULT '-1', `identifier` varchar(150), `host` varchar(100), `svlan` INT(11) NOT NULL DEFAULT -1, `config` text NOT NULL, PRIMARY KEY (`id`))");
            stmt.executeUpdate("CREATE TABLE inv_device_" + moduleId + " LIKE inet_device_" + moduleId);
            stmt.executeUpdate("INSERT INTO inv_device_" + moduleId + " SELECT * FROM inet_device_" + moduleId);
            stmt.executeUpdate("INSERT INTO inet_device_tree_" + moduleId + " SELECT id, 0, id, parentId, title, -1, NULL, NULL, -1, '' FROM inv_device_" + moduleId);
            stmt.close();
            logger.warn("SEEMS TO CONVERTING COMPLETE OK");
        }
        catch (SQLException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<InetDevice> inetDeviceList(int deviceTypeId) throws BGException {
        return this.inetDeviceDao0.inetDeviceList(deviceTypeId);
    }

    public List<InetDevice> inetDeviceList() throws BGException {
        return this.inetDeviceDao0.inetDeviceList();
    }

    protected InetDevice getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        return null;
    }

    protected void updateImpl(InetDevice inetDevice) throws BGException, SQLException {
        Directory<? extends EntitySpec> entitySpecDirectory;
        EntitySpec entitySpec;
        InetDeviceType deviceType = (InetDeviceType)this.deviceTypeDir.get(inetDevice.getDeviceTypeId());
        if (deviceType == null && inetDevice.getDeviceTypeId() == 0) {
            deviceType = new InetDeviceType(0, "\u041f\u0430\u043f\u043a\u0430");
        }
        String title = InetDevice.generateTitle((String)inetDevice.getIdentifier(), (String)inetDevice.getHost(), (String)deviceType.getGuiTitle());
        inetDevice.setTitle(title);
        if (inetDevice.getEntitySpecId() > 0 && (entitySpec = (EntitySpec)(entitySpecDirectory = this.getEntitySpecDirectory()).get(inetDevice.getEntitySpecId())) != null) {
            inetDevice.setTitle(entitySpec.createEntityTitle((Entity)inetDevice));
        }
        boolean update = inetDevice.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET parentId=?, invDeviceId=?, deviceTypeId=?, identifier=?, host=?, title=?, config=?, svlan=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, inetDevice.getParentId());
            ps.setInt(index++, inetDevice.getInvDeviceId());
            ps.setInt(index++, inetDevice.getDeviceTypeId() == inetDevice.getInvDeviceTypeId() ? -1 : inetDevice.getDeviceTypeId());
            ps.setString(index++, this.equals(inetDevice.getIdentifier(), inetDevice.getInvIdentifier()));
            ps.setString(index++, this.equals(inetDevice.getHost(), inetDevice.getInvHost()));
            ps.setString(index++, inetDevice.getTitle());
            ps.setString(index++, inetDevice.getConfig());
            ps.setInt(index++, inetDevice.getSvlan());
            this.executeUpdate((Id)inetDevice, index, ps);
            if (update) {
                try (PreparedStatement deleteGroupLinkPS = this.con.prepareStatement("DELETE FROM inet_device_group_link_" + this.moduleId + " WHERE deviceId=?");){
                    deleteGroupLinkPS.setInt(1, inetDevice.getId());
                    deleteGroupLinkPS.executeUpdate();
                }
            }
            try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO inet_device_group_link_" + this.moduleId + " SET deviceId=?, deviceGroupId=?");){
                psInsert.setInt(1, inetDevice.getId());
                if (inetDevice.getDeviceGroupIds() != null) {
                    for (Integer i : inetDevice.getDeviceGroupIds()) {
                        psInsert.setInt(2, i);
                        psInsert.executeUpdate();
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public boolean reorder(int srcDeviceId, int parentDeviceId, int pos) throws BGException {
        boolean result = true;
        InetDevice srcDevice = this.get(srcDeviceId);
        if (srcDevice == null) {
            result = false;
        } else if (srcDevice.getParentId() == parentDeviceId && pos > -1) {
            this.sort(parentDeviceId, srcDeviceId, pos);
        } else {
            try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET `parentId`=? WHERE `id`=?");){
                ps.setInt(1, parentDeviceId);
                ps.setInt(2, srcDeviceId);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            this.sort(srcDevice.getParentId(), 0, -1);
            this.sort(parentDeviceId, srcDeviceId, pos);
        }
        return result;
    }

    private void sort(int parentDeviceId, int srcDeviceId, int pos) throws BGException {
        int srcPos = 0;
        ArrayList<Integer> list = new ArrayList<Integer>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT `id` FROM " + this.tableName + " WHERE `parentId`=? ORDER BY `sort`, `id`");){
            ps.setInt(1, parentDeviceId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt(1);
                    if (srcDeviceId != id) {
                        list.add(id);
                    }
                    srcPos = list.size();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        if (srcDeviceId > 0) {
            if (pos > -1) {
                list.add(pos - (pos > srcPos ? 1 : 0), srcDeviceId);
            } else {
                list.add(srcDeviceId);
            }
        }
        try (PreparedStatement psUpdate = this.con.prepareStatement("UPDATE " + this.tableName + " SET `sort`=? WHERE `id`=?");){
            for (int index = 0; index < list.size(); ++index) {
                psUpdate.setInt(1, index);
                psUpdate.setInt(2, (Integer)list.get(index));
                psUpdate.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

