/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.table;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.kernel.tariff.server.enums.TrafficRangeMode;
import ru.bitel.bgbilling.kernel.tariff.server.enums.TrafficRangeType;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.InetTrafficRangeDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TableTrafficRangeDay
extends BGTableInfoBase {
    public TableTrafficRangeDay() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextCenter((String)"TreeNodeId", (String)"treeNodeId").setMaxWidth(300), BGUTableColumn.buildColumnTextCenter((String)"\u041a\u043b\u044e\u0447", (String)"rangeKey").setMaxWidth(-1), BGUTableColumn.buildColumnTextRight((String)"\u0414\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430", (String)"day").setWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041e\u0431\u044a\u0435\u043c", (String)"amount").setMaxWidth(150)};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        Connection con = serverContext.getConnection();
        try (InetTrafficRangeDao inetTrafficRangeDao = new InetTrafficRangeDao(con, moduleId);){
            List<BGUTableRowData> list = inetTrafficRangeDao.contractTrafficRangeDayList(tableParams.getContractId(), tableParams.optParamValue("period").map(a -> LocalDate.parse(a)).orElse(LocalDate.now())).stream().map(a -> new BGUTableRowData().addValue("treeNodeId", String.valueOf(a.getTreeNodeId())).addValue("rangeKey", this.rangeKeyToString(a.getRangeKey())).addValue("day", String.valueOf(a.getDay())).addValue("amount", Utils.formatLong((long)a.getAmount()))).toList();
            return list;
        }
    }

    private String rangeKeyToString(long rangeKey) {
        return rangeKey + " [mode = " + TrafficRangeMode.getTrafficRangeModeByCode((int)TrafficRangeKey.getMode((long)rangeKey)) + "; type = " + TrafficRangeType.getTrafficRangeTypeByCode((int)TrafficRangeKey.getType((long)rangeKey)) + "; id = " + TrafficRangeKey.getId((long)rangeKey) + Optional.ofNullable(TrafficRangeKey.getTime((long)rangeKey, (Calendar)new GregorianCalendar())).map(a -> "; time = " + TimeUtils.format((Calendar)a, (String)"dd.MM.yyyy HH:mm")).orElse("") + "]";
    }
}

