/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.net.URLEncoder;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.gazprombank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.Constants;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Gazprombank")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("gazprombank");
    }

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws Exception {
        if (this.context.getRequest().getParameter("check") != null) {
            new TransactionManager(this.con, this.moduleId).doCheckRequest(this.contractId, ServletUtils.getIpFromHeader((HttpServletRequest)this.context.getRequest(), (Setup)this.setup));
        }
        super.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("gazprombank.gate.url", "https://payments.gazprombank.ru/ecomm/ClientHandler"));
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = new SearchParam().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction(searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        this.setClientIpAddr();
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        new TransactionManager(this.con, this.moduleId).registerOrder(contract.getId(), contract.getTitle(), this.sum, this.getResult(), false, false);
        this.setResultParam("gateUrl", this.moduleSetup.get("gazprombank.gate.url", "https://payments.gazprombank.ru/ecomm/ClientHandler"));
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        super.autopayment();
        this.autopaymentImpl("gazprombank", new AutopaymentManager(this.con, this.moduleId), Constants.class);
    }

    protected void registerOrder(BigDecimal sum, String customerAddress) throws Exception {
        this.setClientIpAddr();
        String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
        new TransactionManager(this.con, this.moduleId).registerOrder(this.contractId, contractTitle, sum, this.getResult(), false, true);
    }

    protected void autopaymentRedirect(boolean redirect) throws Exception {
        if (redirect) {
            this.doRedirect();
        } else {
            this.execute();
        }
    }

    protected void doRedirect() throws Exception {
        Object transactionId = this.getResultParam("TRANSACTION_ID");
        if (transactionId != null) {
            try {
                this.setResultParam("contentType", ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(this.moduleSetup.get("gazprombank.gate.url", "https://payments.gazprombank.ru/ecomm/ClientHandler") + "?trans_id=" + URLEncoder.encode(String.valueOf(transactionId), "UTF-8"));
                return;
            }
            catch (Exception ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.execute();
        throw new BGMessageException(this.getResultParam("errorMessage") + " [errorCode=" + this.getResultParam("errorCode") + "]");
    }

    private void setClientIpAddr() {
        this.setResultParam("gazprombank.client.ip.addr", ServletUtils.getIpFromHeader((HttpServletRequest)this.context.getRequest(), (Setup)this.setup));
    }
}

