/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.client;

import bitel.billing.common.ModelItem;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.plugins.cladr.client.CLADRTabPanel;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrAddress;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrStreet;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityType;

public class MainManager
extends CLADRTabPanel
implements PropertyChangeListener {
    private JList<BGUListItem> searchList = null;
    private JList<BGUListItem> streetList = null;
    private JList<BGUListItem> streetCompare = null;
    private JPanel searchPanel = null;
    private JPanel infoPanel = null;
    private JPanel streetPanel = null;
    private JPanel cardPanel = null;
    private JPanel loadPanel = null;
    private JPanel startPanel = null;
    private CladrStreet street = new CladrStreet();
    private BGButton loadStreetButton = null;
    private BGButton loadCladrButton = null;
    private BGButton createIndexButton = null;
    private BGButton commitStreet = null;
    private BGButton ignoreStreet = null;
    private BGButton delStreet = null;
    private JCheckBox regionCheck = null;
    private JCheckBox areaCheck = null;
    private JCheckBox ignoreSocr = null;
    private BGUComboBox<KeyValue> city = null;
    private NoEditTextField infoName = null;
    private NoEditTextField infoSocr = null;
    private NoEditTextField infoCode = null;
    private NoEditTextField infoPath = null;
    private BGTextField oldStreetTitle = null;
    private JRadioButton directCheck = null;
    private JRadioButton reverseCheck = null;
    private ProgressMonitor progressMonitor = null;
    SwingWorker<Document, Object> task2 = null;
    SwingWorker<Document, Object> task = null;

    public MainManager() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.setData();
    }

    private void jbInit() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)this.getSearchPanel(), new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.getInfoPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)this.getStartPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)this.getCardPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)leftPanel, (Component)rightPanel, 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    JPanel getCardPanel() {
        if (this.cardPanel == null) {
            this.cardPanel = new JPanel(new CardLayout());
            this.cardPanel.add((Component)this.getStreetPanel(), "streelPanel");
            this.cardPanel.add((Component)this.getLoadPanel(), "loadPanel");
        }
        return this.cardPanel;
    }

    private void loadPanelVisible(boolean visivle) {
        this.getStreetPanel().setVisible(!visivle);
        this.getLoadPanel().setVisible(visivle);
    }

    private JPanel getLoadPanel() {
        if (this.loadPanel == null) {
            this.loadPanel = new JPanel(new GridBagLayout());
            this.loadPanel.setVisible(false);
            this.loadPanel.setBorder((Border)new BGTitleBorder("\u0412\u044b\u0431\u043e\u0440 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f "));
            this.oldStreetTitle = new BGTextField();
            this.oldStreetTitle.setEditable(false);
            this.streetCompare = new JList();
            this.streetCompare.setModel(new DefaultListModel());
            this.streetCompare.setSelectionMode(0);
            this.commitStreet = new BGButton("\u041f\u0440\u0438\u043d\u044f\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.commitStreet.setActionCommand("commit");
            this.commitStreet.setEnabled(false);
            this.commitStreet.addActionListener(e -> this.loadCladrRequest(e));
            this.ignoreStreet = new BGButton("\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u0443");
            this.ignoreStreet.setActionCommand("ignore");
            this.ignoreStreet.addActionListener(e -> this.loadCladrRequest(e));
            this.delStreet = new BGButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u0443");
            this.delStreet.setActionCommand("del");
            this.delStreet.addActionListener(e -> this.loadCladrRequest(e));
            this.loadPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0440\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.loadPanel.add((Component)this.oldStreetTitle, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.loadPanel.add((Component)new JScrollPane(this.streetCompare), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.loadPanel.add((Component)this.commitStreet, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.loadPanel.add((Component)this.ignoreStreet, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.loadPanel.add((Component)this.delStreet, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        return this.loadPanel;
    }

    private JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.city = new BGUComboBox();
            this.city.addActionListener(e -> {
                this.setLoadEnabled(false);
                this.searchRequest();
            });
            this.searchList = new JList();
            this.searchList.setModel(new DefaultListModel());
            this.searchList.setSelectionMode(0);
            this.searchList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    BGUListItem listItem = MainManager.this.searchList.getSelectedValue();
                    if (listItem != null) {
                        MainManager.this.infoCode.setText((String)listItem.getAttribute("code"));
                        MainManager.this.infoPath.setText((String)listItem.getAttribute("path"));
                        MainManager.this.infoSocr.setText((String)listItem.getAttribute("socr"));
                        MainManager.this.infoName.setText((String)listItem.getAttribute("name"));
                        MainManager.this.streetList.setModel(new DefaultListModel());
                        MainManager.this.loadPanelVisible(false);
                        MainManager.this.setLoadTypeEnabled(false);
                        MainManager.this.setLoadEnabled(true);
                        String region = (String)listItem.getAttribute("region");
                        String area = (String)listItem.getAttribute("area");
                        if (region != null && region.equals("1")) {
                            MainManager.this.regionCheck.setEnabled(true);
                            MainManager.this.regionCheck.setSelected(false);
                            this.directEnable();
                        }
                        if (area != null && area.equals("1")) {
                            MainManager.this.areaCheck.setEnabled(true);
                            MainManager.this.areaCheck.setSelected(false);
                            this.directEnable();
                        }
                    }
                }

                private void directEnable() {
                    MainManager.this.directCheck.setEnabled(true);
                    MainManager.this.directCheck.setSelected(false);
                    MainManager.this.reverseCheck.setEnabled(true);
                    MainManager.this.reverseCheck.setSelected(false);
                    MainManager.this.ignoreSocr.setEnabled(true);
                    MainManager.this.ignoreSocr.setSelected(true);
                }
            });
            this.createIndexButton = new BGButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c(\u043f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u0442\u044c) \u0438\u043d\u0434\u0435\u043a\u0441");
            this.createIndexButton.addActionListener(e -> this.createIndexRequest());
            this.searchPanel = new JPanel(new GridBagLayout());
            this.searchPanel.setBorder((Border)new BGTitleBorder("\u041f\u043e\u0438\u0441\u043a"));
            this.searchPanel.add((Component)this.city, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.searchPanel.add((Component)new JScrollPane(this.searchList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.searchPanel.add((Component)this.createIndexButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        return this.searchPanel;
    }

    JPanel getStartPanel() {
        if (this.startPanel == null) {
            this.startPanel = new JPanel();
            this.startPanel.setBorder((Border)new BGTitleBorder("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430"));
            this.startPanel.setLayout(new GridBagLayout());
            this.loadCladrButton = new BGButton("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0431\u0430\u0437\u0443");
            this.loadCladrButton.setActionCommand("startLoad");
            this.loadCladrButton.addActionListener(e -> this.loadCladrRequest(e));
            this.regionCheck = new JCheckBox("\u0440\u0435\u0433\u0438\u043e\u043d");
            this.areaCheck = new JCheckBox("\u0440\u0430\u0439\u043e\u043d");
            ButtonGroup bGroup = new ButtonGroup();
            this.directCheck = new JRadioButton("\u043f\u0440\u044f\u043c\u043e\u0439");
            this.reverseCheck = new JRadioButton("\u043e\u0431\u0440\u0430\u0442\u043d\u044b\u0439");
            this.ignoreSocr = new JCheckBox();
            bGroup.add(this.directCheck);
            bGroup.add(this.reverseCheck);
            this.setLoadTypeEnabled(false);
            this.startPanel.add((Component)new JLabel("\u0412 \u0438\u043c\u044f \u0433\u043e\u0440\u043e\u0434\u0430 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.startPanel.add((Component)this.regionCheck, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.startPanel.add((Component)this.areaCheck, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.startPanel.add((Component)new JLabel("\u0418\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043e\u043a\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u0432 \u0443\u043b\u0438\u0446\u0430\u0445:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.startPanel.add((Component)this.ignoreSocr, new GridBagConstraints(4, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.startPanel.add((Component)new JLabel("\u041f\u043e\u0440\u044f\u0434\u043e\u043a:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.startPanel.add((Component)this.directCheck, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.startPanel.add((Component)this.reverseCheck, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.startPanel.add((Component)this.loadCladrButton, new GridBagConstraints(5, 0, 1, 2, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        return this.startPanel;
    }

    JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPath = new NoEditTextField(30);
            this.infoCode = new NoEditTextField(20);
            this.infoSocr = new NoEditTextField(10);
            this.infoName = new NoEditTextField(30);
            this.loadStreetButton = new BGButton("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0443\u043b\u0438\u0446\u044b");
            this.loadStreetButton.addActionListener(e -> this.loadStreetRequest());
            this.infoPanel = new JPanel(new GridBagLayout());
            this.infoPanel.setBorder((Border)new BGTitleBorder("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u0431\u044c\u0435\u043a\u0442\u0435"));
            this.infoPanel.add((Component)new JLabel("\u043f\u043e\u0434\u0447\u0438\u043d\u0435\u043d\u043d\u043e\u0441\u0442\u044c"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.infoPanel.add((Component)((Object)this.infoPath), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.infoPanel.add((Component)this.getCodeSocrNamePanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.infoPanel.add((Component)this.loadStreetButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        return this.infoPanel;
    }

    private JPanel getCodeSocrNamePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u043a\u043e\u0434"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)((Object)this.infoCode), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0442\u0438\u043f"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)((Object)this.infoSocr), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)((Object)this.infoName), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        return panel;
    }

    JPanel getStreetPanel() {
        if (this.streetPanel == null) {
            this.streetPanel = new JPanel(new GridBagLayout());
            this.streetPanel.setBorder((Border)new BGTitleBorder("\u0421\u043f\u0438\u0441\u043e\u043a \u0443\u043b\u0438\u0446"));
            this.streetPanel.setVisible(false);
            this.streetList = new JList();
            this.streetList.setModel(new DefaultListModel());
            this.streetList.setSelectionMode(0);
            JScrollPane scrollPane = new JScrollPane(this.streetList);
            this.streetPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        return this.streetPanel;
    }

    public void setData() {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetAddressDirectory");
        request.setAttribute("mode", AddressEntityType.CITY.getCode());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                ArrayList<KeyValue> titles = new ArrayList<KeyValue>();
                titles.add(KeyValue.NO_SELECT);
                XMLUtils.selectElements((Node)doc, (String)"//directory/item").forEach(a -> titles.add(new KeyValue(a.getAttribute("id"), a.getAttribute("title"))));
                this.city.setData(titles);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        if (this.city.getItemCount() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u043d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0433\u043e\u0440\u043e\u0434\u0430!");
        } else {
            this.city.setSelectedIndex(0);
        }
    }

    private void searchRequest() {
        if (this.city.getSelectedItem() == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0433\u043e\u0440\u043e\u0434!");
            return;
        }
        if ("noSelect".equals(((KeyValue)this.city.getSelectedItem()).getKey())) {
            this.searchList.setModel(new DefaultListModel());
            return;
        }
        Request request = new Request().setModule(this.module).setAction("SearchObject").setAttribute("searchString", ((KeyValue)this.city.getSelectedItem()).toString());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            DefaultListModel<BGUListItem> model = new DefaultListModel<BGUListItem>();
            Element list = XMLUtils.getElement((Document)doc, (String)"address");
            NodeList nodeList = list.getElementsByTagName("item");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element item = (Element)nodeList.item(i);
                String code = item.getAttribute("code");
                String socr = item.getAttribute("socr");
                String name = item.getAttribute("name");
                BGUListItem listItem = new BGUListItem(0, code + " " + socr + " " + name);
                listItem.setAttribute("code", (Object)code);
                listItem.setAttribute("socr", (Object)socr);
                listItem.setAttribute("name", (Object)name);
                listItem.setAttribute("path", (Object)item.getAttribute("path"));
                listItem.setAttribute("region", (Object)item.getAttribute("region"));
                listItem.setAttribute("area", (Object)item.getAttribute("area"));
                model.addElement(listItem);
            }
            this.searchList.setModel(model);
        }
    }

    private void loadStreetRequest() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("GetStreet");
        req.setAttribute("code", this.infoCode.getText());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            DefaultListModel<BGUListItem> model = new DefaultListModel<BGUListItem>();
            Element list = XMLUtils.getElement((Document)doc, (String)"streets");
            NodeList nodeList = list.getElementsByTagName("item");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element item = (Element)nodeList.item(i);
                String code = item.getAttribute("code");
                String socr = item.getAttribute("socr");
                String name = item.getAttribute("name");
                String index = item.getAttribute("index");
                BGUListItem listItem = new BGUListItem(0, code + " " + socr + " " + name + " " + index);
                listItem.setAttribute("code", (Object)code);
                listItem.setAttribute("socr", (Object)socr);
                listItem.setAttribute("name", (Object)name);
                listItem.setAttribute("index", (Object)index);
                model.addElement(listItem);
            }
            this.streetList.setModel(model);
        }
        this.loadPanelVisible(false);
    }

    private void loadCladrRequest(ActionEvent e) {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("LoadCladr");
        request.setAttribute("city_code", this.infoCode.getText());
        request.setAttribute("region", this.regionCheck.isSelected());
        request.setAttribute("area", this.areaCheck.isSelected());
        KeyValue itemCity = (KeyValue)this.city.getSelectedItem();
        request.setAttribute("city_id", itemCity.getKey());
        if (this.directCheck.isSelected()) {
            request.setAttribute("direct", "1");
        } else {
            request.setAttribute("direct", "-1");
        }
        request.setAttribute("ignoreSocr", this.ignoreSocr.isSelected());
        String action = ((BGButton)e.getSource()).getActionCommand();
        if (action.equals("startLoad")) {
            request.setAttribute("command", "start");
        } else {
            request.setAttribute("command", action);
        }
        BGUListItem itemList = this.streetCompare.getSelectedValue();
        if (itemList != null) {
            this.street.setTitle((String)itemList.getAttribute("name"));
            this.street.setSocr((String)itemList.getAttribute("socr"));
            this.street.setCode((String)itemList.getAttribute("code"));
            this.street.setIndex((String)itemList.getAttribute("index"));
        }
        request.addModel((ModelItem)this.street);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element status = XMLUtils.getElement((Document)doc, (String)"status");
            if (status.getAttribute("end").equals("1")) {
                this.oldStreetTitle.setText("\u0411\u0430\u0437\u0430 \u041a\u041b\u0410\u0414\u0420 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u0430");
                DefaultListModel<BGUListItem> model = new DefaultListModel<BGUListItem>();
                model.addElement(new BGUListItem(0, "\u0411\u0430\u0437\u0430 \u041a\u041b\u0410\u0414\u0420 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u0430"));
                this.loadPanelVisible(true);
                this.streetCompare.setModel(model);
                this.commitStreet.setEnabled(false);
                this.delStreet.setEnabled(false);
                this.ignoreStreet.setEnabled(false);
                return;
            }
            this.street = new CladrStreet();
            this.street.loadFromXML(XMLUtils.getElement((Document)doc, (String)this.street.getElementName()));
            this.oldStreetTitle.setText(this.street.getTitle());
            DefaultListModel<BGUListItem> model = new DefaultListModel<BGUListItem>();
            Element list = XMLUtils.getElement((Document)doc, (String)(new CladrAddress().getElementName() + "_list"));
            NodeList nodeList = list.getElementsByTagName(new CladrAddress().getElementName());
            this.commitStreet.setEnabled(false);
            this.ignoreStreet.setEnabled(true);
            this.delStreet.setEnabled(true);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element item = (Element)nodeList.item(i);
                CladrAddress address = new CladrAddress();
                address.loadFromXML(item);
                BGUListItem listItem = new BGUListItem(0, address.getCode() + " " + address.getSocr() + " " + address.getName() + " " + address.getIndex());
                listItem.setAttribute("code", (Object)address.getCode());
                listItem.setAttribute("socr", (Object)address.getSocr());
                listItem.setAttribute("name", (Object)address.getName());
                listItem.setAttribute("index", (Object)address.getIndex());
                model.addElement(listItem);
                this.commitStreet.setEnabled(true);
            }
            this.streetCompare.setModel(model);
            this.streetCompare.setSelectedIndex(0);
        }
        this.loadPanelVisible(true);
    }

    private void createIndexRequest() {
        this.task = new SwingWorker<Document, Object>(){

            @Override
            protected Document doInBackground() throws Exception {
                for (int i = 0; i < 100; ++i) {
                    Thread.sleep(100L);
                    this.setProgress(i);
                    if (i != 99) continue;
                    i = 0;
                }
                return null;
            }
        };
        this.progressMonitor = new ProgressMonitor((Component)((Object)this), "\u0414\u043e\u043b\u0433\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f", "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430", 0, 100);
        this.progressMonitor.setProgress(0);
        this.task.addPropertyChangeListener(this);
        this.task2 = new SwingWorker<Document, Object>(){

            @Override
            protected Document doInBackground() throws Exception {
                Request req = new Request();
                req.setModule(MainManager.this.module);
                req.setAction("CreateIndex");
                Document doc = MainManager.this.getDocument(req);
                return doc;
            }
        };
        this.task2.execute();
        this.task.execute();
        this.buttonEnable(false);
    }

    private void buttonEnable(boolean enable) {
        this.loadStreetButton.setEnabled(enable);
        this.loadCladrButton.setEnabled(enable);
        this.createIndexButton.setEnabled(enable);
        this.commitStreet.setEnabled(enable);
        this.ignoreStreet.setEnabled(enable);
        this.delStreet.setEnabled(enable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" != evt.getPropertyName()) return;
        int progress = (Integer)evt.getNewValue();
        this.progressMonitor.setProgress(progress);
        if (this.task2 == null) {
            this.progressMonitor.close();
            this.task.cancel(true);
            this.setEnabled(true);
            return;
        } else {
            if (!this.task2.isDone()) return;
            this.progressMonitor.close();
            this.task.cancel(true);
            this.buttonEnable(true);
            try {
                if (!ClientUtils.checkStatus((Document)this.task2.get())) return;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void setLoadTypeEnabled(boolean enabled) {
        this.regionCheck.setEnabled(enabled);
        this.areaCheck.setEnabled(enabled);
        this.areaCheck.setSelected(false);
        this.regionCheck.setSelected(false);
        this.directCheck.setEnabled(enabled);
        this.reverseCheck.setEnabled(enabled);
        this.directCheck.setSelected(true);
        this.ignoreSocr.setEnabled(enabled);
        this.ignoreSocr.setSelected(true);
    }

    private void setLoadEnabled(boolean enabled) {
        this.loadCladrButton.setEnabled(enabled);
        this.loadStreetButton.setEnabled(enabled);
        if (!enabled) {
            this.infoName.setText("");
            this.infoSocr.setText("");
            this.infoCode.setText("");
            this.infoPath.setText("");
            this.setLoadTypeEnabled(false);
        }
    }

    class NoEditTextField
    extends BGTextField {
        public NoEditTextField(int column) {
            super(column);
            Color bgColor = this.getBackground();
            this.setEditable(false);
            this.setBackground(bgColor);
        }
    }
}

