/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean.counter;

import bitel.billing.server.util.Config;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.bill.server.bean.counter.CallCounter;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class DialUpCounter
extends CallCounter {
    @Override
    public BigDecimal count(String function, Connection con, String cid, Calendar month, List<String> paramList) {
        BigDecimal result = BigDecimal.ZERO;
        if (function.equals("SERVICE_AMOUNT")) {
            List<String> allSids = paramList.subList(3, paramList.size());
            int mid = this.getIntParam(paramList, 0);
            Conf conf = (Conf)Setup.getSetup().getConfig(mid, Conf.class);
            ArrayList<String> sids = new ArrayList<String>();
            ArrayList<String> maxSids = new ArrayList<String>();
            for (String sid : allSids) {
                if (conf.maxSids.containsKey(sid)) {
                    maxSids.add(sid);
                    continue;
                }
                sids.add(sid);
            }
            ArrayList<String> params = new ArrayList<String>(paramList.subList(0, 3));
            params.addAll(sids);
            if (sids.size() > 0 || maxSids.size() == 0) {
                result = this.getAmount(con, "session_detail", "amount", params, month, cid);
            }
            int size = maxSids.size();
            for (int i = 0; i < size; ++i) {
                String sid = (String)maxSids.get(i);
                List<String> maxSidsPair = conf.maxSids.get(sid);
                BigDecimal amount = BigDecimal.ZERO;
                int maxSidsSize = maxSidsPair.size();
                for (int j = 0; j < maxSidsSize; ++j) {
                    params = new ArrayList<String>(paramList.subList(0, 3));
                    params.add(maxSidsPair.get(j));
                    amount = amount.max(this.getAmount(con, "session_detail", "amount", params, month, cid));
                }
                result = result.add(amount);
            }
        } else if (function.equals("MAX_SERVICE_AMOUNT")) {
            List<String> sids = paramList.subList(3, paramList.size());
            int mid = this.getIntParam(paramList, 0);
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(mid));
            int size = sids.size();
            for (int i = 0; i < size; ++i) {
                int sid = Utils.parseInt((String)sids.get(0));
                List maxSids = Utils.toList((String)moduleSetup.get("max.traffic." + sid, null));
                BigDecimal amount = BigDecimal.ZERO;
                int maxSidsSize = maxSids.size();
                for (int j = 0; j < maxSidsSize; ++j) {
                    ArrayList<String> params = new ArrayList<String>(paramList.subList(0, 3));
                    params.add((String)maxSids.get(j));
                    amount = amount.max(this.getAmount(con, "session_detail", "amount", params, month, cid));
                }
                result = result.add(amount);
            }
        } else if (function.equals("TARIFF_DETAIL_AMOUNT")) {
            String costTypeIds = this.getIdsFromEnd(3, paramList);
            while (paramList.size() > 3) {
                paramList.remove(paramList.size() - 1);
            }
            result = this.getAmount(con, "tariff_detail", "amount", paramList, month, cid, " cost_type_id IN (" + costTypeIds + ")");
        } else {
            result = super.count(function, con, cid, month, paramList);
        }
        return result;
    }

    private static class Conf
    extends Config {
        public final Map<String, List<String>> maxSids = new HashMap<String, List<String>>();

        public Conf(int mid, ParameterMap moduleSetup, Setup serverSetup) {
            super(mid, moduleSetup, serverSetup);
            for (Map.Entry e : moduleSetup.sub("max.traffic.").entrySet()) {
                this.maxSids.put((String)e.getKey(), Utils.toList((String)((String)e.getValue())));
            }
        }
    }
}

