/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMode;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.assist.server.bean.Constants;
import ru.bitel.bgbilling.modules.assist.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.assist.server.event.worker.AssistAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.assist.server.event.worker.AssistCheckEventWorker;
import ru.bitel.bgbilling.modules.assist.server.service.AssistServiceImpl;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    public static final String MODULE_NAME = "assist";
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), AssistServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.assist.server"};
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        new AssistCheckEventWorker(Setup.getSetup(), module.getId());
        new AssistAutopaymentEventWorker(Setup.getSetup(), module.getId());
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws SQLException {
        ContractDeleteEvent cdEvent;
        if (event instanceof ContractDeleteEvent && !(cdEvent = (ContractDeleteEvent)event).isCheck()) {
            String cidStr = String.valueOf(event.getContractId());
            ServerUtils.deleteRowsFromTable((Connection)ctx.getConnection(), (String)("assist_payment_" + mid), (String)"cid", (String)cidStr, null);
        }
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("assist_payment_" + mid), (String)"cid", (String)String.valueOf(cid), null, (boolean)false, null, null);
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        return this.getPaymentMethods(moduleId, MODULE_NAME, Constants.class);
    }

    public PaymentMode getPaymentMode() {
        return PaymentMode.FORM;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

