/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMap;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class VoiceZoneMapDao
extends AbstractIdDao<VoiceZoneMap> {
    private static final String COST_MAP_TABLE_NAME = "voice_zone_map";

    public VoiceZoneMapDao(Connection con, int moduleId) {
        super(con, moduleId, COST_MAP_TABLE_NAME);
    }

    protected VoiceZoneMap getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceZoneMap result = new VoiceZoneMap();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    protected void updateImpl(VoiceZoneMap b) throws BGException, SQLException {
        String query = b.getId() > 0 ? "UPDATE " + this.tableName + " SET title=?, comment = ? WHERE id=?" : "INSERT INTO " + this.tableName + "( title, comment ) VALUES (?, ? )";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            ps.setString(index++, b.getComment());
            if (b.getId() > 0) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (b.getId() <= 0) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<VoiceZoneMap> list() throws BGException {
        return super.list("", "title", new Object[0]);
    }
}

