/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.task;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountStateModifyEvent;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class TvAccountPeriodTask
extends TaskBase {
    private final Logger logger = LogManager.getLogger();

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c TV. \u0417\u0430\u0434\u0430\u0447\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438/\u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432 \u043f\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0443. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.executeTaskImpl(con);
        }
        catch (BGException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public void executeTaskImpl(Connection con) throws BGException {
        Date now = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(now);
        int yy = calendar.get(1);
        int mm = calendar.get(2) + 1;
        EventProcessor ep = EventProcessor.getInstance();
        try (TvAccountDao tvAccountDao = new TvAccountDao(con, this.moduleId);
             ContractManager contractManager = new ContractManager(con);
             BalanceDao balanceDao = new BalanceDao(con);){
            for (TvAccount tvAccount : tvAccountDao.listToCancel(now)) {
                ep.publish((Event)new OmTvAccountStateModifyEvent(this.moduleId, 0, tvAccount, -1, 0));
            }
            for (TvAccount tvAccount : tvAccountDao.listToCreate(now)) {
                Contract contract = contractManager.getContractById(tvAccount.getContractId());
                short deviceState = 1;
                if (tvAccount.getStatus() != 0) {
                    deviceState = 0;
                } else if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, contract.getStatus())) {
                    deviceState = 0;
                } else {
                    int contractId = contract.isDependSub() ? contract.getSuperId() : contract.getId();
                    BigDecimal balance = balanceDao.getBalance(contractId, yy, mm);
                    if (contract.getBalanceLimit().compareTo(balance) > 0) {
                        deviceState = 0;
                    }
                }
                ep.publish((Event)new OmTvAccountStateModifyEvent(this.moduleId, 0, tvAccount, deviceState, 0));
            }
        }
    }
}

