/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.tv.common.bean.TvServiceSpecChannelLink;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TvServiceSpecChannelLinkDao {
    private final Connection con;
    private final String tableName;

    public TvServiceSpecChannelLinkDao(Connection con, int mid) {
        this.con = con;
        this.tableName = "tv_service_spec_channel_link_" + mid;
    }

    protected TvServiceSpecChannelLink getFromRS(ResultSet rs) throws SQLException, BGException {
        TvServiceSpecChannelLink result = new TvServiceSpecChannelLink();
        result.setId(rs.getInt("id"));
        result.setServiceSpecId(rs.getInt("serviceSpecId"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setChannel(rs.getString("channel"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    public List<TvServiceSpecChannelLink> list(int serviceSpecId, Date date) throws BGException {
        try {
            ArrayList<TvServiceSpecChannelLink> result = new ArrayList<TvServiceSpecChannelLink>();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT * FROM " + this.tableName + " WHERE serviceSpecId=?");
            if (date != null) {
                sb.append(" AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)");
            }
            sb.append(" ORDER BY id");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, serviceSpecId);
            if (date != null) {
                java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
                ps.setDate(2, sqlDate);
                ps.setDate(3, sqlDate);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void update(int serviceSpecId, List<TvServiceSpecChannelLink> linkList) throws BGException {
        try {
            PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (serviceSpecId, deviceId, channel, dateFrom, dateTo) VALUES (?,?,?,?,?)", 1);
            PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceId=?, channel=?, dateFrom=?, dateTo=?, comment=? WHERE id=?");
            HashSet<Integer> ids = new HashSet<Integer>();
            for (TvServiceSpecChannelLink mode : linkList) {
                this.update(serviceSpecId, mode, insertPS, updatePS);
                ids.add(mode.getId());
            }
            ids.add(-1);
            PreparedStatement deletePS = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE serviceSpecId=? AND id NOT IN (" + Utils.toString(ids) + ")");
            deletePS.setInt(1, serviceSpecId);
            deletePS.executeUpdate();
            insertPS.close();
            updatePS.close();
            deletePS.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void update(int serviceSpecId, TvServiceSpecChannelLink link, PreparedStatement insertPS, PreparedStatement updatePS) throws SQLException {
        if (link.getId() > 0) {
            updatePS.setInt(1, link.getDeviceId());
            updatePS.setString(2, link.getChannel());
            updatePS.setDate(3, TimeUtils.convertDateToSqlDate((Date)link.getDateFrom()));
            updatePS.setDate(4, TimeUtils.convertDateToSqlDate((Date)link.getDateTo()));
            updatePS.setString(5, link.getComment());
            updatePS.setInt(6, link.getId());
            if (updatePS.executeUpdate() == 0) {
                link.setId(-1);
            }
        }
        if (link.getId() <= 0) {
            insertPS.setInt(1, serviceSpecId);
            insertPS.setInt(2, link.getDeviceId());
            insertPS.setString(3, link.getChannel());
            insertPS.setDate(4, TimeUtils.convertDateToSqlDate((Date)link.getDateFrom()));
            insertPS.setDate(5, TimeUtils.convertDateToSqlDate((Date)link.getDateTo()));
            insertPS.executeUpdate();
            link.setId(ServerUtils.lastInsertId((PreparedStatement)insertPS));
            link.setServiceSpecId(serviceSpecId);
        }
    }
}

