/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class AddressUtils {
    private static final Logger logger = LogManager.getLogger();
    public static final String ADDRESS_FORMAT = "(${index}, )(${city})(, ${area})(, ${quarter})(, ${street})(, \u0434. ${house})(${frac})(, \u043a\u0432. ${flat})( ${room})(, ${pod} \u043f\u043e\u0434.)(, ${floor} \u044d\u0442.)";
    private static final Executor executor = WorkerTask.newFixedThreadPool((String)"AddressUpdater", null, null, (int)1, (int)30, (RejectedExecutionHandler)new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    });

    public static void onUpdateAddressCity(Setup setup, int cityId) {
        AddressUtils.onUpdateAddressCity(setup, cityId, null);
    }

    public static void onUpdateAddressCity(Setup setup, final int cityId, final Callable<?> callable) {
        executor.execute(new UpdateAddressInfoThread(setup){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.init();
                    this.cityPS.setInt(1, cityId);
                    ResultSet rs = this.cityPS.executeQuery();
                    if (rs.next()) {
                        AddressStruct addressStruct = AddressStruct.builder().setCity(AddressStruct.toTitle((String)rs.getString(2), (String)rs.getString(1), (String)rs.getString(3))).build();
                        rs.close();
                        String query = "SELECT house.*, param.cid, param.pid, param.flat, param.room, param.pod, param.floor, param.comment as param_comment, param.format_key FROM contract_parameter_type_2 as param LEFT JOIN address_house as house ON house.id=param.hid LEFT JOIN address_street as street ON street.id=house.streetid WHERE street.cityid=?";
                        try (PreparedStatement ps = this.con.prepareStatement(query);){
                            ps.setInt(1, cityId);
                            try (ResultSet rs2 = ps.executeQuery();){
                                while (rs2.next()) {
                                    int pid = rs2.getInt("pid");
                                    int podInt = rs2.getInt("param.pod");
                                    int floorInt = rs2.getInt("floor");
                                    addressStruct.setQuarter(this.getQuarter(rs2.getInt("quarterid")));
                                    addressStruct.setStreet(this.getStreet(rs2.getInt("streetid")));
                                    addressStruct.setArea(this.getArea(rs2.getInt("areaid")));
                                    addressStruct.setIndex(rs2.getString("box_index"));
                                    addressStruct.setHouse(String.valueOf(rs2.getInt("house")));
                                    addressStruct.setFrac(rs2.getString("frac"));
                                    addressStruct.setFlat(rs2.getString("flat"));
                                    addressStruct.setRoom(rs2.getString("room"));
                                    addressStruct.setPod(podInt > 0 ? String.valueOf(podInt) : null);
                                    addressStruct.setFloor(floorInt > 0 ? String.valueOf(floorInt) : null);
                                    addressStruct.setComment(rs2.getString("param_comment"));
                                    this.updatePS.setString(1, AddressUtils.getAddress(this.getAddressFormat(rs2.getString("format_key"), pid), addressStruct));
                                    this.updatePS.setInt(2, rs2.getInt("cid"));
                                    this.updatePS.setInt(3, pid);
                                    this.updatePS.executeUpdate();
                                }
                            }
                        }
                    }
                    this.closePrepareStatements();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection(this.con);
                }
                try {
                    if (callable != null) {
                        callable.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void onUpdateAddressStreet(Setup setup, int streetId) {
        AddressUtils.onUpdateAddressStreet(setup, streetId, null);
    }

    public static void onUpdateAddressStreet(Setup setup, final int streetId, final Callable<?> callable) {
        executor.execute(new UpdateAddressInfoThread(setup){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.init();
                    this.streetPS.setInt(1, streetId);
                    ResultSet rs = this.streetPS.executeQuery();
                    if (rs.next()) {
                        AddressStruct addressStruct = AddressStruct.builder().setStreet(AddressStruct.toTitle((String)rs.getString(2), (String)rs.getString(1), (String)rs.getString(3))).build();
                        rs.close();
                        String query = "SELECT house.*, param.cid, param.pid, param.flat, param.room, param.pod, param.floor, param.comment as param_comment, street.cityid, param.format_key  FROM contract_parameter_type_2 as param LEFT JOIN address_house as house ON house.id=param.hid LEFT JOIN address_street AS street ON house.streetid = street.id WHERE house.streetid=?";
                        PreparedStatement ps = this.con.prepareStatement(query);
                        ps.setInt(1, streetId);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            int pid = rs.getInt("pid");
                            int podInt = rs.getInt("param.pod");
                            int floorInt = rs.getInt("floor");
                            addressStruct.setQuarter(this.getQuarter(rs.getInt("quarterid")));
                            addressStruct.setCity(this.getCity(rs.getInt("street.cityid")));
                            addressStruct.setArea(this.getArea(rs.getInt("areaid")));
                            addressStruct.setIndex(rs.getString("box_index"));
                            addressStruct.setHouse(String.valueOf(rs.getInt("house")));
                            addressStruct.setFrac(rs.getString("frac"));
                            addressStruct.setFlat(rs.getString("flat"));
                            addressStruct.setRoom(rs.getString("room"));
                            addressStruct.setPod(podInt > 0 ? String.valueOf(podInt) : null);
                            addressStruct.setFloor(floorInt > 0 ? String.valueOf(floorInt) : null);
                            addressStruct.setComment(rs.getString("param_comment"));
                            this.updatePS.setString(1, AddressUtils.getAddress(this.getAddressFormat(rs.getString("format_key"), pid), addressStruct));
                            this.updatePS.setInt(2, rs.getInt("cid"));
                            this.updatePS.setInt(3, pid);
                            this.updatePS.executeUpdate();
                        }
                        rs.close();
                        ps.close();
                    }
                    this.closePrepareStatements();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection(this.con);
                }
                try {
                    if (callable != null) {
                        callable.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void onUpdateAddressArea(Setup setup, int areaId) {
        AddressUtils.onUpdateAddressArea(setup, areaId, null);
    }

    public static void onUpdateAddressArea(Setup setup, final int areaId, final Callable<?> callable) {
        executor.execute(new UpdateAddressInfoThread(setup){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.init();
                    this.areaPS.setInt(1, areaId);
                    ResultSet rs = this.areaPS.executeQuery();
                    if (rs.next()) {
                        AddressStruct addressStruct = AddressStruct.builder().setArea(AddressStruct.toTitle((String)rs.getString(2), (String)rs.getString(1), (String)rs.getString(3))).build();
                        rs.close();
                        String query = "SELECT house.*, param.cid, param.pid, param.flat, param.room, param.pod, param.floor, param.comment as param_comment, street.cityid, param.format_key  FROM contract_parameter_type_2 as param LEFT JOIN address_house as house ON house.id=param.hid LEFT JOIN address_street AS street ON house.streetid = street.id WHERE house.areaid=?";
                        PreparedStatement ps = this.con.prepareStatement(query);
                        ps.setInt(1, areaId);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            int pid = rs.getInt("pid");
                            int podInt = rs.getInt("param.pod");
                            int floorInt = rs.getInt("floor");
                            addressStruct.setQuarter(this.getQuarter(rs.getInt("quarterid")));
                            addressStruct.setCity(this.getCity(rs.getInt("street.cityid")));
                            addressStruct.setStreet(this.getStreet(rs.getInt("streetid")));
                            addressStruct.setIndex(rs.getString("box_index"));
                            addressStruct.setHouse(String.valueOf(rs.getInt("house")));
                            addressStruct.setFrac(rs.getString("frac"));
                            addressStruct.setFlat(rs.getString("flat"));
                            addressStruct.setRoom(rs.getString("room"));
                            addressStruct.setPod(podInt > 0 ? String.valueOf(podInt) : null);
                            addressStruct.setFloor(floorInt > 0 ? String.valueOf(floorInt) : null);
                            addressStruct.setComment(rs.getString("param_comment"));
                            this.updatePS.setString(1, AddressUtils.getAddress(this.getAddressFormat(rs.getString("format_key"), pid), addressStruct));
                            this.updatePS.setInt(2, rs.getInt("cid"));
                            this.updatePS.setInt(3, pid);
                            this.updatePS.executeUpdate();
                        }
                        rs.close();
                        ps.close();
                    }
                    this.closePrepareStatements();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection(this.con);
                }
                try {
                    if (callable != null) {
                        callable.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void onUpdateAddressQuarter(Setup setup, int quarterId) {
        AddressUtils.onUpdateAddressQuarter(setup, quarterId, null);
    }

    protected static void onUpdateAddressQuarter(Setup setup, final int quarterId, final Callable<?> callable) {
        executor.execute(new UpdateAddressInfoThread(setup){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.init();
                    this.quarterPS.setInt(1, quarterId);
                    ResultSet rs = this.quarterPS.executeQuery();
                    if (rs.next()) {
                        AddressStruct addressStruct = AddressStruct.builder().setQuarter(AddressStruct.toTitle((String)rs.getString(2), (String)rs.getString(1), (String)rs.getString(3))).build();
                        rs.close();
                        String query = "SELECT house.*, param.cid, param.pid, param.flat, param.room, param.pod, param.floor, param.comment as param_comment,street.cityid, param.format_key FROM contract_parameter_type_2 as param LEFT JOIN address_house as house ON house.id=param.hid LEFT JOIN address_street AS street ON house.streetid = street.id WHERE house.quarterid=? ";
                        PreparedStatement ps = this.con.prepareStatement(query);
                        ps.setInt(1, quarterId);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            int pid = rs.getInt("pid");
                            int podInt = rs.getInt("param.pod");
                            int floorInt = rs.getInt("floor");
                            addressStruct.setCity(this.getCity(rs.getInt("street.cityid")));
                            addressStruct.setArea(this.getArea(rs.getInt("areaid")));
                            addressStruct.setStreet(this.getStreet(rs.getInt("streetid")));
                            addressStruct.setIndex(rs.getString("box_index"));
                            addressStruct.setHouse(String.valueOf(rs.getInt("house")));
                            addressStruct.setFrac(rs.getString("frac"));
                            addressStruct.setFlat(rs.getString("flat"));
                            addressStruct.setRoom(rs.getString("room"));
                            addressStruct.setPod(podInt > 0 ? String.valueOf(podInt) : null);
                            addressStruct.setFloor(floorInt > 0 ? String.valueOf(floorInt) : null);
                            addressStruct.setComment(rs.getString("param_comment"));
                            this.updatePS.setString(1, AddressUtils.getAddress(this.getAddressFormat(rs.getString("format_key"), pid), addressStruct));
                            this.updatePS.setInt(2, rs.getInt("cid"));
                            this.updatePS.setInt(3, pid);
                            this.updatePS.executeUpdate();
                        }
                        rs.close();
                        ps.close();
                    }
                    this.closePrepareStatements();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection(this.con);
                }
                try {
                    if (callable != null) {
                        callable.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void onUpdateHouse(Setup setup, int hid) {
        AddressUtils.onUpdateHouse(setup, hid, null);
    }

    public static void onUpdateHouse(Setup setup, final int hid, final Callable<?> callable) {
        executor.execute(new UpdateAddressInfoThread(setup){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.init();
                    StringBuilder query = new StringBuilder("SELECT house.*, street.cityid FROM address_house as house  LEFT JOIN address_street AS street ON house.streetid = street.id WHERE house.id=").append(hid);
                    AddressStruct addressStruct = null;
                    Statement st = this.con.createStatement();
                    ResultSet rs = st.executeQuery(query.toString());
                    if (rs.next()) {
                        addressStruct = AddressStruct.builder().setCity(this.getCity(rs.getInt("street.cityid"))).setArea(this.getArea(rs.getInt("areaid"))).setQuarter(this.getQuarter(rs.getInt("quarterid"))).setStreet(this.getStreet(rs.getInt("streetid"))).setIndex(rs.getString("box_index")).setHouse(String.valueOf(rs.getInt("house"))).setFrac(rs.getString("frac")).build();
                    }
                    rs.close();
                    st.close();
                    if (addressStruct != null) {
                        query.setLength(0);
                        query.append("SELECT param.cid, param.pid, param.flat, param.room, param.pod, param.floor, param.comment AS param_comment, param.format_key FROM contract_parameter_type_2 AS param WHERE param.hid=").append(hid);
                        st = this.con.createStatement();
                        rs = st.executeQuery(query.toString());
                        while (rs.next()) {
                            int pid = rs.getInt("pid");
                            int podInt = rs.getInt("param.pod");
                            int floorInt = rs.getInt("floor");
                            addressStruct.setFlat(rs.getString("flat"));
                            addressStruct.setRoom(rs.getString("room"));
                            addressStruct.setPod(podInt > 0 ? String.valueOf(podInt) : null);
                            addressStruct.setFloor(floorInt > 0 ? String.valueOf(floorInt) : null);
                            addressStruct.setComment(rs.getString("param_comment"));
                            this.updatePS.setString(1, AddressUtils.getAddress(this.getAddressFormat(rs.getString("format_key"), pid), addressStruct));
                            this.updatePS.setInt(2, rs.getInt("cid"));
                            this.updatePS.setInt(3, pid);
                            this.updatePS.executeUpdate();
                        }
                        this.updatePS.close();
                        rs.close();
                        st.close();
                    }
                    this.closePrepareStatements();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection(this.con);
                }
                try {
                    if (callable != null) {
                        callable.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Deprecated
    public static final String getAddress(Preferences setup, AddressStruct addressStruct) {
        return AddressUtils.getAddress(setup, addressStruct, "default");
    }

    public static final String getAddress(Preferences setup, AddressStruct addressStruct, String formatKey) {
        String addressFormat = setup.get("addrs.format.pattern." + formatKey, setup.get("addrs.format." + formatKey, setup.get("addrs.format", ADDRESS_FORMAT)));
        return AddressUtils.getAddress(addressFormat, addressStruct);
    }

    public static final AddressStruct getAddressStruct(Connection con, int houseId, EntityAttrAddress attrAddress) throws BGException {
        return AddressUtils.getAddressStruct(con, houseId, attrAddress.getFlat(), attrAddress.getRoom(), attrAddress.getPod() < 1 ? "" : String.valueOf(attrAddress.getPod()), String.valueOf(attrAddress.getFloor()), attrAddress.getComment());
    }

    public static final AddressStruct getAddressStruct(Connection con, int houseId, String flat, String room, String pod, String floor, String comment) throws BGException {
        try (HouseDao houseDao = new HouseDao(con);){
            House house = houseDao.get(houseId);
            AddressStruct addressStruct = AddressStruct.builder().setIndex(house.getPostIndex()).setCountry(house.optCountry().map(IdTitle::getTitle).orElse("")).setCity(house.optCity().map(IdTitle::getTitle).orElse("")).setArea((String)house.optArea().map(IdTitle::getTitle).orElse(null)).setQuarter((String)house.optQuarter().map(IdTitle::getTitle).orElse(null)).setStreet(house.optStreet().map(IdTitle::getTitle).orElse("")).setHouse(String.valueOf(house.getHouse())).setFrac(house.getFrac()).setFlat(flat).setRoom(room).setPod(pod).setFloor(floor).setComment(comment).build();
            return addressStruct;
        }
    }

    public static final String getAddress(String _address, AddressStruct addressStruct) {
        if ("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e".equals(addressStruct.getArea()) || "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d".equals(addressStruct.getArea())) {
            addressStruct.setArea(null);
        }
        if ("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e".equals(addressStruct.getQuarter()) || "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d".equals(addressStruct.getQuarter())) {
            addressStruct.setQuarter(null);
        }
        if ("0".equals(addressStruct.getHouse())) {
            addressStruct.setHouse(null);
        }
        ArrayList<String> addressParts = new ArrayList<String>();
        for (String a : _address.split("\\(")) {
            if (a.isEmpty()) continue;
            for (String b : a.split("\\)")) {
                if (b.isEmpty()) continue;
                addressParts.add(b);
            }
        }
        AddressUtils.replaceMacros("index", addressStruct.getIndex(), addressParts);
        AddressUtils.replaceMacros("country", addressStruct.getCountry(), addressParts);
        AddressUtils.replaceMacros("city", addressStruct.getCity(), addressParts);
        AddressUtils.replaceMacros("area", addressStruct.getArea(), addressParts);
        AddressUtils.replaceMacros("quarter", addressStruct.getQuarter(), addressParts);
        AddressUtils.replaceMacros("street", addressStruct.getStreet(), addressParts);
        AddressUtils.replaceMacros("house", addressStruct.getHouse(), addressParts);
        AddressUtils.replaceMacros("frac", addressStruct.getFrac(), addressParts);
        AddressUtils.replaceMacros("flat", addressStruct.getFlat(), addressParts);
        AddressUtils.replaceMacros("room", addressStruct.getRoom(), addressParts);
        AddressUtils.replaceMacros("pod", addressStruct.getPod(), addressParts);
        AddressUtils.replaceMacros("floor", addressStruct.getFloor(), addressParts);
        AddressUtils.replaceMacros("comment", addressStruct.getComment(), addressParts);
        for (Map.Entry entry : addressStruct.getParamMap().entrySet()) {
            AddressUtils.replaceMacros((String)entry.getKey(), (String)entry.getValue(), addressParts);
        }
        return addressParts.stream().collect(Collectors.joining());
    }

    private static void replaceMacros(String key, String value, List<String> addressParts) {
        if (addressParts != null && key != null) {
            for (int index = 0; index < addressParts.size(); ++index) {
                String macros = "${" + key + "}";
                String result = "";
                if (addressParts.get(index).indexOf(macros) <= -1) continue;
                if (Utils.notEmptyString((String)value)) {
                    result = addressParts.get(index).replace(macros, value);
                }
                addressParts.set(index, result);
            }
        }
    }

    public static String getHouseFrac(String value) {
        String result = "";
        if (value != null && !value.isEmpty()) {
            for (int index = 0; index < value.length(); ++index) {
                if (Character.isDigit(value.charAt(index))) continue;
                result = value.substring(index);
                break;
            }
        }
        return result;
    }

    public static String getHouse(String value) {
        StringBuilder buf = new StringBuilder("");
        if (value != null && !value.isEmpty()) {
            char ch;
            for (int index = 0; index < value.length() && Character.isDigit(ch = value.charAt(index)); ++index) {
                buf.append(ch);
            }
        }
        return buf.toString();
    }

    public static void importHouseData(Connection con, String table, int id, String data) throws BGException, BGMessageException {
        try (PreparedStatement psSelect = con.prepareStatement("SELECT COUNT(*) FROM " + table + " WHERE streetid=? AND house=? AND frac=?");
             PreparedStatement psInsert = con.prepareStatement("INSERT INTO " + table + " SET streetid=?, house=?, frac=?");){
            psSelect.setInt(1, id);
            psInsert.setInt(1, id);
            for (String a : data.split("\n")) {
                Object house = "";
                Object frac = "";
                boolean digit = true;
                for (char ch : a.toCharArray()) {
                    if (digit && Character.isDigit(ch)) {
                        house = (String)house + ch;
                        continue;
                    }
                    digit = false;
                    frac = (String)frac + ch;
                }
                psSelect.setString(2, (String)house);
                psSelect.setString(3, (String)frac);
                boolean insert = false;
                try (ResultSet resultSet = psSelect.executeQuery();){
                    while (resultSet.next()) {
                        insert = resultSet.getInt(1) == 0;
                    }
                }
                if (!insert) continue;
                psInsert.setString(2, (String)house);
                psInsert.setString(3, (String)frac);
                psInsert.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public static void importData(Connection con, String table, String parentName, int id, String data) throws BGException, BGMessageException {
        try (PreparedStatement psSelect = con.prepareStatement("SELECT COUNT(*) FROM " + table + " WHERE title=?");
             PreparedStatement psInsert = con.prepareStatement("INSERT INTO " + table + " SET title=?, " + parentName + "=?");){
            psInsert.setInt(2, id);
            for (String a : data.split("\n")) {
                psSelect.setString(1, a);
                boolean insert = false;
                ResultSet resultSet = psSelect.executeQuery();
                while (resultSet.next()) {
                    insert = resultSet.getInt(1) == 0;
                }
                resultSet.close();
                if (!insert) continue;
                psInsert.setString(1, a);
                psInsert.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private static abstract class UpdateAddressInfoThread
    implements Runnable {
        private final HashMap<Integer, String> cityes = new HashMap();
        private final HashMap<Integer, String> streets = new HashMap();
        private final HashMap<Integer, String> quarters = new HashMap();
        private final HashMap<Integer, String> areas = new HashMap();
        protected final Setup setup;
        protected Connection con;
        protected PreparedStatement streetPS;
        protected PreparedStatement quarterPS;
        protected PreparedStatement areaPS;
        protected PreparedStatement cityPS;
        protected PreparedStatement updatePS;

        public UpdateAddressInfoThread(Setup setup) {
            this.setup = setup;
        }

        protected void init() {
            this.con = this.setup.getDBConnectionFromPool();
            try {
                this.streetPS = this.con.prepareStatement("SELECT title, title_prefix, title_suffix FROM address_street WHERE id=?");
                this.quarterPS = this.con.prepareStatement("SELECT title, title_prefix, title_suffix FROM address_quarter WHERE id=?");
                this.areaPS = this.con.prepareStatement("SELECT title, title_prefix, title_suffix FROM address_area WHERE id=?");
                this.cityPS = this.con.prepareStatement("SELECT title, title_prefix, title_suffix FROM address_city WHERE id=?");
                this.updatePS = this.con.prepareStatement("UPDATE contract_parameter_type_2 SET address=? WHERE cid=? AND pid=?");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }

        protected final String getCity(int id) throws SQLException {
            return this.getCityItem(id, this.cityes, this.cityPS);
        }

        protected final String getStreet(int id) throws SQLException {
            return this.getCityItem(id, this.streets, this.streetPS);
        }

        protected final String getQuarter(int id) throws SQLException {
            return this.getCityItem(id, this.quarters, this.quarterPS);
        }

        protected final String getArea(int id) throws SQLException {
            return this.getCityItem(id, this.areas, this.areaPS);
        }

        private final String getCityItem(int id, Map<Integer, String> items, PreparedStatement ps) throws SQLException {
            String result = items.get(id);
            if (result == null) {
                ps.setInt(1, id);
                try (ResultSet rs2 = ps.executeQuery();){
                    if (rs2.next()) {
                        result = AddressStruct.toTitle((String)rs2.getString(2), (String)rs2.getString(1), (String)rs2.getString(3));
                        items.put(id, result);
                    }
                }
            }
            return result;
        }

        protected final String getAddressFormat(String keyPrefix, int parameterId) {
            return this.setup.get("addrs.format.pattern." + keyPrefix + parameterId, this.setup.get("addrs.format." + keyPrefix + parameterId, this.setup.get("addrs.format", AddressUtils.ADDRESS_FORMAT)));
        }

        protected void closePrepareStatements() throws SQLException {
            this.streetPS.close();
            this.quarterPS.close();
            this.areaPS.close();
            this.cityPS.close();
            this.updatePS.close();
        }
    }
}

