/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.server.bean;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.kernel.admin.license.server.bean.FL;
import ru.bitel.bgbilling.kernel.admin.license.server.bean.ModuleFL;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public final class Temp {
    private static Temp temp = null;
    private boolean keysOK = true;
    private String firmName;
    private String licenseNumber;
    private String licenseVersion;
    private Map<String, ModuleFL> modulesLicenses = new HashMap<String, ModuleFL>();
    private Map<String, Integer> modulesContractCount = new HashMap<String, Integer>();

    public static Temp getTemp() {
        if (temp == null) {
            temp = new Temp();
        }
        return temp;
    }

    private Temp() {
        this.init();
    }

    public void init() {
        Setup setup = Temp.class.getResource(Utils.swapWords((String)"d/ta/ail.crpporeitse")) != null ? new Preferences(Utils.swapWords((String)"adatl.ci")) : Setup.getSetup();
        String rsaPrvKeyNew = "30 82 01 37 02 01 00 30 0D 06 09 2A 86 48 86 F7 0D 01 01 01 05 00 04 82 01 21 30 82 01 1D 02 01 00 02 81 81 00 8F 17 55 15 22 AB DB 96 73 D5 AE 1A E7 63 CE 02 D2 10 89 8E 0F 89 6C DB 7D CA C4 30 A2 D4 6D 07 C1 2B BB 36 CD 27 44 CE B5 BF 69 D2 33 4A 9D 5C 33 1A C6 AA 2C DC 87 93 21 51 13 71 6C 1D 3B 80 D9 06 AE 1F AB 0C 63 5E A1 77 AF 14 2B C9 9F 70 19 E9 A0 AB FB 62 A2 11 64 D6 FE 80 76 29 E7 D8 8E B3 6A B3 E7 43 93 96 5D 47 4E F9 61 13 71 07 40 F3 E0 FE 80 48 65 55 22 09 54 72 C1 D0 80 F5 02 01 00 02 81 81 00 8C AC 06 84 31 C2 BC AD 2B 91 9D 89 6B 83 CD EB 2D F2 FE 18 40 23 FD 75 C7 34 09 2E 3B 56 15 1E 33 85 37 97 07 97 1C 69 0F 7A 6F A1 2B B5 A6 00 17 69 B2 77 68 85 21 6F BE A8 43 32 15 74 A3 A2 65 42 BC D5 16 40 0C F9 E6 E4 81 59 25 06 48 D1 2B 4A 53 F1 2D F9 19 18 A1 70 53 18 7D 15 03 3A 68 B9 F3 5B 91 84 6A 0A 2F 26 3F 7E B7 EF AE B0 16 54 D7 D0 86 22 3F E7 6F 05 CF 05 79 2C 4C 3D 02 01 00 02 01 00 02 01 00 02 01 00 02 01 00";
        String licence = null;
        try {
            PKCS8EncodedKeySpec ksKeySpecPKCS8 = new PKCS8EncodedKeySpec(Utils.hexStringToBytes((String)rsaPrvKeyNew));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(ksKeySpecPKCS8);
            licence = setup.get("lic.kernel", null);
            if (licence != null) {
                BigInteger decryptedLic = Temp.decrypt(privateKey, new BigInteger(Utils.hexStringToBytes((String)licence)));
                if ((licence = new String(decryptedLic.toByteArray(), "Cp1251")).startsWith("bgbilling_kernel")) {
                    StringTokenizer st = new StringTokenizer(licence, "_");
                    st.nextToken();
                    st.nextToken();
                    this.licenseNumber = st.nextToken();
                    this.licenseVersion = st.nextToken();
                    this.firmName = st.nextToken();
                }
                HashSet<String> _modulesLicenseNumbers = new HashSet<String>();
                HashMap<String, ModuleFL> modulesLicenses = new HashMap<String, ModuleFL>();
                ParameterMap pairs = setup.sub("licence");
                for (Map.Entry licenceEntry : pairs.entrySet()) {
                    String licenceNum;
                    decryptedLic = Temp.decrypt(privateKey, new BigInteger(Utils.hexStringToBytes((String)((String)licenceEntry.getValue()))));
                    String licenceID = new String(decryptedLic.toByteArray(), "Cp1251");
                    if (licenceID == null || !licenceID.startsWith("bgbilling")) continue;
                    StringTokenizer st = new StringTokenizer(licenceID, "_");
                    st.nextToken();
                    if (!st.nextToken().equals("module") || _modulesLicenseNumbers.contains(licenceNum = st.nextToken())) continue;
                    _modulesLicenseNumbers.add(licenceNum);
                    String kernelLicenseNumber = st.nextToken();
                    if (!this.licenseNumber.equals(kernelLicenseNumber)) continue;
                    String moduleName = st.nextToken();
                    String contractCount = st.nextToken();
                    LocalDate toDate = LocalDate.parse(st.nextToken(), DateTimeFormatter.ofPattern("dd.MM.yyyy"));
                    ModuleFL moduleLic = (ModuleFL)modulesLicenses.get(moduleName);
                    if (moduleLic == null) {
                        moduleLic = new ModuleFL();
                        modulesLicenses.put(moduleName, moduleLic);
                    }
                    moduleLic.addLicense(new FL(toDate, Utils.parseInt((String)contractCount, (int)0)));
                }
                this.modulesLicenses = modulesLicenses;
                this.modulesContractCount = new HashMap<String, Integer>();
            }
        }
        catch (Exception ex) {
            this.keysOK = false;
        }
        this.keysOK = this.licenseNumber != null && this.licenseVersion != null && this.licenseVersion.equals("3.5") && this.keysOK;
    }

    public static final BigInteger decrypt(RSAPrivateKey privateKey, BigInteger input) throws Exception {
        BigInteger n = privateKey.getModulus();
        if (input.compareTo(BigInteger.ZERO) < 0 || input.compareTo(n.subtract(BigInteger.ONE)) > 0) {
            throw new IllegalArgumentException("representative out of range");
        }
        if (privateKey instanceof RSAPrivateCrtKey) {
            throw new IllegalArgumentException("privateKey is RSAPrivateCrtKey");
        }
        BigInteger d = privateKey.getPrivateExponent();
        BigInteger result = input.modPow(d, n);
        return result;
    }

    public String getFirmTitle() {
        return this.firmName;
    }

    private int countContractsForModule(Connection con, String moduleName, boolean refresh) throws SQLException {
        if (refresh) {
            StringBuffer query = new StringBuffer(Utils.swapWords((String)"ESELTCC UOTNc(di )RFMOc nortca_tomudel") + " ");
            query.append(Utils.swapWords((String)"ELTFJ IO NomudelO  Nomudeli. d =octnartcm_dolu.eimd") + " ");
            query.append(Utils.swapWords((String)"ELTFJ IO NoctnartcO  Noctnartci. d =octnartcm_dolu.eicd") + " ");
            query.append(Utils.swapWords((String)"HWRE Eomudeln.ma e =?") + " ");
            query.append(Utils.swapWords((String)"na dc(nortca.tadet 1sin lu lroc nortca.tadet 1<  =on(w ))") + " ");
            query.append(Utils.swapWords((String)"na dc(nortca.tadet 2sin lu lroc nortca.tadet 2=>n wo)() ") + " ");
            try (PreparedStatement ps = con.prepareStatement(query.toString());){
                ps.setString(1, moduleName);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        this.modulesContractCount.put(moduleName, rs.getInt(1));
                    }
                }
            }
        }
        int result = 0;
        Integer resultInteger = this.modulesContractCount.get(moduleName);
        if (resultInteger != null) {
            result = resultInteger;
        }
        return result;
    }

    public List<String> getMName() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.modulesLicenses.keySet());
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return list;
    }

    public int getMMaxContract(String moduleName) {
        return Optional.ofNullable(this.modulesLicenses.get(moduleName)).map(a -> a.getCompetentContractCount()).orElse(0);
    }

    public int getMCurrContract(String moduleName) {
        int contractCount = 0;
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            contractCount = this.countContractsForModule(con, moduleName, true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return contractCount;
    }

    public LocalDate getMDateAvail(String moduleName) {
        return Optional.ofNullable(this.modulesLicenses.get(moduleName)).map(a -> a.getAvailDate()).orElse(LocalDate.now());
    }
}

