/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import bitel.billing.server.contract.object.bean.ListValueManager;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamAddressValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamDateValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamFlagValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamTextValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamValue;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ParamManager;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ParamTypeManager;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ParamValueManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ObjectManager {
    private static final String TABLE_NAME = "object";
    private Connection con;

    public ObjectManager(Connection con) {
        this.con = con;
    }

    public ContractObject getObject(int id) {
        ContractObject result = null;
        String query = "SELECT * FROM object WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getObjectFromRs(rs);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ContractObject> getObjectList(int contractId) throws BGException {
        ArrayList<ContractObject> result = new ArrayList<ContractObject>();
        String query = "SELECT * FROM object WHERE cid=? ORDER BY pos";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getObjectFromRs(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<ContractObject> getActiveObjectList(int cid) {
        ArrayList<ContractObject> result = new ArrayList<ContractObject>();
        try {
            String query = "SELECT * FROM object WHERE cid=? AND ( date1<=NOW() OR date1 IS NULL ) AND ( isNULL(date2) OR date2 > NOW() ) ORDER BY pos";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getObjectFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ContractObject> getSuperObjectList(int cid, boolean showAll) {
        ArrayList<ContractObject> result = new ArrayList<ContractObject>();
        String query = null;
        query = showAll ? "SELECT o.* FROM object o, contract c WHERE (o.cid=c.id OR (o.cid=c.scid AND c.scid!=0 AND c.scid!=-1) ) AND c.id=? ORDER BY o.pos" : "SELECT o.* FROM object o, contract c WHERE (o.cid=c.id OR (o.cid=c.scid AND c.scid!=0 AND c.scid!=-1)) AND c.id=? AND (o.date1<=NOW() OR o.date1 IS NULL) AND (isNULL(o.date2) OR o.date2 > NOW()) ORDER BY o.pos";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getObjectFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteObject(int id) throws BGException {
        String query = "DELETE FROM object WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateObject(ContractObject value) throws BGException {
        PreparedStatement ps;
        boolean update = value.getId() > 0;
        Object query = (update ? "UPDATE " : "INSERT INTO ") + "object SET title=?, date1=?, date2=?" + (update ? " WHERE id=?" : ", cid=?, type_id=?");
        try {
            ps = this.con.prepareStatement((String)query, 1);
            try {
                int index = 1;
                ps.setString(index++, value.getTitle());
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)value.getDateFrom()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)value.getDateTo()));
                if (update) {
                    ps.setInt(index++, value.getId());
                } else {
                    ps.setInt(index++, value.getContractId());
                    ps.setInt(index++, value.getTypeId());
                }
                ps.executeUpdate();
                if (!update) {
                    value.setId(ServerUtils.lastInsertId(ps));
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        if (!update) {
            query = "UPDATE object SET pos=? WHERE id=?";
            try {
                ps = this.con.prepareStatement((String)query);
                try {
                    ps.setInt(1, value.getId());
                    ps.setInt(2, value.getId());
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void moveObject(int id, int cidTo) {
        try {
            String query = "UPDATE object SET cid=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cidTo);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ContractObject getObjectFromRs(ResultSet rs) throws SQLException {
        ContractObject result = new ContractObject();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setStatus(rs.getInt("status"));
        result.setTitle(rs.getString("title"));
        result.setTypeId(rs.getInt("type_id"));
        result.setDateFrom(rs.getDate("date1"));
        result.setDateTo(rs.getDate("date2"));
        result.setPosition(rs.getInt("pos"));
        return result;
    }

    public static void addObjectParams(Connection con, int objectId, XMLStreamWriter table, ObjectType type) throws Exception {
        Map<Integer, ListValue> listValuesMap = new ListValueManager(con).getValuesMap();
        Map<Integer, ObjectParam> paramMap = new ParamManager(con).getParamMap();
        List<ParamType> typeParamList = new ParamTypeManager(con).getTypeParamList(type.getId());
        Map<Integer, ParamValue> valuesMap = new ParamValueManager(con).getObjectParamMap(objectId);
        for (ParamType typeParam : typeParamList) {
            ParamValue value;
            ObjectParam objectParam = paramMap.get(typeParam.getParamId());
            if (objectParam == null || (value = valuesMap.get(objectParam.getId())) == null) continue;
            table.writeStartElement("row");
            table.writeAttribute("param_id", String.valueOf(objectParam.getId()));
            table.writeAttribute("type_id", String.valueOf(objectParam.getTypeId()));
            table.writeAttribute("title", objectParam.getTitle());
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)objectParam.getTypeId()).get()) {
                case TEXT: {
                    table.writeAttribute("value", ((ParamTextValue)value).getValue());
                    break;
                }
                case BOOLEAN: {
                    table.writeAttribute("value", String.valueOf(((ParamFlagValue)value).getValue()));
                    break;
                }
                case ADDRESS: {
                    table.writeAttribute("value", ((ParamAddressValue)value).getAddress());
                    break;
                }
                case DATE: {
                    table.writeAttribute("value", TimeUtils.formatDate((Calendar)((ParamDateValue)value).getValue()));
                    break;
                }
                case LIST: {
                    ListValue listValue = listValuesMap.get(((ParamListValue)value).getValue());
                    if (listValue != null) {
                        table.writeAttribute("value", listValue.getTitle());
                        break;
                    }
                    table.writeAttribute("value", "???");
                    break;
                }
            }
            table.writeEndElement();
        }
    }

    public String getObjectParamTitle(int objectId, int paramId) throws Exception {
        ContractObject object = new ObjectManager(this.con).getObject(objectId);
        ObjectParam objectParam = new ParamManager(this.con).getParameter(paramId);
        Map<Integer, ParamValue> valuesMap = new ParamValueManager(this.con).getObjectParamMap(objectId);
        ParamValue value = valuesMap.get(paramId);
        if (object != null && objectParam != null && value != null) {
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)objectParam.getTypeId()).get()) {
                case TEXT: {
                    return ((ParamTextValue)value).getValue();
                }
                case BOOLEAN: {
                    return String.valueOf(((ParamFlagValue)value).getValue());
                }
                case ADDRESS: {
                    return ((ParamAddressValue)value).getAddress();
                }
                case DATE: {
                    return TimeUtils.formatDate((Calendar)((ParamDateValue)value).getValue());
                }
                case LIST: {
                    Map<Integer, ListValue> listValuesMap = new ListValueManager(this.con).getValuesMap();
                    ListValue listValue = listValuesMap.get(((ParamListValue)value).getValue());
                    if (listValue != null) {
                        return listValue.getTitle();
                    }
                    return "???";
                }
            }
        }
        return null;
    }

    public void saveTitleByMacros(ContractObject object) throws Exception {
        String generateTitle = this.generateTitle(object);
        if (!object.getTitle().equals(generateTitle)) {
            object.setTitle(generateTitle);
            this.updateObject(object);
        }
    }

    public String generateTitle(ContractObject object) throws Exception {
        String title = object.getTitle();
        ObjectType type = new ObjectTypeManager(this.con).getType(object.getTypeId());
        if (type == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
        }
        String macros = type.getNameMakros();
        if (Utils.isBlankString((String)macros)) {
            return title;
        }
        Pattern pattern = Pattern.compile("\\$\\{([\\w:]+)\\}");
        Matcher m = pattern.matcher(macros);
        StringBuffer result = new StringBuffer();
        int end = 0;
        while (m.find()) {
            int start = m.start();
            result.append(macros.substring(end, start));
            result.append(this.processMacros(m.group(1), type, object));
            end = m.end();
        }
        result.append(macros.substring(end, macros.length()));
        title = result.toString();
        return title;
    }

    private String processMacros(String macros, ObjectType type, ContractObject object) throws Exception {
        String result = "";
        ParamValueManager valueManager = new ParamValueManager(this.con);
        try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.con, 0);){
            if (macros.equals("type")) {
                result = type.getTitle();
            } else if (macros.equals("id")) {
                result = String.valueOf(object.getId());
            } else if (macros.startsWith("address:")) {
                ParamAddressValue value = valueManager.getAddressParamValue(object.getId(), this.getParamId(macros));
                if (value != null) {
                    result = value.getAddress();
                }
            } else if (macros.startsWith("date:")) {
                result = contractObjectDao.optObjectParameterDateAsDate(object.getId(), this.getParamId(macros)).map(a -> TimeUtils.formatDate((Date)a)).orElse(result);
            } else if (macros.startsWith("text:")) {
                result = contractObjectDao.optObjectParameterTextAsString(object.getId(), this.getParamId(macros)).orElse(result);
            } else if (macros.startsWith("list:")) {
                result = contractObjectDao.optObjectParameterListAsString(object.getId(), this.getParamId(macros)).orElse(result);
            }
        }
        return result;
    }

    private int getParamId(String str) {
        int result = 0;
        int pos = str.indexOf(58);
        if (pos > 0 && pos < str.length() - 1) {
            result = Utils.parseInt((String)str.substring(pos + 1), (int)0);
        }
        return result;
    }
}

