/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGCalendarWithTimeButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JPanel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class BGControlPanelDateWithTime
extends JPanel {
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private BGCalendarWithTimeButton dateButton = new BGCalendarWithTimeButton();

    public BGControlPanelDateWithTime() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dateButton.addPropertyChangeListener("updateCalendar", evt -> {
            this.firePropertyChange("updateCalendar", evt.getOldValue(), evt.getNewValue());
            this.fireActionEvent();
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dateButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public LocalDateTime getLocalDateTime() {
        Calendar calendar = this.dateButton.getCalendar();
        return calendar == null ? null : TimeUtils.convertDateToLocalDateTime(calendar.getTime());
    }

    public Date getDate() {
        Calendar calendar = this.dateButton.getCalendar();
        return calendar == null ? null : calendar.getTime();
    }

    public void setLocalDateTime(LocalDateTime date) {
        String oldValue = this.dateButton.getText();
        GregorianCalendar calendar = null;
        if (date != null) {
            calendar = new GregorianCalendar();
            calendar.setTime(TimeUtils.convertLocalDateTimeToDate(date));
        }
        this.dateButton.setCalendar(calendar);
        this.firePropertyChange("date", oldValue, this.dateButton.getText());
    }

    public void setDate(Date date) {
        String oldValue = this.dateButton.getText();
        GregorianCalendar calendar = null;
        if (date != null) {
            calendar = new GregorianCalendar();
            calendar.setTime(date);
        }
        this.dateButton.setCalendar(calendar);
        this.firePropertyChange("date", oldValue, this.dateButton.getText());
    }

    public Calendar getDateCalendar() {
        return this.dateButton.getCalendar();
    }

    public void setDateCalendar(Calendar dateCalendar) {
        String oldValue = this.dateButton.getText();
        this.dateButton.setCalendar(dateCalendar);
        this.firePropertyChange("date", oldValue, this.dateButton.getText());
    }

    public void setDateString(String dateString) {
        if (!Utils.notBlankString(dateString) || "00.00.0000 00:00".equals(dateString)) {
            dateString = null;
        }
        String oldValue = this.dateButton.getText();
        this.dateButton.setText(dateString);
        this.firePropertyChange("date", oldValue, this.dateButton.getText());
    }

    public String getDateString() {
        return this.dateButton.getText().trim();
    }

    private void fireActionEvent() {
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "date_changed"));
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }
}

