/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.ipn.common.bean.RuleTypeLog;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleTypeLogManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.common.Utils;

public class UserGateRuleManager {
    private Connection con;
    private int mid = -1;

    public UserGateRuleManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public List<UserGateRule> getUserGateRules(int cid) throws SQLException {
        ArrayList<UserGateRule> result = new ArrayList<UserGateRule>(5);
        String query = null;
        PreparedStatement ps = null;
        query = "SELECT user_gate.* FROM ipn_user_gate_" + this.mid + " as user_gate  LEFT JOIN ipn_gate_" + this.mid + " as gate ON gate.id = user_gate.fwid  WHERE user_gate.cid=? ORDER BY gate.host, gate.port ";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            UserGateRule rule = new UserGateRule();
            result.add(rule);
            this.loadFromResultSet(rs, rule);
        }
        ps.close();
        return result;
    }

    public List<UserGateRule> getUserGateRulesForGate(int gid) {
        ArrayList<UserGateRule> result = new ArrayList<UserGateRule>(5);
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_user_gate_" + this.mid + " WHERE fwid=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, gid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                UserGateRule rule = new UserGateRule();
                result.add(rule);
                this.loadFromResultSet(rs, rule);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public UserGateRule getUserGateRule(int gid, int cid) {
        UserGateRule result = null;
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_user_gate_" + this.mid + " WHERE fwid=? AND cid=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, gid);
            ps.setInt(2, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new UserGateRule();
                this.loadFromResultSet(rs, result);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public UserGateRule getUserGateRule(int id) {
        UserGateRule result = null;
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT * FROM ipn_user_gate_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new UserGateRule();
                this.loadFromResultSet(rs, result);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updateUserGateRule(String id, UserGateRule ugr) {
        this.updateUserGateRule(id, ugr, 0);
    }

    public void updateUserGateRule(String id, UserGateRule ugr, int userId) {
        String query = null;
        PreparedStatement ps = null;
        UserGateRule old = null;
        try {
            if ("new".equals(id) || "0".equals(id)) {
                query = "DELETE FROM ipn_user_gate_" + this.mid + " WHERE cid=? and fwid=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, ugr.getContractId());
                ps.setInt(2, ugr.getGateId());
                ps.executeUpdate();
                ps.close();
                query = "INSERT INTO ipn_user_gate_" + this.mid + " ( cid, fwid, rule_txt, rtid ) VALUES ( ?, ?, ?, ? )";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, ugr.getContractId());
                ps.setInt(2, ugr.getGateId());
                ps.setString(3, ugr.getRuleText());
                ps.setInt(4, ugr.getRuleTypeId());
                ps.executeUpdate();
                ps.close();
            } else {
                old = this.getUserGateRule(Utils.parseInt((String)id, (int)-1));
                query = "UPDATE ipn_user_gate_" + this.mid + " SET rule_txt=?, rtid=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setString(1, ugr.getRuleText());
                ps.setInt(2, ugr.getRuleTypeId());
                ps.setInt(3, Utils.parseInt((String)id, (int)-1));
                ps.executeUpdate();
                ps.close();
            }
            if (old == null || old.getRuleTypeId() != ugr.getRuleTypeId()) {
                RuleTypeLogManager man = new RuleTypeLogManager(this.con, this.mid);
                RuleTypeLog log = new RuleTypeLog();
                log.setTypeId(ugr.getRuleTypeId());
                log.setUserId(userId);
                log.setDate(new Date());
                log.setGateId(ugr.getGateId());
                log.setContractId(ugr.getContractId());
                log.setUserId(userId);
                man.addLog(log);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadFromResultSet(ResultSet rs, UserGateRule rule) throws SQLException {
        rule.setId(rs.getInt("id"));
        rule.setContractId(rs.getInt("cid"));
        rule.setGateId(rs.getInt("fwid"));
        rule.setRuleText(rs.getString("rule_txt"));
        rule.setRuleTypeId(rs.getInt("rtid"));
    }

    public void deleteUserGateRule(int id) {
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "DELETE FROM ipn_user_gate_" + this.mid + " WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<String> getGateContracts(int gid) {
        ArrayList<String> result = new ArrayList<String>();
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "SELECT contract.title FROM ipn_user_gate_" + this.mid + " AS gate LEFT JOIN contract ON contract.id = gate.cid WHERE gate.fwid = " + gid;
            ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getString("title"));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

