/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff;

import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class InetOptionAddTariffTreeNode
extends TariffTreeNode<InetTariffRequest, InetTariffContext, TreeContext, InetTariffWorkerContext> {
    private final Integer inetOptionId;
    private final int tariffVarId;
    private final String inetOptionMode;

    public InetOptionAddTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.inetOptionMode = parameterMap.get("inetOptionMode", "const");
        this.inetOptionId = parameterMap.getInt("inetOptionId", 0);
        this.tariffVarId = parameterMap.getInt("tariffVarId", 0);
    }

    protected final int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest inetTariffRequest, InetTariffContext inetTariffContext, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        InetOptionRuntime optionRuntime;
        this.logger.debug("InetOptionAddTariffTreeNode: inetOptionMode={}, inetOptionId={}, tariffVarId={}", (Object)this.inetOptionMode, (Object)this.inetOptionId, (Object)this.tariffVarId);
        int optionId = this.inetOptionId;
        if ("var".equals(this.inetOptionMode)) {
            ContractTariffVar contractTariffVar = inetTariffRequest.getContractTariffVar(this.tariffVarId);
            if (contractTariffVar != null) {
                String value = contractTariffVar.getValue();
                if (value == null) {
                    value = contractTariffVar.getDefaultValue();
                }
                optionId = Utils.parseInt((String)value.replaceAll("^(\\d+):.*", "$1"));
            }
            this.logger.debug("InetOptionAddTariffTreeNode: contractTariffVar={}, optionId={}", (Object)contractTariffVar, (Object)optionId);
        }
        if (optionId > 0 && (optionRuntime = inetTariffContext.inetOptionRuntimeMap.get(optionId)) != null) {
            if (optionRuntime.replaceIds != null) {
                inetTariffRequest.inetOptionSet.removeAll(optionRuntime.replaceIds);
            }
            inetTariffRequest.inetOptionSet.add(optionId);
        }
        return 1;
    }

    protected final int postExecuteImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest inetTariffRequest, InetTariffContext inetTariffContext, TreeContext treeContext, InetTariffWorkerContext workerContext, int executeResult) {
        return executeResult;
    }
}

