/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.device;

import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetAbstractDhcpProcessor;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpProcessor;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.io.BinaryValueExtractor;

public class PacketValueExtractor {
    private static final Logger logger = LogManager.getLogger();
    private static final BinaryValueExtractor.BinaryValueExtractorFactory EXTRACTOR_FACTORY = new BinaryValueExtractor.BinaryValueExtractorFactory();
    private final byte option82InterfaceIdCode;
    private final BinaryValueExtractor option82InterfaceIdExtractor;
    private final int option82InterfaceIdPosition;
    private final int option82InterfaceIdLength;
    private final byte option82VlanIdCode;
    private final BinaryValueExtractor option82VlanIdExtractor;
    private final int option82VlanIdPosition;
    private final int option82VlanIdLength;
    private final byte option82SvlanIdCode;
    private final BinaryValueExtractor option82SvlanIdExtractor;
    private final int option82SvlanIdPosition;
    private final int option82SvlanIdLength;
    final byte option82RemoteIdCode;
    private final BinaryValueExtractor option82RemoteIdExtractor;
    private final int option82RemoteIdPosition;
    private final int option82RemoteIdLength;
    private final int option82RemoteIdType;
    private final byte option82LoginCode;
    private final BinaryValueExtractor option82LoginExtractor;
    protected int option82RemoveHeader;
    private final int radiusAgentRemoteIdVendor;
    private final int radiusAgentRemoteIdType;
    private final String radiusAgentRemoteIdPrefix;
    private Pattern radiusAgentRemoteIdPattern;
    private final BinaryValueExtractor radiusAgentRemoteIdExtractor;
    private final int radiusCircuitIdVendor;
    private final int radiusCircuitIdType;
    private final String radiusCircuitIdPrefix;
    private Pattern radiusCircuitIdPattern;
    private final BinaryValueExtractor radiusCircuitIdExtractor;
    protected int macAddressVendor;
    protected int macAddressType;
    protected String macAddressPrefix;
    protected Pattern macAddressPattern;
    protected int callingStationIdVendor;
    protected int callingStationIdType;
    protected String callingStationIdPrefix;
    protected int calledStationIdVendor;
    protected int calledStationIdType;
    protected String calledStationIdPrefix;
    protected int vlanVendor;
    protected int vlanType;
    protected String vlanPrefix;
    protected Pattern vlanPattern;
    protected int agentSvlanVendor;
    protected int agentSvlanType;
    protected String agentSvlanPrefix;
    protected Pattern agentSvlanPattern;

    public PacketValueExtractor(ParameterMap config) {
        String pattern;
        this.option82VlanIdCode = (byte)config.getInt("dhcp.option82.vlanId.code", config.getInt("dhcp.82.vlanOptionCode", 1));
        this.option82VlanIdExtractor = EXTRACTOR_FACTORY.getExtractor(config, "dhcp.option82.vlanId.");
        this.option82VlanIdPosition = config.getInt("dhcp.option82.vlanId.position", config.getInt("dhcp.82.vlanPosition", 2));
        this.option82VlanIdLength = config.getInt("dhcp.option82.vlanId.length", 2);
        this.option82SvlanIdCode = (byte)config.getInt("dhcp.option82.agentSvlanId.code", 1);
        this.option82SvlanIdExtractor = EXTRACTOR_FACTORY.getExtractor(config, "dhcp.option82.agentSvlanId.");
        this.option82SvlanIdPosition = config.getInt("dhcp.option82.agentSvlanId.position", -1);
        this.option82SvlanIdLength = config.getInt("dhcp.option82.agentSvlanId.length", 2);
        this.option82InterfaceIdCode = (byte)config.getInt("dhcp.option82.interfaceId.code", config.getInt("dhcp.82.interfaceOptionCode", 1));
        this.option82InterfaceIdExtractor = EXTRACTOR_FACTORY.getExtractor(config, "dhcp.option82.interfaceId.");
        this.option82InterfaceIdPosition = config.getInt("dhcp.option82.interfaceId.position", config.getInt("dhcp.82.interfacePosition", 5));
        this.option82InterfaceIdLength = config.getInt("dhcp.option82.interfaceId.length", config.getInt("dhcp.82.interfaceId.length", 1));
        this.option82RemoteIdCode = (byte)config.getInt("dhcp.option82.agentRemoteId.code", config.getInt("dhcp.82.remoteIdOptionCode", 2));
        this.option82RemoteIdExtractor = EXTRACTOR_FACTORY.getExtractor(config, "dhcp.option82.agentRemoteId.");
        this.option82RemoteIdPosition = config.getInt("dhcp.option82.agentRemoteId.position", config.getInt("dhcp.82.remoteIdPosition", 2));
        this.option82RemoteIdLength = config.getInt("dhcp.option82.agentRemoteId.length", config.getInt("dhcp.82.remoteIdLength", 6));
        this.option82RemoteIdType = config.getInt("dhcp.option82.agentRemoteId.type", 0);
        this.option82LoginCode = (byte)config.getInt("dhcp.option82.login.code", -1);
        this.option82LoginExtractor = EXTRACTOR_FACTORY.getExtractor(config, "dhcp.option82.login.");
        this.option82RemoveHeader = config.getInt("dhcp.option82.removeHeader", 0);
        int radiusVendor = config.getInt("radius.vendor", config.getInt("nas.vendor", 0));
        this.radiusAgentRemoteIdVendor = config.getInt("radius.agentRemoteId.vendor", config.getInt("radius.option82.agentRemoteId.vendor", radiusVendor));
        this.radiusAgentRemoteIdType = config.getInt("radius.agentRemoteId.type", config.getInt("radius.option82.agentRemoteId.type", -1));
        this.radiusAgentRemoteIdPrefix = config.get("radius.agentRemoteId.prefix", config.get("radius.option82.agentRemoteId.prefix", null));
        try {
            pattern = config.get("radius.agentRemoteId.pattern", config.get("radius.option82.agentRemoteId.pattern", null));
            if (pattern != null) {
                this.radiusAgentRemoteIdPattern = Pattern.compile(pattern);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.radiusAgentRemoteIdExtractor = EXTRACTOR_FACTORY.getExtractor(config, "radius.option82.agentRemoteId.");
        this.radiusCircuitIdVendor = config.getInt("radius.option82.circuitId.vendor", radiusVendor);
        this.radiusCircuitIdType = config.getInt("radius.option82.circuitId.type", -1);
        this.radiusCircuitIdPrefix = config.get("radius.option82.circuitId.prefix", null);
        try {
            pattern = config.get("radius.option82.circuitId.pattern", null);
            if (pattern != null) {
                this.radiusCircuitIdPattern = Pattern.compile(pattern);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.radiusCircuitIdExtractor = EXTRACTOR_FACTORY.getExtractor(config, "radius.option82.circuitId.");
        this.macAddressVendor = config.getInt("radius.macAddress.vendor", radiusVendor);
        this.macAddressType = config.getInt("radius.macAddress.type", -1);
        this.macAddressPrefix = config.get("radius.macAddress.prefix", null);
        try {
            pattern = config.get("radius.macAddress.pattern", null);
            if (pattern != null) {
                this.macAddressPattern = Pattern.compile(pattern);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.callingStationIdVendor = config.getInt("radius.callingStationId.vendor", radiusVendor);
        this.callingStationIdType = config.getInt("radius.callingStationId.type", -1);
        this.callingStationIdPrefix = config.get("radius.callingStationId.prefix", null);
        this.calledStationIdVendor = config.getInt("radius.calledStationId.vendor", radiusVendor);
        this.calledStationIdType = config.getInt("radius.calledStationId.type", -1);
        this.calledStationIdPrefix = config.get("radius.calledStationId.prefix", null);
        this.vlanVendor = config.getInt("radius.vlan.vendor", radiusVendor);
        this.vlanType = config.getInt("radius.vlan.type", -1);
        this.vlanPrefix = config.get("radius.vlan.prefix", null);
        try {
            pattern = config.get("radius.vlan.pattern", null);
            if (pattern != null) {
                this.vlanPattern = Pattern.compile(pattern);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.agentSvlanVendor = config.getInt("radius.agentSvlan.vendor", radiusVendor);
        this.agentSvlanType = config.getInt("radius.agentSvlan.type", -1);
        this.agentSvlanPrefix = config.get("radius.agentSvlan.prefix", null);
        try {
            pattern = config.get("radius.agentSvlan.pattern", null);
            if (pattern != null) {
                this.agentSvlanPattern = Pattern.compile(pattern);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public int convertToInt(Object value, int def) {
        return BinaryValueExtractor.convertToInt((Object)value, (int)def);
    }

    public byte[] convertToInt(Object data) {
        return BinaryValueExtractor.convertToBytes((Object)data);
    }

    public Object getOption82AgentRemoteId(DhcpPacket request, boolean setOption) {
        Object result = request.getOption(InetAbstractDhcpProcessor.AGENT_REMOTE_ID);
        if (result != null) {
            return result;
        }
        result = this.extractOption82AgentRemoteId(request);
        if (setOption && result != null) {
            request.setOption(InetAbstractDhcpProcessor.AGENT_REMOTE_ID, result);
        }
        return result;
    }

    public Object extractOption82AgentRemoteId(DhcpPacket request) {
        try {
            int length;
            String value;
            if (this.option82RemoteIdCode <= 0) {
                return null;
            }
            DhcpOption subOption = request.getSubOption(this.option82RemoteIdCode);
            if (subOption == null) {
                return null;
            }
            if (this.option82RemoteIdExtractor != null && (value = this.option82RemoteIdExtractor.extractString(subOption.value, null)) != null) {
                return value;
            }
            int position = this.option82RemoteIdPosition >= 0 ? this.option82RemoveHeader + this.option82RemoteIdPosition : (subOption.value.length >= 2 && subOption.value[0] == 0 && subOption.value[1] == 6 ? 2 : 0);
            int n = length = this.option82RemoteIdLength > 0 ? this.option82RemoteIdLength : subOption.value.length - position;
            if (this.option82RemoteIdLength > 0 && position + length > subOption.value.length) {
                position -= this.option82RemoveHeader;
            }
            byte[] value2 = new byte[length];
            System.arraycopy(subOption.value, position, value2, 0, length);
            if (this.option82RemoteIdType == 1) {
                return new String(value2, StandardCharsets.UTF_8);
            }
            return value2;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing agentRemoteId from DHCP-request. Check dhcp.option82.agentRemoteId... and dhcp.option82.removeHeader parameters.");
            throw ex;
        }
    }

    public Object getAgentRemoteId(RadiusPacket request) {
        Object result = request.getOption(InetRadiusProcessor.AGENT_REMOTE_ID);
        if (result != null) {
            return result;
        }
        if (this.radiusAgentRemoteIdType < 0) {
            return null;
        }
        try {
            result = request.getAttributeValue(this.radiusAgentRemoteIdVendor, this.radiusAgentRemoteIdType, this.radiusAgentRemoteIdPrefix, this.radiusAgentRemoteIdPattern, null);
            if (result == null) {
                return null;
            }
            if (this.radiusAgentRemoteIdExtractor != null) {
                result = this.radiusAgentRemoteIdExtractor.extractString(BinaryValueExtractor.convertToBytes((Object)result), null);
            }
            if (result != null) {
                request.setOption(InetRadiusProcessor.AGENT_REMOTE_ID, result);
            }
            return result;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing AgentRemoteId from RADIUS-request. Check radius.option82.agentRemoteId... parameters.");
            throw ex;
        }
    }

    public Object getOption82CircuitId(RadiusPacket request) {
        Object result = request.getOption(InetRadiusProcessor.AGENT_CIRCUIT_ID);
        if (result != null) {
            return result;
        }
        if (this.radiusCircuitIdType < 0) {
            return null;
        }
        try {
            result = request.getAttributeValue(this.radiusCircuitIdVendor, this.radiusCircuitIdType, this.radiusCircuitIdPrefix, this.radiusCircuitIdPattern, null);
            if (result == null) {
                return null;
            }
            if (this.radiusCircuitIdExtractor != null) {
                result = this.radiusCircuitIdExtractor.extractString(BinaryValueExtractor.convertToBytes((Object)result), null);
            }
            if (result != null) {
                request.setOption(InetRadiusProcessor.AGENT_CIRCUIT_ID, result);
            }
            return result;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing CircuitId from RADIUS-request. Check radius.option82.circuitId... parameters.");
            throw ex;
        }
    }

    public int getOption82VlanId(DhcpPacket request, boolean setOption) {
        int result;
        Object idObj = request.getOption(InetAbstractDhcpProcessor.VLAN_ID);
        if (idObj != null && (result = BinaryValueExtractor.convertToInt((Object)idObj, (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            return result;
        }
        result = this.extractOption82VlanId(request);
        if (setOption && result >= 0) {
            request.setOption(InetAbstractDhcpProcessor.VLAN_ID, (Object)result);
        }
        return result;
    }

    public int getOption82AgentSvlanId(DhcpPacket request, boolean setOption) {
        int result;
        Object idObj = request.getOption(InetAbstractDhcpProcessor.AGENT_SVLAN);
        if (idObj != null && (result = BinaryValueExtractor.convertToInt((Object)idObj, (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            return result;
        }
        result = this.extractOption82AgentSvlanId(request);
        if (setOption && result >= 0) {
            request.setOption(InetAbstractDhcpProcessor.AGENT_SVLAN, (Object)result);
        }
        return result;
    }

    public int extractOption82VlanId(DhcpPacket request) {
        return PacketValueExtractor.extractOption82VlanId(request, InetAbstractDhcpProcessor.VLAN_ID, this.option82VlanIdCode, this.option82VlanIdPosition, this.option82VlanIdLength, this.option82RemoveHeader, this.option82VlanIdExtractor);
    }

    public int extractOption82AgentSvlanId(DhcpPacket request) {
        return PacketValueExtractor.extractOption82VlanId(request, InetAbstractDhcpProcessor.AGENT_SVLAN, this.option82SvlanIdCode, this.option82SvlanIdPosition, this.option82SvlanIdLength, this.option82RemoveHeader, this.option82SvlanIdExtractor);
    }

    private static int extractOption82VlanId(DhcpPacket request, DhcpPacket.DhcpPacketOption<Object> option, byte option82VlanIdCode, int option82VlanIdPosition, int option82VlanIdLength, int option82RemoveHeader, BinaryValueExtractor option82VlanIdExtractor) {
        try {
            int result;
            if (option82VlanIdPosition < 0 && option82VlanIdExtractor == null) {
                return -1;
            }
            byte[] agentCircuitId = BinaryValueExtractor.convertToBytes((Object)request.getOption(InetAbstractDhcpProcessor.AGENT_CIRCUIT_ID));
            if (agentCircuitId != null) {
                int result2;
                if (option82VlanIdExtractor != null && (result2 = option82VlanIdExtractor.extractInt(agentCircuitId, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                    return result2;
                }
                if (option82VlanIdPosition >= 0) {
                    return InetUtils.parseInt(agentCircuitId, option82VlanIdPosition, option82VlanIdLength);
                }
                return -1;
            }
            DhcpOption subOption = request.getSubOption(option82VlanIdCode);
            if (subOption == null) {
                return -1;
            }
            if (option82VlanIdExtractor != null && (result = option82VlanIdExtractor.extractInt(subOption.value, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                return result;
            }
            if (option82VlanIdPosition >= 0) {
                return InetUtils.parseInt(subOption.value, option82RemoveHeader + option82VlanIdPosition, option82VlanIdLength);
            }
            return -1;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing VLAN from DHCP-request. Check dhcp.option82.vlanId... and dhcp.option82.removeHeader parameters.");
            throw ex;
        }
    }

    public int getOption82VlanId(RadiusPacket request, boolean setOption) {
        int result;
        Object idObj = request.getOption(InetRadiusProcessor.VLAN_ID);
        if (idObj != null && (result = BinaryValueExtractor.convertToInt((Object)idObj, (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            return result;
        }
        result = this.extractOption82VlanId(request);
        if (setOption && result >= 0) {
            request.setOption(InetRadiusProcessor.VLAN_ID, (Object)String.valueOf(result));
        }
        return result;
    }

    public int extractOption82VlanId(RadiusPacket request) {
        try {
            int result;
            if (this.option82VlanIdExtractor == null && this.option82VlanIdPosition < 0) {
                return -1;
            }
            byte[] agentCircuitId = BinaryValueExtractor.convertToBytes((Object)this.getOption82CircuitId(request));
            if (agentCircuitId == null) {
                return -1;
            }
            if (this.option82VlanIdExtractor != null && (result = this.option82VlanIdExtractor.extractInt(agentCircuitId, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                return result;
            }
            if (this.option82VlanIdPosition >= 0) {
                return InetUtils.parseInt(agentCircuitId, this.option82VlanIdPosition, this.option82VlanIdLength);
            }
            return -1;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing VLAN from RADIUS-request. Check dhcp.option82.vlanId..., radius.agent.option.circuitId... and radius.agent.option.removeHeader parameters.");
            throw ex;
        }
    }

    public int getVlanId(RadiusPacket request, boolean setOption) {
        int result;
        Object idObj = request.getOption(InetRadiusProcessor.VLAN_ID);
        if (idObj != null && (result = BinaryValueExtractor.convertToInt((Object)idObj, (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            return result;
        }
        result = this.extractVlanId(request);
        if (setOption && result >= 0) {
            request.setOption(InetRadiusProcessor.VLAN_ID, (Object)String.valueOf(result));
        }
        return result;
    }

    public int extractVlanId(RadiusPacket request) {
        try {
            int result;
            String vlanString;
            int result2;
            Object vlanObject;
            if (this.vlanType > 0 && (vlanObject = request.getAttributeValue(this.vlanVendor, this.vlanType, this.vlanPrefix, (Object)this.vlanPattern)) != null && (result2 = Utils.parseInt((String)(vlanString = String.valueOf(vlanObject)), (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                return result2;
            }
            if (this.option82VlanIdExtractor == null && this.option82VlanIdPosition < 0) {
                return -1;
            }
            byte[] agentCircuitId = BinaryValueExtractor.convertToBytes((Object)this.getOption82CircuitId(request));
            if (agentCircuitId == null) {
                return -1;
            }
            if (this.option82VlanIdExtractor != null && (result = this.option82VlanIdExtractor.extractInt(agentCircuitId, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                return result;
            }
            if (this.option82VlanIdPosition >= 0) {
                return InetUtils.parseInt(agentCircuitId, this.option82VlanIdPosition, this.option82VlanIdLength);
            }
            return -1;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing VLAN from RADIUS-request. Check dhcp.option82.vlanId..., radius.agent.option.circuitId... and radius.agent.option.removeHeader parameters.");
            throw ex;
        }
    }

    public int getAgentSvlanId(RadiusPacket request, boolean setOption) {
        int result;
        Object idObj = request.getOption(InetRadiusProcessor.AGENT_SVLAN);
        if (idObj != null && (result = BinaryValueExtractor.convertToInt((Object)idObj, (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            return result;
        }
        result = this.extractAgentSvlanId(request);
        if (setOption && result >= 0) {
            request.setOption(InetRadiusProcessor.AGENT_SVLAN, (Object)String.valueOf(result));
        }
        return result;
    }

    public int extractAgentSvlanId(RadiusPacket request) {
        try {
            int result;
            String vlanString;
            int result2;
            Object vlanObject;
            if (this.agentSvlanType > 0 && (vlanObject = request.getAttributeValue(this.agentSvlanVendor, this.agentSvlanType, this.agentSvlanPrefix, (Object)this.agentSvlanPattern)) != null && (result2 = Utils.parseInt((String)(vlanString = String.valueOf(vlanObject)), (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                return result2;
            }
            if (this.option82SvlanIdExtractor == null && this.option82SvlanIdPosition < 0) {
                return -1;
            }
            byte[] agentCircuitId = BinaryValueExtractor.convertToBytes((Object)this.getOption82CircuitId(request));
            if (agentCircuitId == null) {
                return -1;
            }
            if (this.option82SvlanIdExtractor != null && (result = this.option82SvlanIdExtractor.extractInt(agentCircuitId, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                return result;
            }
            if (this.option82SvlanIdPosition >= 0) {
                return InetUtils.parseInt(agentCircuitId, this.option82SvlanIdPosition, this.option82SvlanIdLength);
            }
            return -1;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing SVLAN from RADIUS-request. Check dhcp.option82.vlanId..., radius.agent.option.circuitId... and radius.agent.option.removeHeader parameters.");
            throw ex;
        }
    }

    public int getOption82InterfaceId(DhcpPacket request, boolean setOption) {
        int result;
        Object idObj = request.getOption(InetAbstractDhcpProcessor.INTERFACE_ID);
        if (idObj != null && (result = BinaryValueExtractor.convertToInt((Object)idObj, (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            return result;
        }
        result = this.extractOption82InterfaceId(request);
        if (setOption && result >= 0) {
            request.setOption(InetAbstractDhcpProcessor.INTERFACE_ID, (Object)result);
        }
        return result;
    }

    public int extractOption82InterfaceId(DhcpPacket request) {
        try {
            int result;
            if (this.option82InterfaceIdExtractor == null && this.option82InterfaceIdPosition < 0) {
                return -1;
            }
            byte[] agentCircuitId = BinaryValueExtractor.convertToBytes((Object)request.getOption(InetAbstractDhcpProcessor.AGENT_CIRCUIT_ID));
            if (agentCircuitId != null) {
                int result2;
                if (this.option82InterfaceIdExtractor != null && (result2 = this.option82InterfaceIdExtractor.extractInt(agentCircuitId, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                    return result2;
                }
                if (this.option82InterfaceIdPosition >= 0) {
                    return InetUtils.parseInt(agentCircuitId, this.option82InterfaceIdPosition, this.option82InterfaceIdLength);
                }
                return -1;
            }
            DhcpOption subOption = request.getSubOption(this.option82InterfaceIdCode);
            if (subOption == null) {
                return -1;
            }
            if (this.option82InterfaceIdExtractor != null && (result = this.option82InterfaceIdExtractor.extractInt(subOption.value, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                return result;
            }
            if (this.option82InterfaceIdPosition >= 0) {
                try {
                    return InetUtils.parseInt(subOption.value, this.option82RemoveHeader + this.option82InterfaceIdPosition, this.option82InterfaceIdLength);
                }
                catch (Exception ex) {
                    return InetUtils.parseInt(subOption.value, this.option82InterfaceIdPosition, this.option82InterfaceIdLength);
                }
            }
            return -1;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing ifaceId from DHCP-request. Check dhcp.option82.interfaceId... and dhcp.option82.removeHeader parameters.");
            throw ex;
        }
    }

    public int getOption82InterfaceId(RadiusPacket request, boolean setOption) {
        int result;
        Object idObj = request.getOption(InetRadiusProcessor.INTERFACE_ID);
        if (idObj != null && (result = BinaryValueExtractor.convertToInt((Object)idObj, (int)Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            return result;
        }
        result = this.extractOption82InterfaceId(request);
        if (setOption && result >= 0) {
            request.setOption(InetRadiusProcessor.INTERFACE_ID, (Object)result);
        }
        return result;
    }

    public int extractOption82InterfaceId(RadiusPacket request) {
        try {
            int result;
            if (this.option82InterfaceIdExtractor == null && this.option82InterfaceIdPosition < 0) {
                return -1;
            }
            byte[] agentCircuitId = BinaryValueExtractor.convertToBytes((Object)this.getOption82CircuitId(request));
            if (agentCircuitId == null) {
                return -1;
            }
            if (this.option82InterfaceIdExtractor != null && (result = this.option82InterfaceIdExtractor.extractInt(agentCircuitId, Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                return result;
            }
            if (this.option82InterfaceIdPosition >= 0) {
                return InetUtils.parseInt(agentCircuitId, this.option82InterfaceIdPosition, this.option82InterfaceIdLength);
            }
            return -1;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing ifaceId from RADIUS-request. Check dhcp.option82.interfaceId..., radius.agent.option.circuitId... and radius.agent.option.removeHeader parameters.");
            throw ex;
        }
    }

    public Object getOption82Login(DhcpPacket request, boolean setOption) {
        try {
            Object result = request.getOption(InetDhcpProcessor.LOGIN);
            if (result != null) {
                return result;
            }
            if (this.option82LoginCode < 0 || this.option82LoginExtractor == null) {
                return null;
            }
            DhcpOption subOption = request.getSubOption(this.option82LoginCode);
            if (subOption == null) {
                return null;
            }
            String result2 = this.option82LoginExtractor.extractString(subOption.value, null);
            if (result2 != null && setOption) {
                request.setOption(InetDhcpProcessor.LOGIN, (Object)result2);
            }
            return result2;
        }
        catch (RuntimeException ex) {
            logger.error("Error while parsing agentRemoteId from DHCP-request. Check dhcp.option82.login... parameters.");
            throw ex;
        }
    }

    public Object getOption82Login(DhcpPacket request) {
        return this.getOption82Login(request, false);
    }

    public void setCallingStationIdAttribute(RadiusPacket request) {
        Object result;
        if (this.callingStationIdType > 0 && (result = request.getAttributeValue(this.callingStationIdVendor, this.callingStationIdType, this.callingStationIdPrefix, null, null)) != null) {
            request.setStringAttribute(-1, 31, String.valueOf(result));
        }
    }

    public Object extractCallingStationId(RadiusPacket request) {
        if (this.callingStationIdType > 0) {
            return request.getAttributeValue(this.callingStationIdVendor, this.callingStationIdType, this.callingStationIdPrefix, null, null);
        }
        return request.getAttributeValue(-1, 31, null, null, null);
    }

    public void setCalledStationIdAttribute(RadiusPacket request) {
        Object result;
        if (this.calledStationIdType > 0 && (result = this.extractCalledStationId(request)) != null) {
            request.setStringAttribute(-1, 30, String.valueOf(result));
        }
    }

    public Object extractCalledStationId(RadiusPacket request) {
        if (this.calledStationIdType > 0) {
            return request.getAttributeValue(this.calledStationIdVendor, this.calledStationIdType, this.calledStationIdPrefix, null, null);
        }
        return request.getAttributeValue(-1, 30, null, null, null);
    }

    public void setMacAddressOption(RadiusPacket request) {
        Object result;
        if (this.macAddressType > 0 && (result = this.extractMacAddress(request)) != null) {
            if (result instanceof byte[]) {
                request.setOption(InetRadiusProcessor.MAC_ADDRESS_BYTES, (Object)((byte[])result));
            } else {
                request.setOption(InetRadiusProcessor.MAC_ADDRESS, (Object)((String)result));
            }
        }
    }

    public Object extractMacAddress(RadiusPacket request) {
        if (this.macAddressType > 0) {
            return request.getAttributeValue(this.macAddressVendor, this.macAddressType, this.macAddressPrefix, this.macAddressPattern, (Object)this.macAddressPattern);
        }
        return null;
    }

    public BinaryValueExtractor getExtractor(ParameterMap params, String prefix) {
        return EXTRACTOR_FACTORY.getExtractor(params, prefix);
    }
}

