/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RangeCleaner;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeRecalculateManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class TrafficRangeRecalculateManager
extends RangeRecalculateManager
implements RangeCleaner {
    public TrafficRangeRecalculateManager(Connection con, Date dateFrom, Date dateTo, int moduleId, RangeManager manager) throws SQLException {
        super(con, dateFrom, dateTo, moduleId, manager);
    }

    protected void initTableNames(Date dateFrom, int moduleId) {
        this.trafficRangeTableName = ServerUtils.getModuleTableName((String)"inet_tariff_traffic_range", (int)moduleId);
        this.trafficRangeDetailTableName = ServerUtils.getModuleMonthTableName((String)"inet_tariff_traffic_range_detail", (Date)dateFrom, (int)moduleId);
    }

    @Override
    public void removeAllExtraData(Date month, Set<Integer> cids, int idDivizor, int idRemainder, Set<Integer> affectedContracts) throws BGException, SQLException {
        String andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts);
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM  " + this.trafficRangeDetailTableName + " WHERE 1=1 " + andCidPartWithAffected.replace("cid", "contractId"));
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 1, cids, idDivizor, idRemainder);
        ps.executeUpdate();
        ps.close();
        Calendar cal = TimeUtils.convertDateToCalendar((Date)month);
        int yy = cal.get(1);
        int mm = cal.get(2) + 1;
        String query = "DELETE FROM  " + this.trafficRangeTableName + " WHERE 1=1  AND yy = ? AND mm = ? " + andCidPartWithAffected.replace("cid", "contractId");
        ps = this.con.prepareStatement(query);
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 3, cids, idDivizor, idRemainder);
        ps.executeUpdate();
        ps.close();
    }
}

