/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean.pattern;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTableExtractMethod;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariableType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class DocumentsPatternDao
extends AbstractIdDao<DocumentPattern> {
    private static final String PATTERN_TABLE = "documents_pattern";
    private static final String VARIABLES_TABLE = "documents_pattern_variables";
    private static final String TABLES_TABLE = "documents_pattern_tables";
    private static final String DOMAINS_TABLE = "documents_pattern_domains";
    private Connection con;

    public DocumentsPatternDao(Connection con) {
        super(con, 0, PATTERN_TABLE);
        this.con = con;
    }

    public List<DocumentPattern> getPatternList() throws BGException {
        List result = this.list("", "pos, title", new Object[0]);
        for (DocumentPattern pattern : result) {
            pattern.setDomainList(this.getDomainList(pattern.getId()));
        }
        return result;
    }

    public DocumentPattern getPattern(int patternId) throws BGException {
        DocumentPattern result;
        try {
            result = (DocumentPattern)this.getImpl(patternId);
            result.setVariableList(this.getVariableList(patternId));
            result.setTableList(this.getTableList(patternId));
            result.setDomainList(this.getDomainList(patternId));
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<DocumentVariable> getVariableList(int patternId) throws BGException {
        ArrayList<DocumentVariable> result = new ArrayList<DocumentVariable>();
        String query = "SELECT * FROM documents_pattern_variables WHERE pattern_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, patternId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getDocumentVariableFromRS(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private void updateVariableList(int patternId, List<DocumentVariable> variableList) throws BGException {
        if (variableList != null) {
            this.deleteVariableList(patternId);
            String query = "INSERT INTO documents_pattern_variables SET pattern_id=?, title=?, type=?, additional_param=?, value=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                for (DocumentVariable documentVariable : variableList) {
                    int index = 1;
                    ps.setInt(index++, patternId);
                    ps.setString(index++, documentVariable.getTitle());
                    ps.setInt(index++, documentVariable.getType().getTypeId());
                    ps.setString(index++, documentVariable.getAdditionalParam());
                    ps.setString(index++, documentVariable.getValue());
                    ps.executeUpdate();
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void deleteVariableList(int patternId) throws BGException {
        this.deleteFor(patternId, VARIABLES_TABLE);
    }

    public List<Integer> getDomainList(int patternId) throws BGException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String query = "SELECT * FROM documents_pattern_domains WHERE pattern_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, patternId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getInt("domain_id"));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private void updateDomainList(int patternId, List<Integer> domainList) throws BGException {
        this.deleteDomainList(patternId);
        if (domainList != null) {
            String query = "INSERT INTO documents_pattern_domains (pattern_id, domain_id) VALUES (?,?)";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                for (Integer domain : domainList) {
                    int index = 1;
                    ps.setInt(index++, patternId);
                    ps.setInt(index++, domain);
                    ps.executeUpdate();
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void deleteDomainList(int patternId) throws BGException {
        this.deleteFor(patternId, DOMAINS_TABLE);
    }

    public List<DocumentTable> getTableList(int patternId) throws BGException {
        ArrayList<DocumentTable> result = new ArrayList<DocumentTable>();
        String query = "SELECT * FROM documents_pattern_tables WHERE pattern_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, patternId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getDocumentTableFromRS(rs));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private void updateTableList(int patternId, List<DocumentTable> tableList) throws BGException {
        if (tableList != null) {
            this.deleteTableList(patternId);
            String query = "INSERT INTO documents_pattern_tables (pattern_id, title, identifier, extract_method, value) VALUES (?,?,?,?,?)";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                for (DocumentTable documentTable : tableList) {
                    int index = 1;
                    ps.setInt(index++, patternId);
                    ps.setString(index++, documentTable.getTitle());
                    ps.setString(index++, documentTable.getIdentifier());
                    ps.setInt(index++, documentTable.getExtractMethod().getId());
                    ps.setString(index++, documentTable.getValue());
                    ps.executeUpdate();
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    private void deleteTableList(int patternId) throws BGException {
        this.deleteFor(patternId, TABLES_TABLE);
    }

    private void deleteFor(int patternId, String table) throws BGException {
        String query = "DELETE FROM " + table + " WHERE pattern_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, patternId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private DocumentVariable getDocumentVariableFromRS(ResultSet rs) throws SQLException {
        DocumentVariable result = new DocumentVariable();
        result.setTitle(rs.getString("title"));
        result.setType(DocumentVariableType.getType((int)rs.getInt("type")));
        result.setAdditionalParam(rs.getString("additional_param"));
        result.setValue(rs.getString("value"));
        return result;
    }

    private DocumentTable getDocumentTableFromRS(ResultSet rs) throws SQLException {
        DocumentTable result = new DocumentTable();
        result.setTitle(rs.getString("title"));
        result.setIdentifier(rs.getString("identifier"));
        result.setExtractMethod(DocumentTableExtractMethod.getType((int)rs.getInt("extract_method")));
        result.setValue(rs.getString("value"));
        return result;
    }

    protected DocumentPattern getFromRS(ResultSet rs) throws SQLException, BGException {
        DocumentPattern result = new DocumentPattern();
        result.setId(rs.getInt("id"));
        result.setPos(rs.getInt("pos"));
        result.setTitle(rs.getString("title"));
        result.setGeneratedFileNamePattern(rs.getString("generated_file_name"));
        result.setFileComment(rs.getString("file_comment"));
        result.setDocumentName(rs.getString("output_name"));
        result.setDocumentComment(rs.getString("document_comment"));
        result.setVisibleInPlugin(rs.getBoolean("use_in_plugin"));
        result.setDataExtractorClass(rs.getString("extractor_class"));
        result.setComment(rs.getString("comment"));
        result.setUserId(rs.getInt("user"));
        result.setCreatePatternDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("create_date")));
        result.setLastModifyPatternDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("last_modify_date")));
        return result;
    }

    protected void updateImpl(DocumentPattern b) throws BGException, SQLException {
        String query = b.getId() > 0 ? "UPDATE documents_pattern SET title=?, generated_file_name=?, output_name=?, use_in_plugin=?, extractor_class=?, comment=?, user=?,last_modify_date=NOW(), file_comment=?, document_comment=? WHERE id=?" : "INSERT INTO documents_pattern(title, generated_file_name, output_name, use_in_plugin, extractor_class,comment,user,create_date,last_modify_date, file_comment, document_comment) VALUES (?,?, ?, ?, ?, ?,?,NOW(),NOW(), ?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            ps.setString(index++, b.getGeneratedFileNamePattern());
            ps.setString(index++, b.getDocumentName());
            ps.setBoolean(index++, b.isVisibleInPlugin());
            ps.setString(index++, b.getDataExtractorClass());
            ps.setString(index++, b.getComment());
            ps.setInt(index++, b.getUserId());
            ps.setString(index++, b.getFileComment());
            ps.setString(index++, b.getDocumentComment());
            if (b.getId() > 0) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (b.getId() <= 0) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        this.updateVariableList(b.getId(), b.getVariableList());
        this.updateTableList(b.getId(), b.getTableList());
        this.updateDomainList(b.getId(), b.getDomainList());
    }

    public void updatePos(List<int[]> idPosList) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE documents_pattern SET pos=? WHERE id=?");){
            for (int[] idPos : idPosList) {
                ps.setInt(1, idPos[1]);
                ps.setInt(2, idPos[0]);
                ps.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

